/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.secrets;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.debug.Debug;
import de.hysky.skyblocker.events.DungeonEvents;
import de.hysky.skyblocker.skyblock.dungeon.DungeonBoss;
import de.hysky.skyblocker.skyblock.dungeon.DungeonMap;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DebugRoom;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonMapUtils;
import de.hysky.skyblocker.skyblock.dungeon.secrets.Room;
import de.hysky.skyblocker.skyblock.dungeon.secrets.SecretWaypoint;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.command.argumenttypes.blockpos.ClientBlockPosArgumentType;
import de.hysky.skyblocker.utils.command.argumenttypes.blockpos.ClientPosArgument;
import de.hysky.skyblocker.utils.render.RenderHelper;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import it.unimi.dsi.fastutil.objects.Object2ByteMap;
import it.unimi.dsi.fastutil.objects.Object2ByteMaps;
import it.unimi.dsi.fastutil.objects.Object2ByteOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.InflaterInputStream;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1421;
import net.minecraft.class_1531;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_2172;
import net.minecraft.class_2178;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3965;
import net.minecraft.class_7157;
import net.minecraft.class_9209;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DungeonManager {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DungeonManager.class);
    private static final String DUNGEONS_PATH = "dungeons";
    private static Path CUSTOM_WAYPOINTS_DIR;
    private static final Pattern KEY_FOUND;
    private static final Pattern WITHER_DOOR_OPENED;
    private static final String BLOOD_DOOR_OPENED = "The BLOOD DOOR has been opened!";
    protected static final float[] RED_COLOR_COMPONENTS;
    protected static final float[] GREEN_COLOR_COMPONENTS;
    protected static final Object2ByteMap<String> NUMERIC_ID;
    protected static final HashMap<String, Map<String, Map<String, int[]>>> ROOMS_DATA;
    @NotNull
    private static final Map<Vector2ic, Room> rooms;
    private static final Map<String, JsonElement> roomsJson;
    private static final Map<String, JsonElement> waypointsJson;
    private static final Table<String, class_2338, SecretWaypoint> customWaypoints;
    @Nullable
    private static CompletableFuture<Void> roomsLoaded;
    @Nullable
    private static Vector2ic mapEntrancePos;
    private static int mapRoomSize;
    @Nullable
    private static Vector2ic physicalEntrancePos;
    private static Room currentRoom;
    @NotNull
    private static DungeonBoss boss;
    @Nullable
    private static class_238 bloodRushDoorBox;
    private static boolean bloodOpened;
    private static boolean hasKey;

    public static boolean isRoomsLoaded() {
        return roomsLoaded != null && roomsLoaded.isDone();
    }

    public static Stream<Room> getRoomsStream() {
        return rooms.values().stream();
    }

    public static JsonObject getRoomMetadata(String room) {
        JsonElement value = roomsJson.get(room);
        return value != null ? value.getAsJsonObject() : null;
    }

    public static JsonArray getRoomWaypoints(String room) {
        JsonElement value = waypointsJson.get(room);
        return value != null ? value.getAsJsonArray() : null;
    }

    public static Map<class_2338, SecretWaypoint> getCustomWaypoints(String room) {
        return customWaypoints.row((Object)room);
    }

    public static SecretWaypoint addCustomWaypoint(String room, SecretWaypoint waypoint) {
        return (SecretWaypoint)customWaypoints.put((Object)room, (Object)waypoint.pos, (Object)waypoint);
    }

    public static void addCustomWaypoints(String room, Collection<SecretWaypoint> waypoints) {
        for (SecretWaypoint waypoint : waypoints) {
            DungeonManager.addCustomWaypoint(room, waypoint);
        }
    }

    @Nullable
    public static SecretWaypoint removeCustomWaypoint(String room, class_2338 pos) {
        return (SecretWaypoint)customWaypoints.remove((Object)room, (Object)pos);
    }

    @Nullable
    public static Vector2ic getMapEntrancePos() {
        return mapEntrancePos;
    }

    public static int getMapRoomSize() {
        return mapRoomSize;
    }

    @Nullable
    public static Vector2ic getPhysicalEntrancePos() {
        return physicalEntrancePos;
    }

    public static Room getCurrentRoom() {
        return currentRoom;
    }

    @NotNull
    public static DungeonBoss getBoss() {
        return boss;
    }

    public static boolean isInBoss() {
        return boss.isInBoss();
    }

    @Init
    public static void init() {
        CUSTOM_WAYPOINTS_DIR = SkyblockerMod.CONFIG_DIR.resolve("custom_secret_waypoints.json");
        CompletableFuture.runAsync(DungeonManager::load, (Executor)class_310.method_1551()).exceptionally(e -> {
            LOGGER.error("[Skyblocker Dungeon Secrets] Failed to load dungeon secrets", e);
            return null;
        });
        ClientLifecycleEvents.CLIENT_STOPPING.register(DungeonManager::saveCustomWaypoints);
        Scheduler.INSTANCE.scheduleCyclic(DungeonManager::update, 5);
        WorldRenderEvents.AFTER_TRANSLUCENT.register(DungeonManager::render);
        ClientReceiveMessageEvents.ALLOW_GAME.register(DungeonManager::onChatMessage);
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> DungeonManager.onUseBlock(world, hitResult));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)DUNGEONS_PATH).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"secrets").then(ClientCommandManager.literal((String)"markAsFound").then(DungeonManager.markSecretsCommand(true)))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"markAsMissing").then(DungeonManager.markSecretsCommand(false))).then(DungeonManager.markAllSecretsAsMissingCommand()))).then(ClientCommandManager.literal((String)"getRelativePos").executes(DungeonManager::getRelativePos))).then(ClientCommandManager.literal((String)"getRelativeTargetPos").executes(DungeonManager::getRelativeTargetPos))).then(ClientCommandManager.literal((String)"addWaypoint").then(DungeonManager.addCustomWaypointCommand(false, registryAccess)))).then(ClientCommandManager.literal((String)"addWaypointRelatively").then(DungeonManager.addCustomWaypointCommand(true, registryAccess)))).then(ClientCommandManager.literal((String)"removeWaypoint").then(DungeonManager.removeCustomWaypointCommand(false)))).then(ClientCommandManager.literal((String)"removeWaypointRelatively").then(DungeonManager.removeCustomWaypointCommand(true)))))));
        if (Debug.debugEnabled()) {
            ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)DUNGEONS_PATH).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"secrets").then(ClientCommandManager.literal((String)"matchAgainst").then(DungeonManager.matchAgainstCommand()))).then(ClientCommandManager.literal((String)"clearSubProcesses").executes(context -> {
                if (currentRoom != null) {
                    DungeonManager.currentRoom.tickables.clear();
                    DungeonManager.currentRoom.renderables.clear();
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_27693("\u00a7rCleared sub processes in the current room."));
                } else {
                    ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_27693("\u00a7cCurrent room is null."));
                }
                return 1;
            }))).then(ClientCommandManager.literal((String)"getCheckmarkColour").executes(context -> {
                class_22 state = DungeonManager.getMapState(((FabricClientCommandSource)context.getSource()).getClient());
                if (currentRoom != null && state != null) {
                    String string;
                    int checkmarkColour = DungeonManager.getRoomCheckmarkColour(((FabricClientCommandSource)context.getSource()).getClient(), state, currentRoom);
                    Integer n = checkmarkColour;
                    Objects.requireNonNull(n);
                    Integer n2 = n;
                    int n3 = 0;
                    block4: while (true) {
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Integer.class}, (Object)n2, n3)) {
                            case 0: {
                                Integer i = n2;
                                if (i != DungeonMapUtils.WHITE_COLOR) {
                                    n3 = 1;
                                    continue block4;
                                }
                                string = "White";
                                break block4;
                            }
                            case 1: {
                                Integer i = n2;
                                if (i != 30) {
                                    n3 = 2;
                                    continue block4;
                                }
                                string = "Green";
                                break block4;
                            }
                            default: {
                                string = "Unknown";
                                break block4;
                            }
                        }
                        break;
                    }
                    String result = string;
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_27693("\u00a7rCheckmark colour: " + result));
                } else {
                    ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_27693("\u00a7cCurrent room or map state is null."));
                }
                return 1;
            }))))));
        }
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> DungeonManager.reset());
    }

    private static void load() {
        long startTime = System.currentTimeMillis();
        ArrayList<CompletionStage> dungeonFutures = new ArrayList<CompletionStage>();
        for (Map.Entry resourceEntry : class_310.method_1551().method_1478().method_14488(DUNGEONS_PATH, id -> id.method_12832().endsWith(".skeleton")).entrySet()) {
            String[] path = ((class_2960)resourceEntry.getKey()).method_12832().split("/");
            if (path.length != 4) {
                LOGGER.error("[Skyblocker Dungeon Secrets] Failed to load dungeon secrets, invalid resource identifier {}", resourceEntry.getKey());
                break;
            }
            String dungeon = path[1];
            String roomShape = path[2];
            String room = path[3].substring(0, path[3].length() - ".skeleton".length());
            ROOMS_DATA.computeIfAbsent(dungeon, dungeonKey -> new HashMap());
            ROOMS_DATA.get(dungeon).computeIfAbsent(roomShape, roomShapeKey -> new HashMap());
            dungeonFutures.add(((CompletableFuture)CompletableFuture.supplyAsync(() -> DungeonManager.readRoom((class_3298)resourceEntry.getValue())).thenAcceptAsync(rooms -> {
                Map<String, int[]> roomsMap;
                Map<String, int[]> map = roomsMap = ROOMS_DATA.get(dungeon).get(roomShape);
                synchronized (map) {
                    roomsMap.put(room, (int[])rooms);
                }
                LOGGER.debug("[Skyblocker Dungeon Secrets] Loaded dungeon secrets dungeon {} room shape {} room {}", new Object[]{dungeon, roomShape, room});
            })).exceptionally(e -> {
                LOGGER.error("[Skyblocker Dungeon Secrets] Failed to load dungeon secrets dungeon {} room shape {} room {}", new Object[]{dungeon, roomShape, room, e});
                return null;
            }));
        }
        dungeonFutures.add(CompletableFuture.runAsync(() -> {
            try (BufferedReader roomsReader = class_310.method_1551().method_1478().openAsReader(class_2960.method_60655((String)"skyblocker", (String)"dungeons/dungeonrooms.json"));
                 BufferedReader waypointsReader = class_310.method_1551().method_1478().openAsReader(class_2960.method_60655((String)"skyblocker", (String)"dungeons/secretlocations.json"));){
                DungeonManager.loadJson(roomsReader, roomsJson);
                DungeonManager.loadJson(waypointsReader, waypointsJson);
                LOGGER.debug("[Skyblocker Dungeon Secrets] Loaded dungeon secret waypoints json");
            }
            catch (Exception e) {
                LOGGER.error("[Skyblocker Dungeon Secrets] Failed to load dungeon secret waypoints json", (Throwable)e);
            }
        }));
        dungeonFutures.add(CompletableFuture.runAsync(() -> {
            try (BufferedReader customWaypointsReader = Files.newBufferedReader(CUSTOM_WAYPOINTS_DIR);){
                ((JsonObject)SkyblockerMod.GSON.fromJson((Reader)customWaypointsReader, JsonObject.class)).asMap().forEach((room, waypointsJson) -> DungeonManager.addCustomWaypoints(room, SecretWaypoint.LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, waypointsJson).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseGet(ArrayList::new)));
                LOGGER.debug("[Skyblocker Dungeon Secrets] Loaded custom dungeon secret waypoints");
            }
            catch (Exception e) {
                LOGGER.error("[Skyblocker Dungeon Secrets] Failed to load custom dungeon secret waypoints", (Throwable)e);
            }
        }));
        roomsLoaded = ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])dungeonFutures.toArray(CompletableFuture[]::new)).thenRun(() -> LOGGER.info("[Skyblocker Dungeon Secrets] Loaded dungeon secrets for {} dungeon(s), {} room shapes, {} rooms, and {} custom secret waypoints total in {} ms", new Object[]{ROOMS_DATA.size(), ROOMS_DATA.values().stream().mapToInt(Map::size).sum(), ROOMS_DATA.values().stream().map(Map::values).flatMap(Collection::stream).mapToInt(Map::size).sum(), customWaypoints.size(), System.currentTimeMillis() - startTime}))).exceptionally(e -> {
            LOGGER.error("[Skyblocker Dungeon Secrets] Failed to load dungeon secrets", e);
            return null;
        });
        LOGGER.info("[Skyblocker Dungeon Secrets] Started loading dungeon secrets in (blocked main thread for) {} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private static void saveCustomWaypoints(class_310 client) {
        try (BufferedWriter writer = Files.newBufferedWriter(CUSTOM_WAYPOINTS_DIR, new OpenOption[0]);){
            JsonObject customWaypointsJson = new JsonObject();
            customWaypoints.rowMap().forEach((room, waypoints) -> customWaypointsJson.add(room, SecretWaypoint.LIST_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, new ArrayList(waypoints.values())).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseGet(JsonArray::new)));
            SkyblockerMod.GSON.toJson((JsonElement)customWaypointsJson, (Appendable)writer);
            LOGGER.info("[Skyblocker Dungeon Secrets] Saved custom dungeon secret waypoints");
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Dungeon Secrets] Failed to save custom dungeon secret waypoints", (Throwable)e);
        }
    }

    private static int[] readRoom(class_3298 resource) throws RuntimeException {
        int[] nArray;
        ObjectInputStream in = new ObjectInputStream(new InflaterInputStream(resource.method_14482()));
        try {
            nArray = (int[])in.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        in.close();
        return nArray;
    }

    private static void loadJson(BufferedReader reader, Map<String, JsonElement> map) {
        ((JsonObject)SkyblockerMod.GSON.fromJson((Reader)reader, JsonObject.class)).asMap().forEach((room, jsonElement) -> map.put(room.toLowerCase().replaceAll(" ", "-"), (JsonElement)jsonElement));
    }

    private static RequiredArgumentBuilder<FabricClientCommandSource, Integer> markSecretsCommand(boolean found) {
        return (RequiredArgumentBuilder)ClientCommandManager.argument((String)"secretIndex", (ArgumentType)IntegerArgumentType.integer()).suggests((provider, builder) -> {
            if (DungeonManager.isCurrentRoomMatched()) {
                IntStream.rangeClosed(1, currentRoom.getSecretCount()).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            }
            return builder.buildFuture();
        }).executes(context -> {
            int secretIndex = IntegerArgumentType.getInteger((CommandContext)context, (String)"secretIndex");
            if (DungeonManager.markSecrets(secretIndex, found)) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)(found ? "skyblocker.dungeons.secrets.markSecretFound" : "skyblocker.dungeons.secrets.markSecretMissing"), (Object[])new Object[]{secretIndex})));
            } else {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)(found ? "skyblocker.dungeons.secrets.markSecretFoundUnable" : "skyblocker.dungeons.secrets.markSecretMissingUnable"), (Object[])new Object[]{secretIndex})));
            }
            return 1;
        });
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> markAllSecretsAsMissingCommand() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"all").executes(context -> {
            if (DungeonManager.isCurrentRoomMatched()) {
                currentRoom.markAllSecrets(false);
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.dungeons.secrets.markSecretsMissing")));
            } else {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.dungeons.secrets.markSecretsMissingUnable")));
            }
            return 1;
        });
    }

    private static int getRelativePos(CommandContext<FabricClientCommandSource> context) {
        return DungeonManager.getRelativePos((FabricClientCommandSource)context.getSource(), ((FabricClientCommandSource)context.getSource()).getPlayer().method_24515());
    }

    private static int getRelativeTargetPos(CommandContext<FabricClientCommandSource> context) {
        class_3965 blockHitResult;
        class_239 class_2392 = class_310.method_1551().field_1765;
        if (class_2392 instanceof class_3965 && (blockHitResult = (class_3965)class_2392).method_17783() == class_239.class_240.field_1332) {
            return DungeonManager.getRelativePos((FabricClientCommandSource)context.getSource(), blockHitResult.method_17777());
        }
        ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.dungeons.secrets.noTarget")));
        return 1;
    }

    private static int getRelativePos(FabricClientCommandSource source, class_2338 pos) {
        Room room = DungeonManager.getRoomAtPhysical((class_2382)pos);
        if (DungeonManager.isRoomMatched(room)) {
            class_2338 relativePos = currentRoom.actualToRelative(pos);
            source.sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.dungeons.secrets.posMessage", (Object[])new Object[]{currentRoom.getName(), currentRoom.getDirection().method_15434(), relativePos.method_10263(), relativePos.method_10264(), relativePos.method_10260()})));
        } else {
            source.sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.dungeons.secrets.notMatched")));
        }
        return 1;
    }

    private static RequiredArgumentBuilder<FabricClientCommandSource, ClientPosArgument> addCustomWaypointCommand(boolean relative, class_7157 registryAccess) {
        return (RequiredArgumentBuilder)ClientCommandManager.argument((String)"pos", (ArgumentType)ClientBlockPosArgumentType.blockPos()).then(ClientCommandManager.argument((String)"secretIndex", (ArgumentType)IntegerArgumentType.integer()).then(ClientCommandManager.argument((String)"category", (ArgumentType)SecretWaypoint.Category.CategoryArgumentType.category()).then(ClientCommandManager.argument((String)"name", (ArgumentType)class_2178.method_9281((class_7157)registryAccess)).executes(context -> {
            class_2338 pos = ((ClientPosArgument)context.getArgument("pos", ClientPosArgument.class)).toAbsoluteBlockPos((FabricClientCommandSource)context.getSource());
            return relative ? DungeonManager.addCustomWaypointRelative((CommandContext<FabricClientCommandSource>)context, pos) : DungeonManager.addCustomWaypoint((CommandContext<FabricClientCommandSource>)context, pos);
        }))));
    }

    private static int addCustomWaypoint(CommandContext<FabricClientCommandSource> context, class_2338 pos) {
        Room room = DungeonManager.getRoomAtPhysical((class_2382)pos);
        if (DungeonManager.isRoomMatched(room)) {
            room.addCustomWaypoint(context, room.actualToRelative(pos));
        } else {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.dungeons.secrets.notMatched")));
        }
        return 1;
    }

    private static int addCustomWaypointRelative(CommandContext<FabricClientCommandSource> context, class_2338 pos) {
        if (DungeonManager.isCurrentRoomMatched()) {
            currentRoom.addCustomWaypoint(context, pos);
        } else {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.dungeons.secrets.notMatched")));
        }
        return 1;
    }

    private static RequiredArgumentBuilder<FabricClientCommandSource, ClientPosArgument> removeCustomWaypointCommand(boolean relative) {
        return (RequiredArgumentBuilder)ClientCommandManager.argument((String)"pos", (ArgumentType)ClientBlockPosArgumentType.blockPos()).executes(context -> {
            class_2338 pos = ((ClientPosArgument)context.getArgument("pos", ClientPosArgument.class)).toAbsoluteBlockPos((FabricClientCommandSource)context.getSource());
            return relative ? DungeonManager.removeCustomWaypointRelative((CommandContext<FabricClientCommandSource>)context, pos) : DungeonManager.removeCustomWaypoint((CommandContext<FabricClientCommandSource>)context, pos);
        });
    }

    private static int removeCustomWaypoint(CommandContext<FabricClientCommandSource> context, class_2338 pos) {
        Room room = DungeonManager.getRoomAtPhysical((class_2382)pos);
        if (DungeonManager.isRoomMatched(room)) {
            room.removeCustomWaypoint(context, room.actualToRelative(pos));
        } else {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.dungeons.secrets.notMatched")));
        }
        return 1;
    }

    private static int removeCustomWaypointRelative(CommandContext<FabricClientCommandSource> context, class_2338 pos) {
        if (DungeonManager.isCurrentRoomMatched()) {
            currentRoom.removeCustomWaypoint(context, pos);
        } else {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.dungeons.secrets.notMatched")));
        }
        return 1;
    }

    private static RequiredArgumentBuilder<FabricClientCommandSource, String> matchAgainstCommand() {
        return (RequiredArgumentBuilder)ClientCommandManager.argument((String)"room", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9264(ROOMS_DATA.values().stream().map(Map::values).flatMap(Collection::stream).map(Map::keySet).flatMap(Collection::stream), (SuggestionsBuilder)builder)).then(ClientCommandManager.argument((String)"direction", (ArgumentType)Room.Direction.DirectionArgumentType.direction()).executes(context -> {
            Room.Direction direction;
            if (!DungeonManager.isClearingDungeon()) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_27693("\u00a7cYou are not in a dungeon."));
                return 1;
            }
            class_310 client = class_310.method_1551();
            if (client.field_1724 == null || client.field_1687 == null) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_27693("\u00a7cFailed to get player or world."));
                return 1;
            }
            class_1799 stack = (class_1799)client.field_1724.method_31548().method_67533().get(8);
            if (!stack.method_31574(class_1802.field_8204)) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_27693("\u00a7cFailed to get dungeon map."));
                return 1;
            }
            class_22 map = class_1806.method_7997((class_9209)((class_9209)stack.method_58694(class_9334.field_49646)), (class_1937)client.field_1687);
            if (map == null) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_27693("\u00a7cFailed to get dungeon map state."));
                return 1;
            }
            String roomName = StringArgumentType.getString((CommandContext)context, (String)"room");
            Room room = DungeonManager.newDebugRoom(roomName, direction = Room.Direction.DirectionArgumentType.getDirection(context, "direction"), (class_1657)client.field_1724, map);
            if (room == null) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_27693("\u00a7cFailed to find room with name " + roomName + "."));
                return 1;
            }
            if (currentRoom != null) {
                currentRoom.addSubProcess(room);
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_27693("\u00a7rMatching room " + roomName + " with direction " + String.valueOf((Object)direction) + " against current room."));
            } else {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_27693("\u00a7cCurrent room is null."));
            }
            return 1;
        }));
    }

    @Nullable
    private static Room newDebugRoom(String roomName, Room.Direction direction, class_1657 player, class_22 map) {
        DebugRoom room = null;
        int[] roomData = ROOMS_DATA.get("catacombs").get(Room.Shape.PUZZLE.shape).get(roomName);
        if (roomData != null) {
            room = DebugRoom.ofSinglePossibleRoom(Room.Type.PUZZLE, DungeonMapUtils.getPhysicalRoomPos(player.method_19538()), roomName, roomData, direction);
        } else {
            roomData = ROOMS_DATA.get("catacombs").get(Room.Shape.TRAP.shape).get(roomName);
            if (roomData != null) {
                room = DebugRoom.ofSinglePossibleRoom(Room.Type.TRAP, DungeonMapUtils.getPhysicalRoomPos(player.method_19538()), roomName, roomData, direction);
            } else {
                roomData = ROOMS_DATA.get("catacombs").values().stream().map(Map::entrySet).flatMap(Collection::stream).filter(entry -> ((String)entry.getKey()).equals(roomName)).findAny().map(Map.Entry::getValue).orElse(null);
                if (roomData != null) {
                    room = DebugRoom.ofSinglePossibleRoom(Room.Type.ROOM, DungeonMapUtils.getPhysicalPosFromMap(mapEntrancePos, mapRoomSize, physicalEntrancePos, DungeonMapUtils.getRoomSegments(map, DungeonMapUtils.getMapRoomPos(map, mapEntrancePos, mapRoomSize), mapRoomSize, Room.Type.ROOM.color)), roomName, roomData, direction);
                }
            }
        }
        return room;
    }

    public static class_243 getMortArmorStandPos() {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return null;
        }
        for (class_1297 entity : client.field_1687.method_18112()) {
            class_1531 armorStand;
            class_2561 name;
            if (!(entity instanceof class_1531) || (name = (armorStand = (class_1531)entity).method_5797()) == null || !name.getString().contains("Mort")) continue;
            return armorStand.method_19538();
        }
        return null;
    }

    private static void update() {
        class_22 map;
        if (!Utils.isInDungeons() || DungeonManager.isInBoss()) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        if (physicalEntrancePos == null) {
            class_243 mortPos = DungeonManager.getMortArmorStandPos();
            if (mortPos == null) {
                LOGGER.warn("[Skyblocker Dungeon Secrets] Failed to find Mort armor stand, retrying...");
                return;
            }
            physicalEntrancePos = DungeonMapUtils.getPhysicalRoomPos(mortPos);
            currentRoom = DungeonManager.newRoom(Room.Type.ENTRANCE, physicalEntrancePos);
            ((DungeonEvents.DungeonLoaded)DungeonEvents.DUNGEON_LOADED.invoker()).onDungeonLoaded();
        }
        if ((map = DungeonManager.getMapState(client)) == null) {
            return;
        }
        if (mapEntrancePos == null || mapRoomSize == 0) {
            ObjectIntPair<Vector2ic> mapEntrancePosAndSize = DungeonMapUtils.getMapEntrancePosAndRoomSize(map);
            if (mapEntrancePosAndSize == null) {
                return;
            }
            mapEntrancePos = (Vector2ic)mapEntrancePosAndSize.left();
            mapRoomSize = mapEntrancePosAndSize.rightInt();
            LOGGER.info("[Skyblocker Dungeon Secrets] Started dungeon with map room size {}, map entrance pos {}, player pos {}, and physical entrance pos {}", new Object[]{mapRoomSize, mapEntrancePos, client.field_1724.method_19538(), physicalEntrancePos});
        }
        DungeonManager.getBloodRushDoorPos(map);
        Vector2ic physicalPos = DungeonMapUtils.getPhysicalRoomPos(client.field_1724.method_19538());
        Vector2ic mapPos = DungeonMapUtils.getMapPosFromPhysical(physicalEntrancePos, mapEntrancePos, mapRoomSize, physicalPos);
        Room room = rooms.get(physicalPos);
        if (room == null) {
            Room.Type type = DungeonMapUtils.getRoomType(map, mapPos);
            if (type == null || type == Room.Type.UNKNOWN) {
                return;
            }
            switch (type) {
                case ENTRANCE: 
                case PUZZLE: 
                case TRAP: 
                case MINIBOSS: 
                case FAIRY: 
                case BLOOD: {
                    room = DungeonManager.newRoom(type, physicalPos);
                    break;
                }
                case ROOM: {
                    room = DungeonManager.newRoom(type, DungeonMapUtils.getPhysicalPosFromMap(mapEntrancePos, mapRoomSize, physicalEntrancePos, DungeonMapUtils.getRoomSegments(map, mapPos, mapRoomSize, type.color)));
                }
            }
        }
        if (room != null && currentRoom != room) {
            currentRoom = room;
        }
        if (currentRoom.getType() != Room.Type.ENTRANCE && currentRoom.isMatched() && !DungeonManager.currentRoom.greenChecked && DungeonManager.getRoomCheckmarkColour(client, map, currentRoom) == 30) {
            currentRoom.markAllSecrets(true);
            DungeonManager.currentRoom.greenChecked = true;
        }
        currentRoom.tick(client);
    }

    @Nullable
    private static Room newRoom(Room.Type type, Vector2ic ... physicalPositions) {
        try {
            Room newRoom = new Room(type, physicalPositions);
            for (Vector2ic physicalPos : physicalPositions) {
                rooms.put(physicalPos, newRoom);
            }
            return newRoom;
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("[Skyblocker Dungeon Secrets] Failed to create room", (Throwable)e);
            return null;
        }
    }

    private static void render(WorldRenderContext context) {
        if (DungeonManager.shouldProcess() && currentRoom != null) {
            currentRoom.render(context);
        }
        if (bloodRushDoorBox != null && !bloodOpened && SkyblockerConfigManager.get().dungeons.doorHighlight.enableDoorHighlight) {
            float[] colorComponents = hasKey ? GREEN_COLOR_COMPONENTS : RED_COLOR_COMPONENTS;
            switch (SkyblockerConfigManager.get().dungeons.doorHighlight.doorHighlightType) {
                case HIGHLIGHT: {
                    RenderHelper.renderFilled(context, bloodRushDoorBox, colorComponents, 0.5f, true);
                    break;
                }
                case OUTLINED_HIGHLIGHT: {
                    RenderHelper.renderFilled(context, bloodRushDoorBox, colorComponents, 0.5f, true);
                    RenderHelper.renderOutline(context, bloodRushDoorBox, colorComponents, 5.0f, true);
                    break;
                }
                case OUTLINE: {
                    RenderHelper.renderOutline(context, bloodRushDoorBox, colorComponents, 5.0f, true);
                }
            }
        }
    }

    private static boolean onChatMessage(class_2561 text, boolean overlay) {
        if (!DungeonManager.shouldProcess()) {
            return true;
        }
        String message = text.getString();
        if (DungeonManager.isCurrentRoomMatched()) {
            currentRoom.onChatMessage(message);
        }
        if (SkyblockerConfigManager.get().dungeons.doorHighlight.enableDoorHighlight && !bloodOpened) {
            if (BLOOD_DOOR_OPENED.equals(message)) {
                bloodOpened = true;
            }
            if (KEY_FOUND.matcher(message).matches()) {
                hasKey = true;
            }
            if (WITHER_DOOR_OPENED.matcher(message).matches()) {
                hasKey = false;
            }
        }
        if (message.equals("\u00a7e[NPC] \u00a7bMort\u00a7f: You should find it useful if you get lost.")) {
            ((DungeonEvents.DungeonStarted)DungeonEvents.DUNGEON_STARTED.invoker()).onDungeonStarted();
        }
        DungeonBoss newBoss = DungeonBoss.fromMessage(message);
        if (!DungeonManager.isInBoss() && newBoss.isInBoss()) {
            DungeonManager.reset();
            boss = newBoss;
        }
        return true;
    }

    private static class_1269 onUseBlock(class_1937 world, class_3965 hitResult) {
        if (DungeonManager.isCurrentRoomMatched()) {
            currentRoom.onUseBlock(world, hitResult.method_17777());
        }
        return class_1269.field_5811;
    }

    public static void onItemPickup(class_1542 itemEntity) {
        Room room = DungeonManager.getRoomAtPhysical(itemEntity.method_19538());
        if (DungeonManager.isRoomMatched(room)) {
            room.onItemPickup(itemEntity);
        }
    }

    public static void onBatRemoved(class_1421 bat) {
        Room room = DungeonManager.getRoomAtPhysical(bat.method_19538());
        if (DungeonManager.isRoomMatched(room)) {
            room.onBatRemoved(bat);
        }
    }

    public static boolean markSecrets(int secretIndex, boolean found) {
        if (DungeonManager.isCurrentRoomMatched()) {
            return currentRoom.markSecrets(secretIndex, found);
        }
        return false;
    }

    @Nullable
    private static Room getRoomAtPhysical(class_243 pos) {
        return rooms.get(DungeonMapUtils.getPhysicalRoomPos(pos));
    }

    @Nullable
    private static Room getRoomAtPhysical(class_2382 pos) {
        return rooms.get(DungeonMapUtils.getPhysicalRoomPos(pos));
    }

    @Nullable
    private static class_22 getMapState(class_310 client) {
        return class_1806.method_7997((class_9209)DungeonMap.getMapIdComponent((class_1799)client.field_1724.method_31548().method_67533().get(8)), (class_1937)client.field_1687);
    }

    public static boolean isClearingDungeon() {
        return physicalEntrancePos != null && mapEntrancePos != null && mapRoomSize != 0;
    }

    public static boolean isCurrentRoomMatched() {
        return DungeonManager.isRoomMatched(currentRoom);
    }

    @Contract(value="null -> false")
    private static boolean isRoomMatched(@Nullable Room room) {
        return DungeonManager.shouldProcess() && room != null && room.isMatched();
    }

    private static boolean shouldProcess() {
        return Utils.isInDungeons();
    }

    private static void reset() {
        mapEntrancePos = null;
        mapRoomSize = 0;
        physicalEntrancePos = null;
        rooms.clear();
        currentRoom = null;
        boss = DungeonBoss.NONE;
        bloodRushDoorBox = null;
        bloodOpened = false;
        hasKey = false;
    }

    private static void getBloodRushDoorPos(@NotNull class_22 map) {
        byte color;
        int y;
        int x;
        if (mapEntrancePos == null || mapRoomSize == 0) {
            LOGGER.error("[Skyblocker Dungeon Secrets] Dungeon map info missing with map entrance pos {} and map room size {}", (Object)mapEntrancePos, (Object)mapRoomSize);
            return;
        }
        Vector2i nWMostRoom = DungeonMapUtils.getMapPosForNWMostRoom(mapEntrancePos, mapRoomSize);
        for (x = nWMostRoom.x + mapRoomSize / 2; x < 128; x += mapRoomSize + 4) {
            for (y = nWMostRoom.y + mapRoomSize; y < 128; y += mapRoomSize + 4) {
                color = DungeonMapUtils.getColor(map, x, y);
                if (color != 119 && color != 18) continue;
                Vector2ic doorPos = DungeonMapUtils.getPhysicalPosFromMap(mapEntrancePos, mapRoomSize, physicalEntrancePos, (Vector2ic)new Vector2i(x - mapRoomSize / 2, y - mapRoomSize));
                bloodRushDoorBox = new class_238((double)(doorPos.x() + 14), 69.0, (double)(doorPos.y() + 30), (double)(doorPos.x() + 17), 73.0, (double)(doorPos.y() + 33));
                return;
            }
        }
        for (x = nWMostRoom.x + mapRoomSize; x < 128; x += mapRoomSize + 4) {
            for (y = nWMostRoom.y + mapRoomSize / 2; y < 128; y += mapRoomSize + 4) {
                color = DungeonMapUtils.getColor(map, x, y);
                if (color != 119 && color != 18) continue;
                Vector2ic doorPos = DungeonMapUtils.getPhysicalPosFromMap(mapEntrancePos, mapRoomSize, physicalEntrancePos, (Vector2ic)new Vector2i(x - mapRoomSize, y - mapRoomSize / 2));
                bloodRushDoorBox = new class_238((double)(doorPos.x() + 30), 69.0, (double)(doorPos.y() + 14), (double)(doorPos.x() + 33), 73.0, (double)(doorPos.y() + 17));
                return;
            }
        }
    }

    private static int getRoomCheckmarkColour(class_310 client, class_22 mapState, Room room) {
        int halfRoomSize = mapRoomSize / 2;
        for (Vector2ic segmentPhysicalPos : room.segments) {
            Vector2ic topLeftCorner = DungeonMapUtils.getMapPosFromPhysical(physicalEntrancePos, mapEntrancePos, mapRoomSize, segmentPhysicalPos);
            Vector2i middle = topLeftCorner.add(halfRoomSize, halfRoomSize, new Vector2i());
            for (int offset = 0; offset < halfRoomSize; ++offset) {
                byte colour = DungeonMapUtils.getColor(mapState, (Vector2ic)new Vector2i(middle.x(), middle.y() + offset));
                if (colour != DungeonMapUtils.WHITE_COLOR && colour != 30) continue;
                return colour;
            }
        }
        return -1;
    }

    static {
        KEY_FOUND = Pattern.compile("^RIGHT CLICK on (?:the BLOOD DOOR|a WITHER door) to open it. This key can only be used to open 1 door!$");
        WITHER_DOOR_OPENED = Pattern.compile("^\\w+ opened a WITHER door!$");
        RED_COLOR_COMPONENTS = new float[]{1.0f, 0.0f, 0.0f};
        GREEN_COLOR_COMPONENTS = new float[]{0.0f, 1.0f, 0.0f};
        NUMERIC_ID = Object2ByteMaps.unmodifiable((Object2ByteMap)new Object2ByteOpenHashMap(Map.ofEntries(Map.entry("minecraft:stone", (byte)1), Map.entry("minecraft:diorite", (byte)2), Map.entry("minecraft:polished_diorite", (byte)3), Map.entry("minecraft:andesite", (byte)4), Map.entry("minecraft:polished_andesite", (byte)5), Map.entry("minecraft:grass_block", (byte)6), Map.entry("minecraft:dirt", (byte)7), Map.entry("minecraft:coarse_dirt", (byte)8), Map.entry("minecraft:cobblestone", (byte)9), Map.entry("minecraft:bedrock", (byte)10), Map.entry("minecraft:oak_leaves", (byte)11), Map.entry("minecraft:gray_wool", (byte)12), Map.entry("minecraft:double_stone_slab", (byte)13), Map.entry("minecraft:mossy_cobblestone", (byte)14), Map.entry("minecraft:clay", (byte)15), Map.entry("minecraft:stone_bricks", (byte)16), Map.entry("minecraft:mossy_stone_bricks", (byte)17), Map.entry("minecraft:chiseled_stone_bricks", (byte)18), Map.entry("minecraft:gray_terracotta", (byte)19), Map.entry("minecraft:cyan_terracotta", (byte)20), Map.entry("minecraft:black_terracotta", (byte)21))));
        ROOMS_DATA = new HashMap();
        rooms = new HashMap<Vector2ic, Room>();
        roomsJson = new HashMap<String, JsonElement>();
        waypointsJson = new HashMap<String, JsonElement>();
        customWaypoints = HashBasedTable.create();
        boss = DungeonBoss.NONE;
    }
}

