/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.puzzle.waterboard;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.debug.Debug;
import de.hysky.skyblocker.skyblock.dungeon.puzzle.DungeonPuzzle;
import de.hysky.skyblocker.skyblock.dungeon.puzzle.waterboard.Waterboard;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.skyblock.dungeon.secrets.Room;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.render.RenderHelper;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.objects.ObjectDoublePair;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaterboardOneFlow
extends DungeonPuzzle {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaterboardOneFlow.class);
    public static final WaterboardOneFlow INSTANCE = new WaterboardOneFlow();
    private static final class_2960 WATER_TIMES = class_2960.method_60655((String)"skyblocker", (String)"dungeons/watertimes.json");
    private static final class_2561 WAIT_TEXT = class_2561.method_43470((String)"WAIT").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067});
    private static final class_2561 CLICK_TEXT = class_2561.method_43470((String)"CLICK").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067});
    private static JsonObject SOLUTIONS;
    private boolean timerEnabled;
    private final List<Mark> marks = new ArrayList<Mark>();
    private class_638 world;
    private Room room;
    private class_746 player;
    private int variant;
    private String doors;
    private String initialDoors;
    private EnumMap<Waterboard.LeverType, DoubleList> solution;
    private boolean finished;
    private long waterStartMillis;
    private CompletableFuture<Void> solve;

    private WaterboardOneFlow() {
        super("waterboard", "water-puzzle");
    }

    @Init
    public static void init() {
        ClientLifecycleEvents.CLIENT_STARTED.register(WaterboardOneFlow::loadSolutions);
        UseBlockCallback.EVENT.register(INSTANCE::onUseBlock);
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"dungeons").then(ClientCommandManager.literal((String)"puzzle").then(ClientCommandManager.literal((String)WaterboardOneFlow.INSTANCE.puzzleName).then(ClientCommandManager.literal((String)"reset").executes(context -> {
            INSTANCE.softReset();
            return 1;
        })))))));
        if (Debug.debugEnabled()) {
            ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"dungeons").then(ClientCommandManager.literal((String)"puzzle").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)WaterboardOneFlow.INSTANCE.puzzleName).then(ClientCommandManager.literal((String)"setDoors").then(ClientCommandManager.argument((String)"combination", (ArgumentType)StringArgumentType.string()).executes(context -> {
                String doorCombination = StringArgumentType.getString((CommandContext)context, (String)"combination");
                if (SOLUTIONS.get("1").getAsJsonObject().keySet().contains(doorCombination)) {
                    INSTANCE.softReset();
                    WaterboardOneFlow.INSTANCE.doors = doorCombination;
                } else {
                    ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_27693("Door combination must be three increasing digits between 0 and 4"));
                }
                return 1;
            })))).then(ClientCommandManager.literal((String)"toggleTimer").executes(context -> {
                WaterboardOneFlow.INSTANCE.timerEnabled = !WaterboardOneFlow.INSTANCE.timerEnabled;
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_27693(WaterboardOneFlow.INSTANCE.timerEnabled ? "Timer enabled." : "Timer disabled."));
                return 1;
            }))).then(ClientCommandManager.literal((String)"modifyLever").then(ClientCommandManager.argument((String)"leverType", (ArgumentType)Waterboard.LeverType.LeverTypeArgumentType.leverType()).then(ClientCommandManager.argument((String)"times", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
                Waterboard.LeverType leverType = Waterboard.LeverType.LeverTypeArgumentType.getLeverType(context, "leverType");
                if (leverType == null) {
                    ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_27693("Invalid lever type"));
                } else if (WaterboardOneFlow.INSTANCE.solution == null) {
                    ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_27693("No existing solution"));
                } else {
                    try {
                        DoubleArrayList times = new DoubleArrayList();
                        for (String time : StringArgumentType.getString((CommandContext)context, (String)"times").split(" ")) {
                            times.add(Double.parseDouble(time));
                        }
                        WaterboardOneFlow.INSTANCE.solution.put(leverType, (DoubleList)times);
                    }
                    catch (NumberFormatException e) {
                        ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_27693("Times must be valid numbers or decimals"));
                    }
                }
                return 1;
            }))))).then(ClientCommandManager.literal((String)"addMark").executes(context -> {
                if (WaterboardOneFlow.INSTANCE.world == null || WaterboardOneFlow.INSTANCE.room == null || WaterboardOneFlow.INSTANCE.player == null) {
                    ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_27693("Solver not active"));
                    return 1;
                }
                class_243 camera = WaterboardOneFlow.INSTANCE.room.actualToRelative(WaterboardOneFlow.INSTANCE.player.method_33571());
                class_243 look = WaterboardOneFlow.INSTANCE.room.actualToRelative(WaterboardOneFlow.INSTANCE.player.method_33571().method_1019(WaterboardOneFlow.INSTANCE.player.method_5720())).method_1020(camera);
                double t = (26.5 - camera.method_10215()) / look.method_10215();
                class_243 vec = camera.method_1019(look.method_1021(t));
                double x = class_3532.method_15357((double)vec.field_1352);
                double y = class_3532.method_15357((double)vec.field_1351);
                double z = class_3532.method_15357((double)vec.field_1350);
                if (x < 6.0 || x > 24.0 || y < 58.0 || y > 81.0 || z != 26.0) {
                    ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_27693("Mark is not inside the board"));
                    return 1;
                }
                class_2338 pos = class_2338.method_49638((class_2374)WaterboardOneFlow.INSTANCE.room.relativeToActual(vec));
                if (!WaterboardOneFlow.INSTANCE.world.method_8320(pos).method_26215()) {
                    ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_27693("Marks can only be placed on air"));
                    return 1;
                }
                for (Mark mark : WaterboardOneFlow.INSTANCE.marks) {
                    if (!mark.pos.equals((Object)pos)) continue;
                    ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_27693("There is already a mark at that position"));
                    return 1;
                }
                WaterboardOneFlow.INSTANCE.marks.add(new Mark(WaterboardOneFlow.INSTANCE.marks.size() + 1, pos));
                return 1;
            }))).then(ClientCommandManager.literal((String)"clearMarks").executes(context -> {
                WaterboardOneFlow.INSTANCE.marks.clear();
                return 1;
            })))))));
        }
    }

    private static void loadSolutions(class_310 client) {
        try (BufferedReader reader = client.method_1478().openAsReader(WATER_TIMES);){
            SOLUTIONS = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Waterboard] Failed to load solutions json", (Throwable)e);
        }
    }

    @Override
    public void tick(class_310 client) {
        if (!(SkyblockerConfigManager.get().dungeons.puzzleSolvers.waterboardOneFlow && this.shouldSolve() && client.field_1687 != null && client.field_1724 != null && DungeonManager.isCurrentRoomMatched())) {
            return;
        }
        this.world = client.field_1687;
        this.room = DungeonManager.getCurrentRoom();
        this.player = client.field_1724;
        if (this.solution == null && !this.finished && this.solve == null) {
            this.solve = CompletableFuture.runAsync(this::solvePuzzle).exceptionally(e -> {
                LOGGER.error("[Skyblocker Waterboard] Encountered an unknown exception while solving waterboard.", e);
                this.finished = true;
                return null;
            });
        }
        if (!this.finished && this.isPuzzleSolved()) {
            this.finished = true;
            if (this.timerEnabled) {
                double elapsed = (double)(System.currentTimeMillis() - this.waterStartMillis) / 1000.0;
                this.player.method_7353((class_2561)Constants.PREFIX.get().method_27693("Puzzle solved in ").method_10852((class_2561)class_2561.method_43470((String)String.format("%.2f", elapsed)).method_27692(class_124.field_1060)).method_27693(class_124.field_1070.toString()).method_27693(" seconds."), false);
            }
        }
        if (this.waterStartMillis > 0L) {
            for (Mark mark : this.marks) {
                if (mark.reached || !this.world.method_8320(mark.pos).method_27852(class_2246.field_10382)) continue;
                mark.reached = true;
                double elapsed = (double)(System.currentTimeMillis() - this.waterStartMillis) / 1000.0;
                this.player.method_7353((class_2561)Constants.PREFIX.get().method_27693(String.format("Mark %d reached in ", mark.index)).method_10852((class_2561)class_2561.method_43470((String)String.format("%.2f", elapsed)).method_27692(class_124.field_1060)).method_27693(class_124.field_1070.toString()).method_27693(" seconds."), false);
            }
        }
    }

    private void solvePuzzle() {
        this.variant = this.findVariant();
        if (this.variant == 0) {
            this.finished = true;
            return;
        }
        this.initialDoors = this.findDoors();
        if (this.doors == null) {
            this.doors = this.initialDoors;
            if (this.doors.isEmpty()) {
                this.solution = this.makeEmptySolution();
                this.finished = true;
                return;
            }
            if (this.doors.length() != 3) {
                this.player.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.dungeons.puzzle.waterboard.invalidDoors")), false);
                this.finished = true;
                return;
            }
        }
        if (!this.checkWater()) {
            this.player.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.dungeons.puzzle.waterboard.waterFound")), false);
            this.finished = true;
            return;
        }
        if (!this.finished) {
            JsonObject data = SOLUTIONS.get(String.valueOf(this.variant)).getAsJsonObject().get(this.doors).getAsJsonObject();
            this.solution = this.setupSolution(data);
        }
    }

    private EnumMap<Waterboard.LeverType, DoubleList> makeEmptySolution() {
        EnumMap<Waterboard.LeverType, DoubleList> solution = new EnumMap<Waterboard.LeverType, DoubleList>(Waterboard.LeverType.class);
        for (Waterboard.LeverType leverType : Waterboard.LeverType.values()) {
            solution.put(leverType, (DoubleList)new DoubleArrayList());
        }
        return solution;
    }

    private int findVariant() {
        HashSet<Waterboard.LeverType> firstSwitches = new HashSet<Waterboard.LeverType>();
        class_238 firstSwitchBlocks = class_238.method_54784((class_2338)this.room.relativeToActual(Waterboard.WATER_ENTRANCE_POSITION.method_10069(-1, -1, 0)), (class_2338)this.room.relativeToActual(Waterboard.WATER_ENTRANCE_POSITION.method_10069(1, 0, 1)));
        for (class_2680 state : this.world.method_29546(firstSwitchBlocks).toList()) {
            Waterboard.LeverType leverType = Waterboard.LeverType.fromBlock(state.method_26204());
            if (leverType == null) continue;
            firstSwitches.add(leverType);
        }
        if (firstSwitches.contains((Object)Waterboard.LeverType.GOLD) && firstSwitches.contains((Object)Waterboard.LeverType.TERRACOTTA)) {
            return 1;
        }
        if (firstSwitches.contains((Object)Waterboard.LeverType.EMERALD) && firstSwitches.contains((Object)Waterboard.LeverType.QUARTZ)) {
            return 2;
        }
        if (firstSwitches.contains((Object)Waterboard.LeverType.QUARTZ) && firstSwitches.contains((Object)Waterboard.LeverType.DIAMOND)) {
            return 3;
        }
        if (firstSwitches.contains((Object)Waterboard.LeverType.GOLD) && firstSwitches.contains((Object)Waterboard.LeverType.QUARTZ)) {
            return 4;
        }
        LOGGER.error("[Skyblocker Waterboard] Unknown waterboard layout. Detected switches: [{}]", (Object)String.join((CharSequence)", ", firstSwitches.stream().map(Waterboard.LeverType::method_15434).toList()));
        return 0;
    }

    private String findDoors() {
        StringBuilder doorBuilder = new StringBuilder();
        class_2338.class_2339 doorPos = new class_2338.class_2339(15, 57, 19);
        for (int i = 0; i < 5; ++i) {
            if (!this.world.method_8320(this.room.relativeToActual((class_2338)doorPos)).method_26215()) {
                doorBuilder.append(i);
            }
            doorPos.method_10098(class_2350.field_11043);
        }
        return doorBuilder.toString();
    }

    private boolean checkWater() {
        for (int x = 6; x <= 24; ++x) {
            for (int y = 58; y <= 81; ++y) {
                class_2338 pos = this.room.relativeToActual(new class_2338(x, y, 26));
                class_2680 state = this.world.method_8320(pos);
                if (!state.method_27852(class_2246.field_10382)) continue;
                return false;
            }
        }
        return true;
    }

    private EnumMap<Waterboard.LeverType, DoubleList> setupSolution(JsonObject data) {
        EnumMap<Waterboard.LeverType, DoubleList> solution = this.makeEmptySolution();
        for (Map.Entry entry : data.entrySet()) {
            Waterboard.LeverType leverType = Waterboard.LeverType.fromName((String)entry.getKey());
            if (leverType == null) continue;
            DoubleArrayList times = new DoubleArrayList();
            for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                times.add(element.getAsDouble());
            }
            solution.put(leverType, (DoubleList)times);
        }
        for (Waterboard.LeverType leverType : Waterboard.LeverType.values()) {
            DoubleList times = solution.get((Object)leverType);
            if (leverType == Waterboard.LeverType.WATER || !this.isLeverActive(leverType)) continue;
            if (times.isEmpty() || (Double)times.getFirst() != 0.0) {
                times.addFirst((Object)0.0);
                continue;
            }
            times.removeFirst();
        }
        return solution;
    }

    private boolean isLeverActive(Waterboard.LeverType leverType) {
        class_2338 offset = leverType.initialPositions[this.variant - 1];
        if (offset == null) {
            return false;
        }
        return !this.world.method_8320(this.room.relativeToActual(Waterboard.WATER_ENTRANCE_POSITION.method_10081((class_2382)offset))).method_27852(leverType.block);
    }

    private boolean isPuzzleSolved() {
        if (this.doors == null || this.initialDoors == null || this.waterStartMillis == 0L) {
            return false;
        }
        String currentDoors = this.findDoors();
        for (int i = 0; i < 5; ++i) {
            String s = String.valueOf(i);
            if (this.initialDoors.contains(s) == currentDoors.contains(s) != this.doors.contains(s)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void render(WorldRenderContext context) {
        if (!SkyblockerConfigManager.get().dungeons.puzzleSolvers.waterboardOneFlow || this.world == null || this.room == null || this.player == null) {
            return;
        }
        try {
            for (Mark mark : this.marks) {
                float[] components = ColorUtils.getFloatComponents(mark.reached ? class_1767.field_7961 : class_1767.field_7952);
                RenderHelper.renderFilled(context, mark.pos, components, 0.5f, true);
                RenderHelper.renderText(context, class_2561.method_30163((String)String.format("Mark %d", mark.index)), mark.pos.method_46558().method_43206(class_2350.field_11036, 0.2), true);
            }
            if (this.solution != null) {
                Waterboard.LeverType nextNextLever;
                List<ObjectDoublePair> sortedTimes = this.solution.entrySet().stream().flatMap(entry -> ((DoubleList)entry.getValue()).doubleStream().mapToObj(time -> ObjectDoublePair.of((Object)((Object)((Waterboard.LeverType)((Object)((Object)((Object)entry.getKey()))))), (double)time))).sorted(Comparator.comparingDouble(p -> p.rightDouble() + (p.left() == Waterboard.LeverType.WATER ? 0.001 : 0.0)).thenComparingInt(p -> ((Waterboard.LeverType)((Object)((Object)p.left()))).ordinal())).toList();
                Waterboard.LeverType nextLever = sortedTimes.isEmpty() ? null : (Waterboard.LeverType)((Object)sortedTimes.getFirst().left());
                Waterboard.LeverType leverType = nextNextLever = sortedTimes.size() < 2 ? null : (Waterboard.LeverType)((Object)sortedTimes.get(1).left());
                if (nextLever != null) {
                    RenderHelper.renderLineFromCursor(context, this.room.relativeToActual(nextLever.leverPos).method_46558(), ColorUtils.getFloatComponents(class_1767.field_7961), 1.0f, 2.0f);
                    if (nextNextLever != null) {
                        RenderHelper.renderLinesFromPoints(context, new class_243[]{this.room.relativeToActual(nextLever.leverPos).method_46558(), this.room.relativeToActual(nextNextLever.leverPos).method_46558()}, ColorUtils.getFloatComponents(class_1767.field_7952), 0.5f, 1.0f, true);
                    }
                }
                this.renderLeverText(context, nextLever);
            }
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Waterboard] Error while rendering one flow", (Throwable)e);
        }
    }

    private void renderLeverText(WorldRenderContext context, Waterboard.LeverType nextLever) {
        for (Map.Entry<Waterboard.LeverType, DoubleList> leverData : this.solution.entrySet()) {
            Waterboard.LeverType lever = leverData.getKey();
            for (int i = 0; i < leverData.getValue().size(); ++i) {
                class_2561 text;
                double nextTime = leverData.getValue().getDouble(i);
                long remainingTime = this.waterStartMillis + (long)(nextTime * 1000.0) - System.currentTimeMillis();
                if (lever == Waterboard.LeverType.WATER && nextTime == 0.0 && nextLever != Waterboard.LeverType.WATER) {
                    text = WAIT_TEXT;
                } else if (this.waterStartMillis == 0L && nextTime == 0.0 || this.waterStartMillis > 0L && (double)remainingTime <= 0.0) {
                    text = CLICK_TEXT;
                } else {
                    double timeToShow = this.waterStartMillis == 0L ? nextTime : (double)remainingTime / 1000.0;
                    text = class_2561.method_43470((String)String.format("%.2f", timeToShow)).method_27692(class_124.field_1054);
                }
                RenderHelper.renderText(context, text, this.room.relativeToActual(lever.leverPos).method_46558().method_43206(class_2350.field_11036, 0.5 * (double)(i + 1)), true);
            }
        }
    }

    private class_1269 onUseBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 blockHitResult) {
        try {
            Waterboard.LeverType leverType;
            if (SkyblockerConfigManager.get().dungeons.puzzleSolvers.waterboardOneFlow && this.solution != null && blockHitResult.method_17783() == class_239.class_240.field_1332 && (leverType = Waterboard.LeverType.fromPos(this.room.actualToRelative(blockHitResult.method_17777()))) != null) {
                List times = (List)this.solution.get((Object)leverType);
                if (this.waterStartMillis == 0L && leverType != Waterboard.LeverType.WATER && (times.isEmpty() || (Double)times.getFirst() != 0.0)) {
                    times.addFirst(0.0);
                } else {
                    if (!times.isEmpty()) {
                        times.removeFirst();
                    }
                    if (this.waterStartMillis == 0L && leverType == Waterboard.LeverType.WATER) {
                        this.waterStartMillis = System.currentTimeMillis();
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Waterboard] Exception in onUseBlock", (Throwable)e);
        }
        return class_1269.field_5811;
    }

    @Override
    public void reset() {
        super.reset();
        this.softReset();
    }

    private void softReset() {
        this.solve = null;
        this.variant = 0;
        this.doors = null;
        this.initialDoors = null;
        this.solution = null;
        this.finished = false;
        this.waterStartMillis = 0L;
        for (Mark mark : this.marks) {
            mark.reached = false;
        }
    }

    private static class Mark {
        private final int index;
        private final class_2338 pos;
        private boolean reached;

        private Mark(int index, class_2338 pos) {
            this.index = index;
            this.pos = pos;
            this.reached = false;
        }
    }
}

