/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.puzzle;

import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.waypoint.FairySouls;
import de.hysky.skyblocker.utils.SkyblockTime;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.chat.ChatFilterResult;
import de.hysky.skyblocker.utils.chat.ChatPatternListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class Trivia
extends ChatPatternListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<String, String[]> answers = Collections.synchronizedMap(new HashMap());
    private List<String> solutions = Collections.emptyList();

    public Trivia() {
        super("^ +(?:([A-Za-z,' ]*\\?)| ([\u24d0\u24d1\u24d2]) ([a-zA-Z0-9 ]+))$");
    }

    @Override
    public ChatFilterResult state() {
        return SkyblockerConfigManager.get().dungeons.puzzleSolvers.solveTrivia ? ChatFilterResult.FILTER : ChatFilterResult.PASS;
    }

    @Override
    public boolean onMatch(class_2561 message, Matcher matcher) {
        String riddle = matcher.group(3);
        if (riddle != null) {
            if (!this.solutions.contains(riddle)) {
                class_746 player = class_310.method_1551().field_1724;
                if (player != null) {
                    Utils.sendMessageToBypassEvents(class_2561.method_30163((String)("     " + String.valueOf(class_124.field_1065) + matcher.group(2) + String.valueOf(class_124.field_1061) + " " + riddle)));
                }
                return player != null;
            }
        } else {
            this.updateSolutions(matcher.group(0));
        }
        return false;
    }

    private void updateSolutions(String question) {
        try {
            String trimmedQuestion = question.trim();
            if (trimmedQuestion.equals("What SkyBlock year is it?")) {
                int year = SkyblockTime.skyblockYear.get();
                this.solutions = Collections.singletonList("Year " + year);
            } else {
                String[] questionAnswers = answers.get(trimmedQuestion);
                if (questionAnswers != null) {
                    this.solutions = Arrays.asList(questionAnswers);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker] Failed to update the Trivia puzzle answers!", (Throwable)e);
        }
    }

    @NotNull
    private static String[] getFairySoulsSizeString(@Nullable String location) {
        return new String[]{"%d Fairy Souls".formatted(FairySouls.getFairySoulsSize(location))};
    }

    static {
        answers.put("What is the status of The Watcher?", new String[]{"Stalker"});
        answers.put("What is the status of Bonzo?", new String[]{"New Necromancer"});
        answers.put("What is the status of Scarf?", new String[]{"Apprentice Necromancer"});
        answers.put("What is the status of The Professor?", new String[]{"Professor"});
        answers.put("What is the status of Thorn?", new String[]{"Shaman Necromancer"});
        answers.put("What is the status of Livid?", new String[]{"Master Necromancer"});
        answers.put("What is the status of Sadan?", new String[]{"Necromancer Lord"});
        answers.put("What is the status of Maxor?", new String[]{"The Wither Lords"});
        answers.put("What is the status of Goldor?", new String[]{"The Wither Lords"});
        answers.put("What is the status of Storm?", new String[]{"The Wither Lords"});
        answers.put("What is the status of Necron?", new String[]{"The Wither Lords"});
        answers.put("What is the status of Maxor, Storm, Goldor, and Necron?", new String[]{"The Wither Lords"});
        answers.put("Which brother is on the Spider's Den?", new String[]{"Rick"});
        answers.put("What is the name of Rick's brother?", new String[]{"Pat"});
        answers.put("glass?", new String[]{"Wool Weaver"});
        answers.put("What is the name of the person that upgrades pets?", new String[]{"Kat"});
        answers.put("What is the name of the lady of the Nether?", new String[]{"Elle"});
        answers.put("Which villager in the Village gives you a Rogue Sword?", new String[]{"Jamie"});
        answers.put("How many unique minions are there?", new String[]{"59 Minions"});
        answers.put("Which of these enemies does not spawn in the Spider's Den?", new String[]{"Zombie Spider", "Cave Spider", "Wither Skeleton", "Dashing Spooder", "Broodfather", "Night Spider"});
        answers.put("Which of these monsters only spawns at night?", new String[]{"Zombie Villager", "Ghast"});
        answers.put("Which of these is not a dragon in The End?", new String[]{"Zoomer Dragon", "Weak Dragon", "Stonk Dragon", "Holy Dragon", "Boomer Dragon", "Booger Dragon", "Older Dragon", "Elder Dragon", "Stable Dragon", "Professor Dragon"});
        FairySouls.runAsyncAfterFairySoulsLoad(() -> {
            answers.put("How many total Fairy Souls are there?", Trivia.getFairySoulsSizeString(null));
            answers.put("How many Fairy Souls are there in Spider's Den?", Trivia.getFairySoulsSizeString("combat_1"));
            answers.put("How many Fairy Souls are there in The End?", Trivia.getFairySoulsSizeString("combat_3"));
            answers.put("How many Fairy Souls are there in The Farming Islands?", Trivia.getFairySoulsSizeString("farming_1"));
            answers.put("How many Fairy Souls are there in Crimson Isle?", Trivia.getFairySoulsSizeString("crimson_isle"));
            answers.put("How many Fairy Souls are there in The Park?", Trivia.getFairySoulsSizeString("foraging_1"));
            answers.put("How many Fairy Souls are there in Jerry's Workshop?", Trivia.getFairySoulsSizeString("winter"));
            answers.put("How many Fairy Souls are there in Hub?", Trivia.getFairySoulsSizeString("hub"));
            answers.put("How many Fairy Souls are there in The Hub?", Trivia.getFairySoulsSizeString("hub"));
            answers.put("How many Fairy Souls are there in Deep Caverns?", Trivia.getFairySoulsSizeString("mining_2"));
            answers.put("How many Fairy Souls are there in Gold Mine?", Trivia.getFairySoulsSizeString("mining_1"));
            answers.put("How many Fairy Souls are there in Dungeon Hub?", Trivia.getFairySoulsSizeString("dungeon_hub"));
        });
    }
}

