/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.puzzle;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.debug.Debug;
import de.hysky.skyblocker.skyblock.dungeon.puzzle.DungeonPuzzle;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.render.RenderHelper;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class TeleportMaze
extends DungeonPuzzle {
    private static final float[] LIME = ColorUtils.getFloatComponents(class_1767.field_7961);
    private static final float[] RED = ColorUtils.getFloatComponents(class_1767.field_7964);
    private static final Set<class_2338> ROOM_CENTERS = Set.of(new class_2338(7, 68, 9), new class_2338(23, 68, 9), new class_2338(7, 68, 17), new class_2338(23, 68, 17), new class_2338(7, 68, 25), new class_2338(15, 68, 25), new class_2338(23, 68, 25));
    private static final Set<class_2338> TELEPORT_PADS = Set.of(new class_2338(15, 69, 12), new class_2338(4, 69, 6), new class_2338(10, 69, 6), new class_2338(20, 69, 6), new class_2338(26, 69, 6), new class_2338(4, 69, 12), new class_2338(10, 69, 12), new class_2338(20, 69, 12), new class_2338(26, 69, 12), new class_2338(4, 69, 14), new class_2338(10, 69, 14), new class_2338(20, 69, 14), new class_2338(26, 69, 14), new class_2338(4, 69, 20), new class_2338(10, 69, 20), new class_2338(20, 69, 20), new class_2338(26, 69, 20), new class_2338(4, 69, 22), new class_2338(10, 69, 22), new class_2338(12, 69, 22), new class_2338(18, 69, 22), new class_2338(20, 69, 22), new class_2338(26, 69, 22), new class_2338(4, 69, 28), new class_2338(10, 69, 28), new class_2338(12, 69, 28), new class_2338(18, 69, 28), new class_2338(20, 69, 28), new class_2338(26, 69, 28), new class_2338(15, 69, 14));
    public static final TeleportMaze INSTANCE = new TeleportMaze();
    private final Map<class_2338, RoomType> pads = new HashMap<class_2338, RoomType>();
    @Nullable
    private class_2338 finalPad;

    private TeleportMaze() {
        super("teleport-maze", "teleport-pad-room");
    }

    public void onTeleport(class_310 client, class_2338 from, class_2338 to) {
        class_2338 player;
        if (!this.shouldSolve() || !DungeonManager.isCurrentRoomMatched() || client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        class_2338 prevPlayer = DungeonManager.getCurrentRoom().actualToRelative(from.method_33096(69));
        if (prevPlayer.equals((Object)(player = DungeonManager.getCurrentRoom().actualToRelative(to.method_33096(69)))) || !TELEPORT_PADS.contains(prevPlayer)) {
            return;
        }
        this.processTeleport((class_1937)client.field_1687, prevPlayer, player);
        class_2338 nearestPad = TELEPORT_PADS.stream().min(Comparator.comparingDouble(pad -> pad.method_10262((class_2382)player))).orElse(null);
        this.processTeleport((class_1937)client.field_1687, nearestPad, prevPlayer);
    }

    private void processTeleport(class_1937 world, class_2338 from, class_2338 to) {
        this.getRoomType(world, to).ifPresent(type -> this.pads.put(DungeonManager.getCurrentRoom().relativeToActual(from), (RoomType)((Object)type)));
    }

    private Optional<RoomType> getRoomType(class_1937 world, class_2338 pos) {
        if (pos.method_10263() == 15 && pos.method_10260() == 12) {
            return Optional.of(RoomType.ENTRANCE);
        }
        return ROOM_CENTERS.stream().filter(center -> center.method_10263() - 3 <= pos.method_10263() && pos.method_10263() <= center.method_10263() + 3 && center.method_10260() - 3 <= pos.method_10260() && pos.method_10260() <= center.method_10260() + 3).findAny().map(DungeonManager.getCurrentRoom()::relativeToActual).map(arg_0 -> ((class_1937)world).method_8320(arg_0)).map(class_4970.class_4971::method_26204).flatMap(RoomType::fromBlock);
    }

    @Override
    public void tick(class_310 client) {
        if (!SkyblockerConfigManager.get().dungeons.puzzleSolvers.solveTeleportMaze || !this.shouldSolve() || this.finalPad != null) {
            return;
        }
        List<class_2338> finalPads = TELEPORT_PADS.stream().filter(pad -> pad.method_10263() != 15).map(DungeonManager.getCurrentRoom()::relativeToActual).filter(pad -> !this.pads.containsKey(pad)).toList();
        if (finalPads.size() == 1) {
            this.finalPad = finalPads.getFirst();
        }
    }

    @Override
    public void render(WorldRenderContext context) {
        if (!SkyblockerConfigManager.get().dungeons.puzzleSolvers.solveTeleportMaze || !this.shouldSolve()) {
            return;
        }
        boolean debug = Debug.debugEnabled();
        for (Map.Entry<class_2338, RoomType> entry : this.pads.entrySet()) {
            float[] color = debug ? entry.getValue().colorComponents : RED;
            RenderHelper.renderFilled(context, entry.getKey(), color, 0.5f, debug);
        }
        if (this.finalPad != null) {
            RenderHelper.renderFilled(context, this.finalPad, LIME, 1.0f, true);
            RenderHelper.renderLineFromCursor(context, class_243.method_24953((class_2382)this.finalPad), LIME, 1.0f, 2.0f);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.pads.clear();
        this.finalPad = null;
    }

    private static enum RoomType {
        ENTRANCE(class_2246.field_10499, class_1767.field_7944),
        COAL(class_2246.field_10418, class_1767.field_7963),
        IRON(class_2246.field_10212, class_1767.field_7967),
        REDSTONE(class_2246.field_10080, class_1767.field_7964),
        LAPIS(class_2246.field_10090, class_1767.field_7966),
        GOLD(class_2246.field_10571, class_1767.field_7947),
        DIAMOND(class_2246.field_10442, class_1767.field_7955),
        EMERALD(class_2246.field_10013, class_1767.field_7961);

        private final class_2248 block;
        private final float[] colorComponents;

        private RoomType(class_2248 block, class_1767 dyeColor) {
            this.block = block;
            this.colorComponents = ColorUtils.getFloatComponents(dyeColor);
        }

        private static Optional<RoomType> fromBlock(class_2248 block) {
            return Arrays.stream(RoomType.values()).filter(type -> type.block == block).findFirst();
        }
    }
}

