/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.DungeonsConfig;
import de.hysky.skyblocker.skyblock.dungeon.DungeonClass;
import de.hysky.skyblocker.skyblock.dungeon.DungeonMap;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonPlayerManager;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.render.HudHelper;
import de.hysky.skyblocker.utils.scheduler.MessageScheduler;
import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_10799;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1712;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import net.minecraft.class_7843;
import net.minecraft.class_7845;
import net.minecraft.class_8021;
import net.minecraft.class_8667;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public class LeapOverlay
extends class_437
implements class_1712 {
    public static final String TITLE = "Spirit Leap";
    private static final class_310 CLIENT = class_310.method_1551();
    private static final class_2960 BUTTON = class_2960.method_60655((String)"skyblocker", (String)"button/button");
    private static final class_2960 BUTTON_HIGHLIGHTED = class_2960.method_60655((String)"skyblocker", (String)"button/button_highlighted");
    private static final Supplier<DungeonsConfig.SpiritLeapOverlay> CONFIG = () -> SkyblockerConfigManager.get().dungeons.leapOverlay;
    private static final int BUTTON_SPACING = 8;
    private static final int BUTTON_WIDTH = 130;
    private static final int BUTTON_HEIGHT = 50;
    private final class_1707 handler;
    private final SortedSet<PlayerReference> references = new TreeSet<PlayerReference>();
    @Nullable
    private UUID hovered;

    public LeapOverlay(class_1707 handler) {
        super((class_2561)class_2561.method_43470((String)"Skyblocker Leap Overlay"));
        this.handler = handler;
        this.field_22787 = CLIENT;
        handler.method_7596((class_1712)this);
    }

    public static boolean shouldShowMap() {
        return DungeonManager.isClearingDungeon() && LeapOverlay.CONFIG.get().showMap;
    }

    protected void method_25426() {
        class_8667 layout = class_8667.method_52741();
        layout.method_52735(32).method_52740().method_46467();
        if (LeapOverlay.shouldShowMap()) {
            layout.method_52736((class_8021)new MapWidget(0, 0));
        }
        class_7845 gridWidget = new class_7845().method_48637(8);
        class_7845.class_7939 adder = gridWidget.method_47610(2);
        for (PlayerReference reference : this.references) {
            adder.method_47612((class_8021)new PlayerButton(0, 0, (int)(130.0f * LeapOverlay.CONFIG.get().scale), (int)(50.0f * LeapOverlay.CONFIG.get().scale), reference));
        }
        layout.method_52736((class_8021)gridWidget);
        layout.method_48222();
        class_7843.method_46442((class_8021)layout, (int)0, (int)0, (int)this.field_22789, (int)this.field_22790);
        layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
    }

    public void method_7635(class_1703 handler, int slotId, class_1799 stack) {
        int containerSlots = this.handler.method_17388() * 9;
        if (slotId < containerSlots && stack.method_31574(class_1802.field_8575) && stack.method_57826(class_9334.field_49617)) {
            PlayerStatus playerStatus;
            class_9296 profile = (class_9296)stack.method_58694(class_9334.field_49617);
            if (profile.comp_2411().isEmpty()) {
                return;
            }
            UUID uuid = (UUID)profile.comp_2411().get();
            String name = stack.method_7964().getString();
            DungeonClass dungeonClass = DungeonPlayerManager.getClassFromPlayer(name);
            String string = ItemUtils.getConcatenatedLore(stack).toLowerCase(Locale.ENGLISH);
            Objects.requireNonNull(string);
            String string2 = string;
            int n = 0;
            block4: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, String.class}, (Object)string2, n)) {
                    case 0: {
                        String s = string2;
                        if (!s.contains("dead")) {
                            n = 1;
                            continue block4;
                        }
                        playerStatus = PlayerStatus.DEAD;
                        break block4;
                    }
                    case 1: {
                        String s = string2;
                        if (!s.contains("offline")) {
                            n = 2;
                            continue block4;
                        }
                        playerStatus = PlayerStatus.OFFLINE;
                        break block4;
                    }
                    default: {
                        playerStatus = null;
                        break block4;
                    }
                }
                break;
            }
            PlayerStatus status = playerStatus;
            this.updateReference(new PlayerReference(uuid, name, dungeonClass, status, handler.field_7763, slotId));
        }
    }

    public void method_7633(class_1703 handler, int property, int value) {
    }

    private void updateReference(PlayerReference reference) {
        this.references.remove(reference);
        this.references.add(reference);
        this.method_41843();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        if (LeapOverlay.CONFIG.get().leapKeybinds) {
            boolean result;
            switch (keyCode) {
                case 49: {
                    boolean bl = this.leapToPlayer(0);
                    break;
                }
                case 50: {
                    boolean bl = this.leapToPlayer(1);
                    break;
                }
                case 51: {
                    boolean bl = this.leapToPlayer(2);
                    break;
                }
                case 52: {
                    boolean bl = this.leapToPlayer(3);
                    break;
                }
                default: {
                    boolean bl = result = false;
                }
            }
            if (result) {
                return true;
            }
        }
        return false;
    }

    private boolean leapToPlayer(int index) {
        PlayerReference[] players = (PlayerReference[])this.references.toArray(PlayerReference[]::new);
        if (players.length > 0 && index < players.length) {
            players[index].clickSlot();
            return true;
        }
        return false;
    }

    public void method_25393() {
        super.method_25393();
        if (!this.field_22787.field_1724.method_5805() || this.field_22787.field_1724.method_31481()) {
            this.field_22787.field_1724.method_7346();
        }
    }

    public void method_25419() {
        this.field_22787.field_1724.method_7346();
        super.method_25419();
    }

    public void method_25432() {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.handler.method_7595((class_1657)this.field_22787.field_1724);
            this.handler.method_7603((class_1712)this);
        }
    }

    public class MapWidget
    extends class_339 {
        public MapWidget(int x, int y) {
            super(x, y, (int)(128.0f * LeapOverlay.CONFIG.get().scale), (int)(128.0f * LeapOverlay.CONFIG.get().scale), (class_2561)class_2561.method_43471((String)"skyblocker.config.dungeons.map.fancyMap"));
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            LeapOverlay.this.hovered = DungeonMap.render(context, this.method_46426(), this.method_46427(), LeapOverlay.CONFIG.get().scale, true, mouseX - this.method_46426(), mouseY - this.method_46427(), LeapOverlay.this.method_19355(mouseX, mouseY).filter(PlayerButton.class::isInstance).map(PlayerButton.class::cast).map(p -> p.reference.uuid()).orElse(null));
            context.method_49601(this.method_46426(), this.method_46427(), (int)(128.0f * LeapOverlay.CONFIG.get().scale), (int)(128.0f * LeapOverlay.CONFIG.get().scale), -1);
        }

        public void method_25348(double mouseX, double mouseY) {
            if (LeapOverlay.this.hovered == null) {
                return;
            }
            assert (LeapOverlay.this.field_22787 != null && ((LeapOverlay)LeapOverlay.this).field_22787.field_1724 != null && ((LeapOverlay)LeapOverlay.this).field_22787.field_1761 != null);
            LeapOverlay.this.references.stream().filter(ref -> ref.uuid().equals(LeapOverlay.this.hovered)).findAny().ifPresent(PlayerReference::clickSlot);
        }

        protected void method_47399(class_6382 builder) {
        }
    }

    private record PlayerReference(UUID uuid, String name, DungeonClass dungeonClass, @Nullable PlayerStatus status, int syncId, int slotId) implements Comparable<PlayerReference>
    {
        private static final Comparator<PlayerReference> COMPARATOR = Comparator.comparing(ref -> ref.dungeonClass().displayName()).thenComparing(PlayerReference::name);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof PlayerReference)) return false;
            PlayerReference playerRef = (PlayerReference)obj;
            if (!this.uuid.equals(playerRef.uuid)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.uuid.hashCode();
        }

        @Override
        public int compareTo(@NotNull PlayerReference o) {
            return COMPARATOR.compare(this, o);
        }

        private void clickSlot() {
            LeapOverlay.CLIENT.field_1761.method_2906(this.syncId(), this.slotId(), 0, class_1713.field_7790, (class_1657)LeapOverlay.CLIENT.field_1724);
            if (LeapOverlay.CONFIG.get().enableLeapMessage) {
                MessageScheduler.INSTANCE.sendMessageAfterCooldown("/pc " + Constants.PREFIX.get().getString() + LeapOverlay.CONFIG.get().leapMessage.replaceAll("\\[name]", this.name), false);
            }
        }
    }

    private class PlayerButton
    extends class_4185 {
        private static final int BORDER_THICKNESS = 2;
        private static final int HEAD_SIZE = 24;
        private final PlayerReference reference;

        private PlayerButton(int x, int y, int width, int height, PlayerReference reference) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), b -> {}, ts -> class_2561.method_43473());
            this.reference = reference;
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            class_2960 texture = this.method_25367() || this.reference.uuid().equals(LeapOverlay.this.hovered) ? BUTTON_HIGHLIGHTED : BUTTON;
            context.method_52706(class_10799.field_56883, texture, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
            Matrix3x2fStack matrices = context.method_51448();
            float scale = LeapOverlay.CONFIG.get().scale;
            int baseX = this.method_46426() + 2;
            int centreX = this.method_46426() + (this.method_25368() >> 1);
            int centreY = this.method_46427() + (this.method_25364() >> 1);
            Objects.requireNonNull(LeapOverlay.CLIENT.field_1772);
            int halfFontHeight = (int)(9.0f * scale) >> 1;
            HudHelper.drawPlayerHead(context, baseX + 4, centreY - ((int)(24.0f * scale) >> 1), (int)(24.0f * scale), this.reference.uuid());
            matrices.pushMatrix();
            matrices.translate((float)centreX, (float)(this.method_46427() + halfFontHeight));
            matrices.scale(scale, scale);
            context.method_25300(LeapOverlay.CLIENT.field_1772, this.reference.dungeonClass().displayName(), 0, 0, this.reference.dungeonClass().color());
            matrices.popMatrix();
            matrices.pushMatrix();
            matrices.translate((float)baseX + 24.0f * scale + 8.0f, (float)(centreY - halfFontHeight));
            matrices.scale(scale, scale);
            context.method_27535(LeapOverlay.CLIENT.field_1772, (class_2561)class_2561.method_43470((String)this.reference.name()), 0, 0, -1);
            matrices.popMatrix();
            if (this.reference.status() != null) {
                matrices.pushMatrix();
                matrices.translate((float)centreX, (float)(this.method_46427() + this.method_25364() - halfFontHeight * 3));
                matrices.scale(scale, scale);
                context.method_27534(LeapOverlay.CLIENT.field_1772, this.reference.status().text.get(), 0, 0, -1);
                matrices.popMatrix();
                context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), this.reference.status().overlayColor);
            }
        }

        public void method_25348(double mouseX, double mouseY) {
            this.reference.clickSlot();
        }
    }

    private static enum PlayerStatus {
        DEAD(() -> class_2561.method_43471((String)"text.skyblocker.dead").method_54663(-65536), class_9848.method_61330((int)64, (int)-2142128)),
        OFFLINE(() -> class_2561.method_43471((String)"text.skyblocker.offline").method_54663(-8355712), class_9848.method_61330((int)64, (int)-6250336));

        private final Supplier<class_2561> text;
        private final int overlayColor;

        private PlayerStatus(Supplier<class_2561> text, int overlayColor) {
            this.text = text;
            this.overlayColor = overlayColor;
        }
    }
}

