/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon;

import com.mojang.serialization.Codec;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.RegisterWidget;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.ChatEvents;
import de.hysky.skyblocker.events.DungeonEvents;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.skyblock.tabhud.config.WidgetsConfigurationScreen;
import de.hysky.skyblocker.skyblock.tabhud.widget.TableWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.PlainTextComponent;
import de.hysky.skyblocker.utils.CodecUtils;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.data.ProfiledData;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;

@RegisterWidget
public class DungeonSplitsWidget
extends TableWidget {
    private static final Pattern FLOOR_PATTERN = Pattern.compile(".*?(?=T)The Catacombs \\((?<floor>[EFM]\\D*\\d*)\\)");
    private static final Pattern DUNGEON_START = Pattern.compile("\\[NPC] Mort: Here, I found this map when I first entered the dungeon\\.|\\[NPC] Mort: Right-click the Orb for spells, and Left-click \\(or Drop\\) to use your Ultimate!");
    private static final Pattern BLOOD_OPEN = Pattern.compile("^\\[BOSS] The Watcher: (Congratulations, you made it through the Entrance\\.|Ah, you've finally arrived\\.|Ah, we meet again\\.\\.\\.|So you made it this far\\.\\.\\. interesting\\.|You've managed to scratch and claw your way here, eh\\?|I'm starting to get tired of seeing you around here\\.\\.|Oh\\.\\. hello\\?|Things feel a little more roomy now, eh\\?)$|^The BLOOD DOOR has been opened!$");
    private static final Pattern BLOOD_CLEAR = Pattern.compile("\\[BOSS] The Watcher: You have proven yourself\\. You may pass\\.");
    private static final Pattern DUNGEON_END = Pattern.compile("^\\s*\u2620 Defeated (.+) in 0?([\\dhms ]+?)\\s*(\\(NEW RECORD!\\))?$");
    private static final Pattern F1_ENTRY = Pattern.compile("^\\[BOSS] Bonzo: Gratz for making it this far, but I'm basically unbeatable\\.$");
    private static final Pattern F2_ENTRY = Pattern.compile("^\\[BOSS] Scarf: This is where the journey ends for you, Adventurers\\.$");
    private static final Pattern F3_ENTRY = Pattern.compile("^\\[BOSS] The Professor: I was burdened with terrible news recently\\.\\.\\.$");
    private static final Pattern F4_ENTRY = Pattern.compile("^\\[BOSS] Thorn: Welcome Adventurers! I am Thorn, the Spirit! And host of the Vegan Trials!$");
    private static final Pattern F5_ENTRY = Pattern.compile("^\\[BOSS] Livid: Welcome, you've arrived right on time\\. I am Livid, the Master of Shadows\\.$");
    private static final Pattern F6_ENTRY = Pattern.compile("^\\[BOSS] Sadan: So you made it all the way here\\.\\.\\. Now you wish to defy me\\? Sadan\\?!$");
    private static final Pattern F7_ENTRY = Pattern.compile("^\\[BOSS] Maxor: WELL! WELL! WELL! LOOK WHO'S HERE!$");
    private static final Pattern F7_MAXOR = Pattern.compile("^\\[BOSS] Storm: Pathetic Maxor, just like expected\\.$");
    private static final Pattern F7_STORM = Pattern.compile("^\\[BOSS] Goldor: Who dares trespass into my domain\\?$");
    private static final Pattern F7_TERMINALS = Pattern.compile("^The Core entrance is opening!$");
    private static final Pattern F7_GOLDOR = Pattern.compile("^\\[BOSS] Necron: You went further than any human before, congratulations\\.$");
    private static final Pattern F7_NECRON = Pattern.compile("^\\[BOSS] Necron: All this, for nothing\\.\\.\\.$");
    private static final Pattern BONZO_SIKE = Pattern.compile("\\[BOSS] Bonzo: Oh I'm dead!");
    private static final Pattern SCARF_MINIONS = Pattern.compile("^\\[BOSS] Scarf: Did you forget\\? I was taught by the best! Let's dance\\.$");
    private static final Pattern GUARDIANS = Pattern.compile("^\\[BOSS] The Professor: Oh\\? You found my Guardians' one weakness\\?$");
    private static final Pattern PROFESSOR = Pattern.compile("^\\[BOSS] The Professor: I see. You have forced me to use my ultimate technique\\.$");
    private static final Pattern TERRACOTTAS = Pattern.compile("^\\[BOSS] Sadan: ENOUGH!$");
    private static final Pattern SADAN_GIANTS = Pattern.compile("^\\[BOSS] Sadan: You did it. I understand now, you have earned my respect\\.$");
    private static final int[] SPLIT_COLORS = new int[]{16603224, 16624472, 16645464, 11271512, 5832024, 5832107, 5811197, 5789949, 11229437, 16603389};
    private static final Map<String, List<Split>> FLOOR_SPLITS = new HashMap<String, List<Split>>();
    private static final Path BEST_FILE;
    private static final Codec<Object2ObjectMap<String, Object2LongMap<String>>> BEST_CODEC;
    private static final ProfiledData<Object2ObjectMap<String, Object2LongMap<String>>> BEST_SPLITS;
    private static final Set<Location> AVAILABLE_LOCATIONS;
    private static DungeonSplitsWidget instance;
    private final List<Split> splits = new ArrayList<Split>();
    private long startTime = 0L;
    private long elapsedTime = 0L;
    private boolean running = false;
    private class_124 timerColor = class_124.field_1054;
    private String floor = "?";
    private String loadedFloor = null;

    public DungeonSplitsWidget() {
        super(class_2561.method_43470((String)"Splits").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_124.field_1065.method_532(), "Dungeon Splits", 3, 0, false);
        instance = this;
        BEST_SPLITS.init();
        DungeonEvents.DUNGEON_LOADED.register(this::onDungeonLoaded);
        ChatEvents.RECEIVE_STRING.register(this::onChatMessage);
        SkyblockEvents.LOCATION_CHANGE.register(this::onLocationChange);
    }

    public static DungeonSplitsWidget getInstance() {
        return instance;
    }

    private void onDungeonLoaded() {
        this.running = false;
        this.elapsedTime = 0L;
        this.startTime = 0L;
        this.timerColor = class_124.field_1054;
        this.loadedFloor = null;
        this.updateFloor();
        this.loadFloorSplits();
    }

    private void onLocationChange(Location location) {
        if (location != Location.DUNGEON) {
            if (this.running) {
                this.stopTimer(false);
            }
            this.running = false;
            this.elapsedTime = 0L;
            this.startTime = 0L;
            this.floor = "?";
            this.loadedFloor = null;
            this.splits.clear();
        }
    }

    private void onChatMessage(String message) {
        if (!Utils.isInDungeons()) {
            return;
        }
        String stripped = class_124.method_539((String)message);
        if (!this.running && DUNGEON_START.matcher(stripped).matches()) {
            this.startTime = System.currentTimeMillis();
            this.elapsedTime = 0L;
            this.running = true;
            this.timerColor = class_124.field_1054;
            for (Split split : this.splits) {
                split.reset();
            }
            return;
        }
        if (!this.running) {
            return;
        }
        for (int i = 0; i < this.splits.size(); ++i) {
            Split split = this.splits.get(i);
            if (split.completed || !split.trigger.matcher(stripped).matches()) continue;
            long time = System.currentTimeMillis() - this.startTime;
            split.complete(time);
            long prev = i == 0 ? 0L : this.splits.get((int)(i - 1)).completedTime;
            long segment = time - prev;
            this.updateBest(split, segment);
            if (i == this.splits.size() - 1) {
                this.stopTimer(true);
            }
            return;
        }
        if (stripped.contains("EXTRA STATS")) {
            boolean allCompleted = true;
            for (Split split : this.splits) {
                if (split.completed) continue;
                allCompleted = false;
                break;
            }
            if (!allCompleted) {
                this.stopTimer(false);
            }
        }
    }

    private void updateFloor() {
        String old = this.floor;
        for (String line : Utils.STRING_SCOREBOARD) {
            Matcher m = FLOOR_PATTERN.matcher(line);
            if (!m.matches()) continue;
            this.floor = m.group("floor");
            break;
        }
        if (!this.floor.equals(old)) {
            this.loadFloorSplits();
        }
    }

    private void loadFloorSplits() {
        if (this.floor.equals(this.loadedFloor) || this.floor.equals("?")) {
            return;
        }
        this.loadedFloor = this.floor;
        this.splits.clear();
        List<Split> group = FLOOR_SPLITS.get(this.floor);
        if (group != null) {
            Object2ObjectMap data = BEST_SPLITS.computeIfAbsent(Object2ObjectOpenHashMap::new);
            Object2LongMap floorData = (Object2LongMap)data.get((Object)this.floor);
            for (Split s : group) {
                long best = floorData != null ? floorData.getOrDefault((Object)s.key, 0L) : 0L;
                this.splits.add(new Split(s.key, s.trigger, best));
            }
        }
    }

    @Override
    public boolean shouldUpdateBeforeRendering() {
        return true;
    }

    @Override
    public Set<Location> availableLocations() {
        return AVAILABLE_LOCATIONS;
    }

    @Override
    public void setEnabledIn(Location location, boolean enabled) {
        if (location != Location.DUNGEON) {
            return;
        }
        SkyblockerConfigManager.get().dungeons.dungeonSplits = enabled;
    }

    @Override
    public boolean isEnabledIn(Location location) {
        return location == Location.DUNGEON && SkyblockerConfigManager.get().dungeons.dungeonSplits;
    }

    @Override
    public void updateContent() {
        if (!(class_310.method_1551().field_1755 instanceof WidgetsConfigurationScreen)) {
            this.updateFloor();
            this.loadFloorSplits();
        }
        this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43470((String)("Floor: " + this.floor))));
        super.updateContent();
        long now = this.running ? System.currentTimeMillis() - this.startTime : (this.startTime == 0L ? 0L : this.elapsedTime);
        this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43470((String)DungeonSplitsWidget.formatTime(now)).method_27692(this.timerColor)));
    }

    @Override
    protected List<TableWidget.Row> buildRows() {
        long now = this.running ? System.currentTimeMillis() - this.startTime : (this.startTime == 0L ? 0L : this.elapsedTime);
        long previous = 0L;
        boolean showingCurrent = false;
        ArrayList<TableWidget.Row> rows = new ArrayList<TableWidget.Row>();
        for (int idx = 0; idx < this.splits.size(); ++idx) {
            PlainTextComponent right;
            PlainTextComponent mid;
            Split split = this.splits.get(idx);
            PlainTextComponent name = new PlainTextComponent((class_2561)class_2561.method_43471((String)split.key).method_54663(SPLIT_COLORS[idx % SPLIT_COLORS.length]));
            String bestStr = DungeonSplitsWidget.formatTime(split.bestTime);
            int border = 0;
            if (split.completed) {
                segmentTime = split.completedTime - previous;
                long diff = segmentTime - split.bestTime;
                class_124 fmt = diff <= 0L ? class_124.field_1060 : class_124.field_1061;
                String diffStr = String.format("%+.2fs", (double)diff / 1000.0);
                mid = new PlainTextComponent((class_2561)class_2561.method_43470((String)diffStr).method_27692(fmt));
                right = new PlainTextComponent((class_2561)class_2561.method_43470((String)DungeonSplitsWidget.formatTime(split.completedTime)).method_27692(class_124.field_1054));
                previous = split.completedTime;
            } else if (!showingCurrent && (this.running || this.startTime != 0L)) {
                segmentTime = now - previous;
                mid = new PlainTextComponent((class_2561)class_2561.method_43470((String)DungeonSplitsWidget.formatTime(segmentTime)));
                right = new PlainTextComponent((class_2561)class_2561.method_43470((String)bestStr));
                showingCurrent = true;
                border = SPLIT_COLORS[idx % SPLIT_COLORS.length];
            } else {
                mid = new PlainTextComponent((class_2561)class_2561.method_43470((String)"--"));
                right = new PlainTextComponent((class_2561)class_2561.method_43470((String)bestStr));
            }
            rows.add(new TableWidget.Row(List.of(name, mid, right), border));
        }
        return rows;
    }

    private void stopTimer(boolean success) {
        if (this.running) {
            this.elapsedTime = System.currentTimeMillis() - this.startTime;
            this.running = false;
            if (success) {
                Object2ObjectOpenHashMap data = new Object2ObjectOpenHashMap(BEST_SPLITS.computeIfAbsent(Object2ObjectOpenHashMap::new));
                Object2LongOpenHashMap floorData = new Object2LongOpenHashMap((Object2LongMap)data.getOrDefault((Object)this.floor, (Object)new Object2LongOpenHashMap()));
                boolean updated = false;
                for (Split split : this.splits) {
                    long currentBest;
                    if (!split.completed || (currentBest = floorData.getOrDefault((Object)split.key, 0L)) != 0L && split.completedTime >= currentBest) continue;
                    floorData.put((Object)split.key, split.completedTime);
                    updated = true;
                }
                if (updated) {
                    data.put((Object)this.floor, (Object)floorData);
                    BEST_SPLITS.put((Object2ObjectMap<String, Object2LongMap<String>>)data);
                    BEST_SPLITS.save();
                }
            }
        }
        this.timerColor = success ? class_124.field_1060 : class_124.field_1061;
    }

    private void updateBest(Split split, long completionTime) {
        Object2ObjectOpenHashMap data = new Object2ObjectOpenHashMap(BEST_SPLITS.computeIfAbsent(Object2ObjectOpenHashMap::new));
        Object2LongOpenHashMap floorData = new Object2LongOpenHashMap((Object2LongMap)data.getOrDefault((Object)this.floor, (Object)new Object2LongOpenHashMap()));
        long currentBest = floorData.getOrDefault((Object)split.key, 0L);
        if (currentBest == 0L || completionTime < currentBest) {
            floorData.put((Object)split.key, completionTime);
            data.put((Object)this.floor, (Object)floorData);
            BEST_SPLITS.put((Object2ObjectMap<String, Object2LongMap<String>>)data);
            BEST_SPLITS.save();
        }
    }

    private static String formatTime(long millis) {
        long totalSeconds = millis / 1000L;
        long minutes = totalSeconds / 60L;
        long seconds = totalSeconds % 60L;
        long hundredths = millis % 1000L / 10L;
        return String.format("%02d:%02d.%02d", minutes, seconds, hundredths);
    }

    static {
        List<Split> floor1Splits = List.of(new Split("skyblocker.dungeons.splits.bloodOpen", BLOOD_OPEN), new Split("skyblocker.dungeons.splits.bloodClear", BLOOD_CLEAR), new Split("skyblocker.dungeons.splits.portalEntry", F1_ENTRY), new Split("skyblocker.dungeons.splits.bonzoSike", BONZO_SIKE), new Split("skyblocker.dungeons.splits.bonzo", DUNGEON_END));
        FLOOR_SPLITS.put("F1", floor1Splits);
        FLOOR_SPLITS.put("M1", floor1Splits);
        List<Split> floor2Splits = List.of(new Split("skyblocker.dungeons.splits.bloodOpen", BLOOD_OPEN), new Split("skyblocker.dungeons.splits.bloodClear", BLOOD_CLEAR), new Split("skyblocker.dungeons.splits.portalEntry", F2_ENTRY), new Split("skyblocker.dungeons.splits.scarfMinions", SCARF_MINIONS), new Split("skyblocker.dungeons.splits.scarf", DUNGEON_END));
        FLOOR_SPLITS.put("F2", floor2Splits);
        FLOOR_SPLITS.put("M2", floor2Splits);
        List<Split> floor3Splits = List.of(new Split("skyblocker.dungeons.splits.bloodOpen", BLOOD_OPEN), new Split("skyblocker.dungeons.splits.bloodClear", BLOOD_CLEAR), new Split("skyblocker.dungeons.splits.portalEntry", F3_ENTRY), new Split("skyblocker.dungeons.splits.guardians", GUARDIANS), new Split("skyblocker.dungeons.splits.professor", PROFESSOR), new Split("skyblocker.dungeons.splits.transformedProfessor", DUNGEON_END));
        FLOOR_SPLITS.put("F3", floor3Splits);
        FLOOR_SPLITS.put("M3", floor3Splits);
        List<Split> floor4Splits = List.of(new Split("skyblocker.dungeons.splits.bloodOpen", BLOOD_OPEN), new Split("skyblocker.dungeons.splits.bloodClear", BLOOD_CLEAR), new Split("skyblocker.dungeons.splits.portalEntry", F4_ENTRY), new Split("skyblocker.dungeons.splits.thorn", DUNGEON_END));
        FLOOR_SPLITS.put("F4", floor4Splits);
        FLOOR_SPLITS.put("M4", floor4Splits);
        List<Split> floor5Splits = List.of(new Split("skyblocker.dungeons.splits.bloodOpen", BLOOD_OPEN), new Split("skyblocker.dungeons.splits.bloodClear", BLOOD_CLEAR), new Split("skyblocker.dungeons.splits.portalEntry", F5_ENTRY), new Split("skyblocker.dungeons.splits.livid", DUNGEON_END));
        FLOOR_SPLITS.put("F5", floor5Splits);
        FLOOR_SPLITS.put("M5", floor5Splits);
        List<Split> floor6Splits = List.of(new Split("skyblocker.dungeons.splits.bloodOpen", BLOOD_OPEN), new Split("skyblocker.dungeons.splits.bloodClear", BLOOD_CLEAR), new Split("skyblocker.dungeons.splits.portalEntry", F6_ENTRY), new Split("skyblocker.dungeons.splits.terracottas", TERRACOTTAS), new Split("skyblocker.dungeons.splits.sadanGiants", SADAN_GIANTS), new Split("skyblocker.dungeons.splits.sadan", DUNGEON_END));
        FLOOR_SPLITS.put("F6", floor6Splits);
        FLOOR_SPLITS.put("M6", floor6Splits);
        FLOOR_SPLITS.put("F7", List.of(new Split("skyblocker.dungeons.splits.bloodOpen", BLOOD_OPEN), new Split("skyblocker.dungeons.splits.bloodClear", BLOOD_CLEAR), new Split("skyblocker.dungeons.splits.portalEntry", F7_ENTRY), new Split("skyblocker.dungeons.splits.maxor", F7_MAXOR), new Split("skyblocker.dungeons.splits.storm", F7_STORM), new Split("skyblocker.dungeons.splits.terminals", F7_TERMINALS), new Split("skyblocker.dungeons.splits.goldor", F7_GOLDOR), new Split("skyblocker.dungeons.splits.necron", DUNGEON_END)));
        FLOOR_SPLITS.put("M7", List.of(new Split("skyblocker.dungeons.splits.bloodOpen", BLOOD_OPEN), new Split("skyblocker.dungeons.splits.bloodClear", BLOOD_CLEAR), new Split("skyblocker.dungeons.splits.portalEntry", F7_ENTRY), new Split("skyblocker.dungeons.splits.maxor", F7_MAXOR), new Split("skyblocker.dungeons.splits.storm", F7_STORM), new Split("skyblocker.dungeons.splits.terminals", F7_TERMINALS), new Split("skyblocker.dungeons.splits.goldor", F7_GOLDOR), new Split("skyblocker.dungeons.splits.necron", F7_NECRON), new Split("skyblocker.dungeons.splits.witherKing", DUNGEON_END)));
        BEST_FILE = SkyblockerMod.CONFIG_DIR.resolve("dungeon_split_bests.json");
        BEST_CODEC = CodecUtils.object2ObjectMapCodec(Codec.STRING, CodecUtils.object2LongMapCodec(Codec.STRING));
        BEST_SPLITS = new ProfiledData<Object2ObjectMap<String, Object2LongMap<String>>>(BEST_FILE, BEST_CODEC, true, true);
        AVAILABLE_LOCATIONS = Set.of(Location.DUNGEON);
    }

    private static class Split {
        final String key;
        final Pattern trigger;
        long bestTime;
        long completedTime;
        boolean completed;

        Split(String key, Pattern trigger) {
            this(key, trigger, 0L);
        }

        Split(String key, Pattern trigger, long bestTime) {
            this.key = key;
            this.trigger = trigger;
            this.bestTime = bestTime;
        }

        void complete(long time) {
            this.completed = true;
            this.completedTime = time;
        }

        void reset() {
            this.completed = false;
            this.completedTime = 0L;
        }
    }
}

