/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.crimson.dojo;

import de.hysky.skyblocker.utils.render.RenderHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_310;

public class StaminaTestHelper {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final int WALL_THRESHOLD_VALUE = 13;
    private static final int WALL_HEIGHT = 5;
    private static final float[] INCOMING_COLOR = new float[]{0.0f, 1.0f, 0.0f, 0.0f};
    private static final float[] OUTGOING_COLOR = new float[]{1.0f, 0.64f, 0.0f, 0.0f};
    private static final List<class_238> wallHoles = new ArrayList<class_238>();
    private static final List<class_238> lastHoles = new ArrayList<class_238>();
    private static final Map<class_238, HoleDirection> holeDirections = new HashMap<class_238, HoleDirection>();
    private static class_2338 middleBase;

    protected static void reset() {
        wallHoles.clear();
        lastHoles.clear();
        holeDirections.clear();
        middleBase = null;
    }

    protected static void update() {
        List<class_2338> currentBottomWallLocations = StaminaTestHelper.findWallBlocks();
        if (currentBottomWallLocations == null) {
            return;
        }
        List<class_238> walls = StaminaTestHelper.findWalls(currentBottomWallLocations);
        lastHoles.clear();
        lastHoles.addAll(wallHoles);
        wallHoles.clear();
        for (class_238 wall : walls) {
            wallHoles.addAll(StaminaTestHelper.findHolesInBox(wall));
        }
        HashMap<class_238, HoleDirection> lastHoleDirections = new HashMap<class_238, HoleDirection>(holeDirections);
        holeDirections.clear();
        for (class_238 hole : wallHoles) {
            HoleDirection holeDirection = StaminaTestHelper.getWholeDirection(hole);
            if (holeDirection == HoleDirection.UNCHANGED) {
                holeDirections.put(hole, (HoleDirection)((Object)lastHoleDirections.get(hole)));
                continue;
            }
            holeDirections.put(hole, holeDirection);
        }
    }

    private static List<class_2338> findWallBlocks() {
        if (CLIENT == null || StaminaTestHelper.CLIENT.field_1724 == null || StaminaTestHelper.CLIENT.field_1687 == null) {
            return null;
        }
        class_2338 playerPos = StaminaTestHelper.CLIENT.field_1724.method_24515();
        if (middleBase == null) {
            for (int x = playerPos.method_10263() - 10; x < playerPos.method_10263() + 10; ++x) {
                for (int y = playerPos.method_10264() - 5; y < playerPos.method_10264(); ++y) {
                    for (int z = playerPos.method_10260() - 10; z < playerPos.method_10260() + 10; ++z) {
                        class_2338 pos = new class_2338(x, y, z);
                        class_2680 state = StaminaTestHelper.CLIENT.field_1687.method_8320(pos);
                        if (!state.method_27852(class_2246.field_10552)) continue;
                        middleBase = pos;
                        return null;
                    }
                }
            }
            return null;
        }
        ArrayList<class_2338> currentBottomWallLocations = new ArrayList<class_2338>();
        for (int x = middleBase.method_10263() - 15; x < middleBase.method_10263() + 15; ++x) {
            for (int z = middleBase.method_10260() - 15; z < middleBase.method_10260() + 15; ++z) {
                class_2338 pos = new class_2338(x, middleBase.method_10264() + 1, z);
                class_2680 state = StaminaTestHelper.CLIENT.field_1687.method_8320(pos);
                if (state.method_26215()) continue;
                currentBottomWallLocations.add(pos);
            }
        }
        return currentBottomWallLocations;
    }

    private static List<class_238> findWalls(List<class_2338> currentBottomWallLocations) {
        Int2ObjectOpenHashMap possibleWallsX = new Int2ObjectOpenHashMap();
        Int2ObjectOpenHashMap possibleWallsZ = new Int2ObjectOpenHashMap();
        for (class_2338 block : currentBottomWallLocations) {
            int x = block.method_10263();
            if (!possibleWallsX.containsKey(x)) {
                possibleWallsX.put(x, new ArrayList());
            }
            ((List)possibleWallsX.get(x)).add(block);
            int z = block.method_10260();
            if (!possibleWallsZ.containsKey(z)) {
                possibleWallsZ.put(z, new ArrayList());
            }
            ((List)possibleWallsZ.get(z)).add(block);
        }
        ArrayList<List> walls = new ArrayList<List>();
        for (List line : possibleWallsX.values()) {
            if (line.size() < 13) continue;
            walls.add(line);
        }
        for (List line : possibleWallsZ.values()) {
            if (line.size() < 13) continue;
            walls.add(line);
        }
        ArrayList<class_238> wallBoxes = new ArrayList<class_238>();
        for (List wall : walls) {
            class_2338 minPos = (class_2338)wall.getFirst();
            class_2338 maxPos = (class_2338)wall.getFirst();
            for (class_2338 pos : wall) {
                if (pos.method_10263() < minPos.method_10263()) {
                    minPos = new class_2338(pos.method_10263(), minPos.method_10264(), minPos.method_10260());
                }
                if (pos.method_10260() < minPos.method_10260()) {
                    minPos = new class_2338(minPos.method_10263(), minPos.method_10264(), pos.method_10260());
                }
                if (pos.method_10263() > maxPos.method_10263()) {
                    maxPos = new class_2338(pos.method_10263(), maxPos.method_10264(), maxPos.method_10260());
                }
                if (pos.method_10260() <= maxPos.method_10260()) continue;
                maxPos = new class_2338(maxPos.method_10263(), maxPos.method_10264(), pos.method_10260());
            }
            maxPos = new class_2338(maxPos.method_10263(), maxPos.method_10264() + 5, maxPos.method_10260());
            wallBoxes.add(class_238.method_54784((class_2338)minPos, (class_2338)maxPos));
        }
        return wallBoxes;
    }

    private static List<class_238> findHolesInBox(class_238 box) {
        ArrayList<class_238> holes = new ArrayList<class_238>();
        if (CLIENT == null || StaminaTestHelper.CLIENT.field_1724 == null || StaminaTestHelper.CLIENT.field_1687 == null) {
            return holes;
        }
        class_2382 wallDirection = box.method_17939() == 1.0 ? new class_2382(0, 0, 1) : new class_2382(1, 0, 0);
        ArrayList<class_2338> topLeft = new ArrayList<class_2338>();
        ArrayList<class_2338> topRight = new ArrayList<class_2338>();
        ArrayList<class_2338> bottomLeft = new ArrayList<class_2338>();
        int z = (int)box.field_1321;
        while ((double)z < box.field_1324) {
            int x = (int)box.field_1323;
            while ((double)x < box.field_1320) {
                int y = (int)box.field_1322;
                while ((double)y < box.field_1325) {
                    class_2338 pos = new class_2338(x, y, z);
                    class_2680 state = StaminaTestHelper.CLIENT.field_1687.method_8320(pos);
                    if (state.method_26215()) {
                        boolean right;
                        boolean top = (double)y == box.field_1325 - 1.0 || !StaminaTestHelper.CLIENT.field_1687.method_8320(pos.method_10069(0, 1, 0)).method_26215();
                        boolean bottom = !StaminaTestHelper.CLIENT.field_1687.method_8320(pos.method_10069(0, -1, 0)).method_26215();
                        boolean left = !StaminaTestHelper.CLIENT.field_1687.method_8320(pos.method_10081(wallDirection)).method_26215();
                        boolean bl = right = !StaminaTestHelper.CLIENT.field_1687.method_8320(pos.method_10059(wallDirection)).method_26215();
                        if (top) {
                            if (left) {
                                topLeft.add(pos);
                            }
                            if (right) {
                                topRight.add(pos);
                            }
                        }
                        if (bottom && left) {
                            bottomLeft.add(pos);
                        }
                    }
                    ++y;
                }
                ++x;
            }
            ++z;
        }
        for (int i = 0; i < topLeft.size() && topRight.size() > i && bottomLeft.size() > i; ++i) {
            class_238 hole = class_238.method_54784((class_2338)((class_2338)topLeft.get(i)), (class_2338)((class_2338)topRight.get(i)));
            hole = hole.method_1012(0.0, (double)(((class_2338)bottomLeft.get(i)).method_10264() - ((class_2338)topLeft.get(i)).method_10264()), 0.0);
            holes.add(hole);
        }
        return holes;
    }

    private static HoleDirection getWholeDirection(class_238 hole) {
        if (lastHoles.contains(hole)) {
            return HoleDirection.UNCHANGED;
        }
        class_238 posX = hole.method_989(1.0, 0.0, 0.0);
        if (lastHoles.contains(posX)) {
            return HoleDirection.POSITIVE_X;
        }
        class_238 negX = hole.method_989(-1.0, 0.0, 0.0);
        if (lastHoles.contains(negX)) {
            return HoleDirection.NEGATIVE_X;
        }
        class_238 posZ = hole.method_989(0.0, 0.0, 1.0);
        if (lastHoles.contains(posZ)) {
            return HoleDirection.POSITIVE_Z;
        }
        class_238 negZ = hole.method_989(0.0, 0.0, -1.0);
        if (lastHoles.contains(negZ)) {
            return HoleDirection.NEGATIVE_Z;
        }
        return HoleDirection.NEW;
    }

    protected static void render(WorldRenderContext context) {
        if (wallHoles.isEmpty() || CLIENT == null || StaminaTestHelper.CLIENT.field_1724 == null) {
            return;
        }
        class_2338 playerPos = StaminaTestHelper.CLIENT.field_1724.method_24515();
        for (class_238 hole : wallHoles) {
            float[] color = StaminaTestHelper.isHoleIncoming(hole, holeDirections.get(hole), playerPos) ? INCOMING_COLOR : OUTGOING_COLOR;
            RenderHelper.renderFilled(context, hole, color, 0.3f, false);
        }
    }

    private static boolean isHoleIncoming(class_238 holePos, HoleDirection holeDirection, class_2338 playerPos) {
        return switch (holeDirection.ordinal()) {
            case 0 -> {
                if ((double)playerPos.method_10263() < holePos.field_1323) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if ((double)playerPos.method_10260() < holePos.field_1321) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if ((double)playerPos.method_10263() > holePos.field_1320) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if ((double)playerPos.method_10260() > holePos.field_1324) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    private static enum HoleDirection {
        POSITIVE_X,
        POSITIVE_Z,
        NEGATIVE_X,
        NEGATIVE_Z,
        NEW,
        UNCHANGED;

    }
}

