/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.bazaar;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.item.slottext.SimpleSlotTextAdder;
import de.hysky.skyblocker.skyblock.item.slottext.SlotText;
import de.hysky.skyblocker.utils.ItemUtils;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BazaarHelper
extends SimpleSlotTextAdder {
    private static final Pattern FILLED_PATTERN = Pattern.compile("Filled: \\S+ \\(?([\\d.]+)%\\)?!?");
    private static final int RED = 15076126;
    private static final int YELLOW = 15120907;
    private static final int GREEN = 2024971;

    public BazaarHelper() {
        super("(?:Co-op|Your) Bazaar Orders");
    }

    @Override
    public boolean isEnabled() {
        return SkyblockerConfigManager.get().helpers.bazaar.enableBazaarHelper;
    }

    @Override
    @NotNull
    public List<SlotText> getText(@Nullable class_1735 slot, @NotNull class_1799 stack, int slotId) {
        List<class_2561> lore;
        if (slot == null) {
            return List.of();
        }
        if (slotId < 10) {
            return List.of();
        }
        if (slotId > slot.field_7871.method_5439() - 11) {
            return List.of();
        }
        int column = slotId % 9;
        if (column == 0 || column == 8) {
            return List.of();
        }
        class_1799 item = slot.method_7677();
        if (item.method_7960()) {
            return List.of();
        }
        Matcher matcher = ItemUtils.getLoreLineIfMatch(item, FILLED_PATTERN);
        if (matcher != null && !(lore = ItemUtils.getLore(item)).isEmpty() && lore.getLast().getString().equals("Click to claim!")) {
            int filled = NumberUtils.toInt((String)matcher.group(1));
            return SlotText.topLeftList((class_2561)BazaarHelper.getFilledIcon(filled));
        }
        if (ItemUtils.getLoreLineIf(item, str -> str.equals("Expired!")) != null) {
            return SlotText.topLeftList((class_2561)BazaarHelper.getExpiredIcon());
        }
        if (ItemUtils.getLoreLineIf(item, str -> str.startsWith("Expires in")) != null) {
            return SlotText.topLeftList((class_2561)BazaarHelper.getExpiringIcon());
        }
        return List.of();
    }

    @NotNull
    public static class_5250 getExpiredIcon() {
        return class_2561.method_43470((String)"\u23f0").method_54663(15076126).method_27692(class_124.field_1067);
    }

    @NotNull
    public static class_5250 getExpiringIcon() {
        return class_2561.method_43470((String)"\u23f0").method_54663(15120907).method_27692(class_124.field_1067);
    }

    @NotNull
    public static class_5250 getFilledIcon(int filled) {
        if (filled < 100) {
            return class_2561.method_43470((String)"%").method_54663(15120907).method_27692(class_124.field_1067);
        }
        return class_2561.method_43470((String)"\u2705").method_54663(2024971).method_27692(class_124.field_1067);
    }
}

