/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.PetCache;
import de.hysky.skyblocker.skyblock.fancybars.FancyStatusBars;
import de.hysky.skyblocker.skyblock.fancybars.StatusBarType;
import de.hysky.skyblocker.skyblock.item.PetInfo;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.RegexUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class StatusBarTracker {
    private static final Pattern STATUS_HEALTH = Pattern.compile("\u00a7[6c](?<health>[\\d,]+)/(?<max>[\\d,]+)\u2764 *(?<healing>\\+\u00a7c([\\d,]+). *)?");
    private static final Pattern DEFENSE_STATUS = Pattern.compile("\u00a7a(?<defense>[\\d,]+)\u00a7a\u2748 Defense *");
    private static final Pattern MANA_USE = Pattern.compile("\u00a7b-([\\d,]+) Mana \\(\u00a7.*?\\) *");
    private static final Pattern MANA_STATUS = Pattern.compile("\u00a7b(?<mana>[\\d,]+)/(?<max>[\\d,]+)\u270e (?:Mana|\u00a73(?<overflow>[\\d,]+)\u02ac) *");
    private static final class_310 client = class_310.method_1551();
    private static Resource health = new Resource(100, 100, 0);
    private static Resource mana = new Resource(100, 100, 0);
    private static Resource speed = new Resource(100, 400, 0);
    private static Resource air = new Resource(100, 300, 0);
    private static int defense = 0;

    @Init
    public static void init() {
        ClientReceiveMessageEvents.ALLOW_GAME.register(StatusBarTracker::allowOverlayMessage);
        ClientReceiveMessageEvents.MODIFY_GAME.register(StatusBarTracker::onOverlayMessage);
        Scheduler.INSTANCE.scheduleCyclic(StatusBarTracker::tick, 1);
    }

    public static Resource getHealth() {
        return health;
    }

    public static Resource getMana() {
        return mana;
    }

    public static int getDefense() {
        return defense;
    }

    public static Resource getSpeed() {
        return speed;
    }

    public static Resource getAir() {
        return air;
    }

    private static void tick() {
        if (client == null || StatusBarTracker.client.field_1724 == null) {
            return;
        }
        StatusBarTracker.updateHealth(StatusBarTracker.health.value, StatusBarTracker.health.max, StatusBarTracker.health.overflow);
        StatusBarTracker.updateSpeed();
        StatusBarTracker.updateAir();
    }

    private static boolean allowOverlayMessage(class_2561 text, boolean overlay) {
        StatusBarTracker.onOverlayMessage(text, overlay);
        return true;
    }

    private static class_2561 onOverlayMessage(class_2561 text, boolean overlay) {
        if (!overlay || !Utils.isOnSkyblock() || Utils.isInTheRift()) {
            return text;
        }
        if (!SkyblockerConfigManager.get().uiAndVisuals.bars.enableBars) {
            StatusBarTracker.update(text.getString(), SkyblockerConfigManager.get().chat.hideMana);
            return text;
        }
        return class_2561.method_30163((String)StatusBarTracker.update(text.getString(), SkyblockerConfigManager.get().chat.hideMana));
    }

    public static String update(String actionBar, boolean filterManaUse) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = STATUS_HEALTH.matcher(actionBar);
        if (!matcher.find()) {
            return actionBar;
        }
        StatusBarTracker.updateHealth(matcher);
        if (matcher.group("healing") != null) {
            sb.append("\u00a7c\u2764");
        }
        if (!FancyStatusBars.isHealthFancyBarEnabled()) {
            matcher.appendReplacement(sb, "$0");
        } else {
            matcher.appendReplacement(sb, "$3");
        }
        if (matcher.usePattern(DEFENSE_STATUS).find()) {
            defense = RegexUtils.parseIntFromMatcher(matcher, "defense");
            if (FancyStatusBars.isBarEnabled(StatusBarType.DEFENSE)) {
                matcher.appendReplacement(sb, "");
            } else {
                matcher.appendReplacement(sb, "$0");
            }
        } else if (filterManaUse && matcher.usePattern(MANA_USE).find()) {
            matcher.appendReplacement(sb, "");
        }
        if (matcher.usePattern(MANA_STATUS).find()) {
            StatusBarTracker.updateMana(matcher);
            if (FancyStatusBars.isBarEnabled(StatusBarType.INTELLIGENCE)) {
                matcher.appendReplacement(sb, "");
            } else {
                matcher.appendReplacement(sb, "$0");
            }
        }
        matcher.appendTail(sb);
        String res = sb.toString().trim();
        return res.isEmpty() ? null : res;
    }

    private static void updateHealth(Matcher matcher) {
        int health = RegexUtils.parseIntFromMatcher(matcher, "health");
        int max = RegexUtils.parseIntFromMatcher(matcher, "max");
        StatusBarTracker.updateHealth(health, max, Math.max(0, health - max));
    }

    private static void updateHealth(int value, int max, int overflow) {
        if (client != null && StatusBarTracker.client.field_1724 != null) {
            value = (int)(StatusBarTracker.client.field_1724.method_6032() * (float)max / StatusBarTracker.client.field_1724.method_6063());
            overflow = (int)(StatusBarTracker.client.field_1724.method_6067() * (float)max / StatusBarTracker.client.field_1724.method_6063());
        }
        health = new Resource(Math.min(value, max), max, Math.min(overflow, max));
    }

    private static void updateMana(Matcher m) {
        int mana = RegexUtils.parseIntFromMatcher(m, "mana");
        int max = RegexUtils.parseIntFromMatcher(m, "max");
        int overflow = m.group("overflow") == null ? 0 : RegexUtils.parseIntFromMatcher(m, "overflow");
        StatusBarTracker.mana = new Resource(mana, max, overflow);
    }

    private static void updateSpeed() {
        PetInfo pet;
        assert (StatusBarTracker.client.field_1724 != null);
        int value = (int)(StatusBarTracker.client.field_1724.method_5624() ? StatusBarTracker.client.field_1724.method_6029() / 1.3f * 1000.0f : StatusBarTracker.client.field_1724.method_6029() * 1000.0f);
        int max = 400;
        if (StatusBarTracker.client.field_1724.method_6047().method_7964().getString().contains("Cactus Knife") && Utils.getLocation() == Location.GARDEN) {
            max = 500;
        }
        List<class_1799> armor = ItemUtils.getArmor((class_1309)StatusBarTracker.client.field_1724);
        int youngDragCount = 0;
        for (class_1799 armorPiece : armor) {
            if (armorPiece.method_7964().getString().contains("Racing Helmet")) {
                max = 500;
                continue;
            }
            if (!armorPiece.method_7964().getString().contains("Young Dragon")) continue;
            ++youngDragCount;
        }
        if (youngDragCount == 4) {
            max = 500;
        }
        if ((pet = PetCache.getCurrentPet()) != null) {
            if (pet.type().contains("BLACK_CAT")) {
                max = 500;
            } else if (pet.type().contains("SNAIL")) {
                max = 100;
            }
        }
        speed = new Resource(value, max, 0);
    }

    private static void updateAir() {
        assert (StatusBarTracker.client.field_1724 != null);
        int max = StatusBarTracker.client.field_1724.method_5748();
        int value = Math.clamp((long)StatusBarTracker.client.field_1724.method_5669(), 0, max);
        air = new Resource(value, max, 0);
    }

    public record Resource(int value, int max, int overflow) {
    }
}

