/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.render.RenderHelper;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.awt.Color;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthBars {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthBars.class);
    private static final class_2960 HEALTH_BAR_BACKGROUND_TEXTURE = class_2960.method_60656((String)"textures/gui/sprites/boss_bar/white_background.png");
    private static final class_2960 HEALTH_BAR_TEXTURE = class_2960.method_60656((String)"textures/gui/sprites/boss_bar/white_progress.png");
    protected static final Pattern HEALTH_PATTERN = Pattern.compile("(\\d{1,3}(,\\d{3})*(\\.\\d+)?[kKmMbBtT]?)/(\\d{1,3}(,\\d{3})*(\\.\\d+)?[kKmMbBtT]?)\u2764");
    protected static final Pattern HEALTH_ONLY_PATTERN = Pattern.compile("(\\d{1,3}(,\\d{3})*(\\.\\d+)?[kKmMbBtT]?)\u2764");
    private static final Object2FloatOpenHashMap<class_1531> healthValues = new Object2FloatOpenHashMap();
    private static final Object2LongOpenHashMap<class_1531> mobStartingHealth = new Object2LongOpenHashMap();

    @Init
    public static void init() {
        ClientPlayConnectionEvents.JOIN.register((_handler, _sender, _client) -> HealthBars.reset());
        WorldRenderEvents.AFTER_TRANSLUCENT.register(HealthBars::render);
        ClientEntityEvents.ENTITY_UNLOAD.register(HealthBars::onEntityDespawn);
    }

    private static void reset() {
        healthValues.clear();
        mobStartingHealth.clear();
    }

    public static void onEntityDespawn(class_1297 entity, class_638 clientWorld) {
        if (entity instanceof class_1531) {
            class_1531 armorStandEntity = (class_1531)entity;
            healthValues.removeFloat((Object)armorStandEntity);
            mobStartingHealth.removeLong((Object)armorStandEntity);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void healthBar(class_1531 armorStand) {
        if (!(armorStand.method_5767() && armorStand.method_16914() && armorStand.method_5807() && SkyblockerConfigManager.get().uiAndVisuals.healthBars.enabled)) {
            return;
        }
        if (armorStand.method_29504()) {
            healthValues.removeFloat((Object)armorStand);
            mobStartingHealth.removeLong((Object)armorStand);
            return;
        }
        if (armorStand.method_5797() == null) {
            return;
        }
        Matcher healthMatcher = HEALTH_PATTERN.matcher(armorStand.method_5797().getString());
        if (!healthMatcher.find()) {
            HealthBars.healthOnlyCheck(armorStand);
            return;
        }
        float firstValue = Formatters.parseNumber(healthMatcher.group(1).toUpperCase()).floatValue();
        float secondValue = Formatters.parseNumber(healthMatcher.group(4).toUpperCase()).floatValue();
        float health = firstValue / secondValue;
        healthValues.put((Object)armorStand, health);
        boolean removeValue = SkyblockerConfigManager.get().uiAndVisuals.healthBars.removeHealthFromName;
        boolean removeMax = SkyblockerConfigManager.get().uiAndVisuals.healthBars.removeMaxHealthFromName;
        if (!removeValue && !removeMax) {
            return;
        }
        class_5250 cleanedText = class_2561.method_43473();
        List parts = armorStand.method_5797().method_10855();
        int healthStartIndex = -1;
        int i = 0;
        while (true) {
            block16: {
                block15: {
                    if (i >= parts.size()) {
                        armorStand.method_5665((class_2561)cleanedText);
                        return;
                    }
                    if (i < parts.size() - 4 && StringUtils.join((Object[])parts.subList(i + 1, i + 5).stream().map(class_2561::getString).toArray(), (String)"").equals(healthMatcher.group(0))) {
                        healthStartIndex = i;
                    }
                    if (healthStartIndex == -1) break block15;
                    switch (i - healthStartIndex) {
                        case 0: {
                            if (!removeMax || !removeValue) break;
                            break block16;
                        }
                        case 1: {
                            if (!removeValue) break;
                            break block16;
                        }
                        case 2: {
                            if (!removeMax) break;
                            break block16;
                        }
                        case 3: {
                            if (!removeMax) break;
                            break block16;
                        }
                        case 4: {
                            if (removeMax && removeValue) break block16;
                        }
                    }
                }
                cleanedText.method_10852((class_2561)parts.get(i));
            }
            ++i;
        }
    }

    private static void healthOnlyCheck(class_1531 armorStand) {
        if (!SkyblockerConfigManager.get().uiAndVisuals.healthBars.applyToHealthOnlyMobs || armorStand.method_5797() == null) {
            return;
        }
        Matcher healthOnlyMatcher = HEALTH_ONLY_PATTERN.matcher(armorStand.method_5797().getString());
        if (!healthOnlyMatcher.find()) {
            return;
        }
        long currentHealth = Formatters.parseNumber(healthOnlyMatcher.group(1).toUpperCase()).longValue();
        if (!mobStartingHealth.containsKey((Object)armorStand)) {
            mobStartingHealth.put((Object)armorStand, currentHealth);
        }
        float health = (float)currentHealth / (float)mobStartingHealth.getLong((Object)armorStand);
        healthValues.put((Object)armorStand, health);
        if (!SkyblockerConfigManager.get().uiAndVisuals.healthBars.removeHealthFromName) {
            return;
        }
        class_5250 cleanedText = class_2561.method_43473();
        List parts = armorStand.method_5797().method_10855();
        for (int i = 0; i < parts.size(); ++i) {
            if (i < parts.size() - 2 && parts.subList(i + 1, i + 3).stream().map(class_2561::getString).collect(Collectors.joining()).equals(healthOnlyMatcher.group(0))) {
                i += 2;
                continue;
            }
            cleanedText.method_10852((class_2561)parts.get(i));
        }
        armorStand.method_5665((class_2561)cleanedText);
    }

    private static void render(WorldRenderContext context) {
        if (!SkyblockerConfigManager.get().uiAndVisuals.healthBars.enabled || healthValues.isEmpty()) {
            return;
        }
        Color fullColor = SkyblockerConfigManager.get().uiAndVisuals.healthBars.fullBarColor;
        Color halfColor = SkyblockerConfigManager.get().uiAndVisuals.healthBars.halfBarColor;
        Color emptyColor = SkyblockerConfigManager.get().uiAndVisuals.healthBars.emptyBarColor;
        boolean hideFullHealth = SkyblockerConfigManager.get().uiAndVisuals.healthBars.hideFullHealth;
        float scale = SkyblockerConfigManager.get().uiAndVisuals.healthBars.scale;
        float tickDelta = context.tickCounter().method_60637(false);
        float width = scale;
        float height = scale * 0.1f;
        for (Object2FloatMap.Entry healthValue : healthValues.object2FloatEntrySet()) {
            float health = healthValue.getFloatValue();
            if (hideFullHealth && health == 1.0f) continue;
            class_1531 armorStand = (class_1531)healthValue.getKey();
            if (!armorStand.method_5733()) {
                return;
            }
            int mixedColor = ColorUtils.interpolate(health, emptyColor.getRGB(), halfColor.getRGB(), fullColor.getRGB());
            float[] components = ColorUtils.getFloatComponents(mixedColor);
            RenderHelper.renderTextureInWorld(context, armorStand.method_5836(tickDelta).method_1031(0.0, 0.25 - (double)height, 0.0), width, height, 1.0f, 1.0f, new class_243((double)(width * -0.5f), 0.0, 0.0), HEALTH_BAR_BACKGROUND_TEXTURE, components, 1.0f, true);
            RenderHelper.renderTextureInWorld(context, armorStand.method_5836(tickDelta).method_1031(0.0, 0.25 - (double)height, 0.0), width * health, height, health, 1.0f, new class_243((double)(width * -0.5f), 0.0, (double)-0.003f), HEALTH_BAR_TEXTURE, components, 1.0f, true);
        }
    }
}

