/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.mixins;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.SlayersConfig;
import de.hysky.skyblocker.config.configs.UIAndVisualsConfig;
import de.hysky.skyblocker.events.ParticleEvents;
import de.hysky.skyblocker.events.PlaySoundEvents;
import de.hysky.skyblocker.skyblock.CompactDamage;
import de.hysky.skyblocker.skyblock.HealthBars;
import de.hysky.skyblocker.skyblock.SmoothAOTE;
import de.hysky.skyblocker.skyblock.chocolatefactory.EggFinder;
import de.hysky.skyblocker.skyblock.dungeon.DungeonScore;
import de.hysky.skyblocker.skyblock.dungeon.puzzle.TeleportMaze;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.skyblock.dwarven.CorpseFinder;
import de.hysky.skyblocker.skyblock.end.TheEnd;
import de.hysky.skyblocker.skyblock.fishing.FishingHelper;
import de.hysky.skyblocker.skyblock.fishing.FishingHookDisplayHelper;
import de.hysky.skyblocker.skyblock.fishing.SeaCreatureTracker;
import de.hysky.skyblocker.skyblock.galatea.TreeBreakProgressHud;
import de.hysky.skyblocker.skyblock.slayers.SlayerManager;
import de.hysky.skyblocker.skyblock.slayers.boss.demonlord.FirePillarAnnouncer;
import de.hysky.skyblocker.skyblock.tabhud.util.PlayerListManager;
import de.hysky.skyblocker.utils.Utils;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1542;
import net.minecraft.class_2338;
import net.minecraft.class_2535;
import net.minecraft.class_2663;
import net.minecraft.class_2675;
import net.minecraft.class_2708;
import net.minecraft.class_2739;
import net.minecraft.class_2744;
import net.minecraft.class_2767;
import net.minecraft.class_2772;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_8673;
import net.minecraft.class_8675;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_634.class})
public abstract class ClientPlayNetworkHandlerMixin
extends class_8673 {
    @Shadow
    private class_638 field_3699;
    @Shadow
    @Final
    private static Logger field_3695;

    protected ClientPlayNetworkHandlerMixin(class_310 client, class_2535 connection, class_8675 connectionState) {
        super(client, connection, connectionState);
    }

    @Inject(method={"method_11093(Lnet/minecraft/class_2739;)V"}, at={@At(value="TAIL")})
    private void skyblocker$onEntityTrackerUpdate(class_2739 packet, CallbackInfo ci, @Local class_1297 entity) {
        if (!(entity instanceof class_1531)) {
            return;
        }
        class_1531 armorStandEntity = (class_1531)entity;
        SlayerManager.checkSlayerBoss(armorStandEntity);
        if (SkyblockerConfigManager.get().slayers.blazeSlayer.firePillarCountdown != SlayersConfig.BlazeSlayer.FirePillar.OFF) {
            FirePillarAnnouncer.checkFirePillar(entity);
        }
        EggFinder.checkIfEgg(armorStandEntity);
        CorpseFinder.checkIfCorpse(armorStandEntity);
        HealthBars.healthBar(armorStandEntity);
        SeaCreatureTracker.onEntitySpawn(armorStandEntity);
        FishingHelper.checkIfFishWasCaught(armorStandEntity);
        TreeBreakProgressHud.onEntityUpdate(armorStandEntity);
        try {
            CompactDamage.compactDamage(armorStandEntity);
        }
        catch (Exception e) {
            field_3695.error("[Skyblocker Compact Damage] Failed to compact damage number", (Throwable)e);
        }
        FishingHookDisplayHelper.onArmorStandSpawn(armorStandEntity);
    }

    @Inject(method={"method_64896(I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_638;method_2945(ILnet/minecraft/class_1297$class_5529;)V")})
    private void skyblocker$onItemDestroy(int entityId, CallbackInfo ci) {
        class_1297 class_12972 = this.field_3699.method_8469(entityId);
        if (class_12972 instanceof class_1542) {
            class_1542 itemEntity = (class_1542)class_12972;
            DungeonManager.onItemPickup(itemEntity);
        }
    }

    @Inject(method={"method_11157(Lnet/minecraft/class_2708;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_2600;method_11074(Lnet/minecraft/class_2596;Lnet/minecraft/class_2547;Lnet/minecraft/class_1255;)V", shift=At.Shift.AFTER)})
    private void skyblocker$beforeTeleport(class_2708 packet, CallbackInfo ci, @Share(value="playerBeforeTeleportBlockPos") LocalRef<class_2338> beforeTeleport) {
        beforeTeleport.set((Object)this.field_45588.field_1724.method_24515().method_10062());
    }

    @Inject(method={"method_11157(Lnet/minecraft/class_2708;)V"}, at={@At(value="RETURN")})
    private void skyblocker$onTeleport(class_2708 packet, CallbackInfo ci, @Share(value="playerBeforeTeleportBlockPos") LocalRef<class_2338> beforeTeleport) {
        SmoothAOTE.playerTeleported();
        TeleportMaze.INSTANCE.onTeleport(this.field_45588, (class_2338)beforeTeleport.get(), this.field_45588.field_1724.method_24515().method_10062());
    }

    @ModifyVariable(method={"method_11150(Lnet/minecraft/class_2775;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_638;method_2945(ILnet/minecraft/class_1297$class_5529;)V", ordinal=0))
    private class_1542 skyblocker$onItemPickup(class_1542 itemEntity) {
        DungeonManager.onItemPickup(itemEntity);
        return itemEntity;
    }

    @WrapWithCondition(method={"method_11080(Lnet/minecraft/class_2752;)V"}, at={@At(value="INVOKE", target="Lorg/slf4j/Logger;warn(Ljava/lang/String;)V", remap=false)})
    private boolean skyblocker$cancelEntityPassengersWarning(Logger instance, String msg) {
        return !Utils.isOnHypixel();
    }

    @ModifyExpressionValue(method={"method_11148(Lnet/minecraft/class_2663;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_2663;method_11469(Lnet/minecraft/class_1937;)Lnet/minecraft/class_1297;")})
    private class_1297 skyblocker$onEntityDeath(class_1297 entity, @Local(argsOnly=true) class_2663 packet) {
        if (packet.method_11470() == 3) {
            DungeonScore.handleEntityDeath(entity);
            TheEnd.onEntityDeath(entity);
        }
        return entity;
    }

    @Inject(method={"method_11151(Lnet/minecraft/class_2744;)V"}, at={@At(value="TAIL")})
    private void skyblocker$onEntityEquip(class_2744 packet, CallbackInfo ci, @Local class_1297 entity) {
        EggFinder.checkIfEgg(entity);
        CorpseFinder.checkIfCorpse(entity);
    }

    @Inject(method={"method_11105(Lnet/minecraft/class_2772;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_355;method_1924(Lnet/minecraft/class_2561;)V")})
    private void skyblocker$updatePlayerListFooter(class_2772 packet, CallbackInfo ci) {
        PlayerListManager.updateFooter(packet.comp_2283());
    }

    @WrapWithCondition(method={"method_11113(Lnet/minecraft/class_2703;)V"}, at={@At(value="INVOKE", target="Lorg/slf4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V", remap=false)})
    private boolean skyblocker$cancelPlayerListWarning(Logger instance, String format, Object arg1, Object arg2) {
        return !Utils.isOnHypixel();
    }

    @Inject(method={"method_11146(Lnet/minecraft/class_2767;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_2600;method_11074(Lnet/minecraft/class_2596;Lnet/minecraft/class_2547;Lnet/minecraft/class_1255;)V", shift=At.Shift.AFTER)}, cancellable=true)
    private void skyblocker$onPlaySound(class_2767 packet, CallbackInfo ci) {
        ((PlaySoundEvents.FromServer)PlaySoundEvents.FROM_SERVER.invoker()).onPlaySoundFromServer(packet);
    }

    @WrapWithCondition(method={"method_52801(Lnet/minecraft/class_8710;)V"}, at={@At(value="INVOKE", target="Lorg/slf4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;)V", remap=false)})
    private boolean skyblocker$dropBadlionPacketWarnings(Logger instance, String message, Object identifier) {
        return !Utils.isOnHypixel() || !((class_2960)identifier).method_12836().equals("badlion");
    }

    @WrapWithCondition(method={"method_11118(Lnet/minecraft/class_2757;)V", "method_55450(Lnet/minecraft/class_9006;)V"}, at={@At(value="INVOKE", target="Lorg/slf4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;)V", remap=false)}, require=2)
    private boolean skyblocker$cancelUnknownScoreboardObjectiveWarnings(Logger instance, String message, Object objectiveName) {
        return !Utils.isOnHypixel();
    }

    @WrapWithCondition(method={"method_11099(Lnet/minecraft/class_5900;)V"}, at={@At(value="INVOKE", target="Lorg/slf4j/Logger;warn(Ljava/lang/String;[Ljava/lang/Object;)V", remap=false)})
    private boolean skyblocker$cancelTeamWarning(Logger instance, String format, Object ... arg) {
        return !Utils.isOnHypixel();
    }

    @Inject(method={"method_11077(Lnet/minecraft/class_2675;)V"}, at={@At(value="RETURN")})
    private void skyblocker$onParticle(class_2675 packet, CallbackInfo ci) {
        ((ParticleEvents.FromServer)ParticleEvents.FROM_SERVER.invoker()).onParticleFromServer(packet);
    }

    @ModifyExpressionValue(method={"method_18784()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_340;method_53538()Z")})
    private boolean shouldShowPacketSizeAndPingCharts(boolean original) {
        UIAndVisualsConfig.SmoothAOTE options = SkyblockerConfigManager.get().uiAndVisuals.smoothAOTE;
        if (Utils.isOnSkyblock() && !SmoothAOTE.teleportDisabled && (options.enableWeirdTransmission || options.enableEtherTransmission || options.enableInstantTransmission || options.enableSinrecallTransmission || options.enableWitherImpact)) {
            return true;
        }
        return original;
    }
}

