/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.compatibility.rei.recipe;

import de.hysky.skyblocker.compatibility.rei.recipe.SkyblockRecipeDisplay;
import de.hysky.skyblocker.skyblock.itemlist.recipes.SkyblockRecipe;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8029;
import org.joml.Matrix3x2fStack;

public class SkyblockRecipeCategory
implements DisplayCategory<SkyblockRecipeDisplay> {
    private final class_2960 identifier;
    private final class_2561 title;
    private final class_1799 icon;
    private final int height;

    public SkyblockRecipeCategory(class_2960 identifier, class_2561 title, class_1799 icon, int height) {
        this.identifier = identifier;
        this.title = title;
        this.icon = icon;
        this.height = height;
    }

    public CategoryIdentifier<? extends SkyblockRecipeDisplay> getCategoryIdentifier() {
        return CategoryIdentifier.of((class_2960)this.identifier);
    }

    public int getDisplayHeight() {
        return this.height;
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public Renderer getIcon() {
        return EntryStacks.of((class_1799)this.icon);
    }

    public List<Widget> setupDisplay(SkyblockRecipeDisplay display, Rectangle bounds) {
        ArrayList<Widget> out = new ArrayList<Widget>();
        out.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        SkyblockRecipe recipe = display.getRecipe();
        for (SkyblockRecipe.RecipeSlot inputSlot : recipe.getInputSlots(bounds.getWidth(), bounds.getHeight())) {
            out.add((Widget)Widgets.createSlot((Point)new Point(inputSlot.x() + bounds.getX(), inputSlot.y() + bounds.getY())).markInput().backgroundEnabled(inputSlot.showBackground()).entry(EntryStacks.of((class_1799)inputSlot.stack())));
        }
        for (SkyblockRecipe.RecipeSlot outputSlot : recipe.getOutputSlots(bounds.getWidth(), bounds.getHeight())) {
            out.add((Widget)Widgets.createSlot((Point)new Point(outputSlot.x() + bounds.getX(), outputSlot.y() + bounds.getY())).markOutput().backgroundEnabled(outputSlot.showBackground()).entry(EntryStacks.of((class_1799)outputSlot.stack())));
        }
        out.add(Widgets.createDrawableWidget((context, mouseX, mouseY, delta) -> {
            Matrix3x2fStack matrices = context.method_51448();
            matrices.pushMatrix();
            matrices.translate((float)bounds.getX(), (float)bounds.getY());
            recipe.render(context, bounds.getWidth(), bounds.getHeight(), mouseX - bounds.getX(), mouseY - bounds.getY());
            matrices.popMatrix();
        }));
        class_8029 arrowLocation = recipe.getArrowLocation(bounds.getWidth(), bounds.getHeight());
        if (arrowLocation != null) {
            out.add((Widget)Widgets.createArrow((Point)new Point(arrowLocation.comp_1193() + bounds.getX(), arrowLocation.comp_1194() + bounds.getY())));
        }
        out.add((Widget)Widgets.createLabel((Point)new Point(bounds.getCenterX(), bounds.getCenterY() + 24), (class_2561)recipe.getExtraText()));
        return out;
    }
}

