/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.compatibility.rei;

import de.hysky.skyblocker.compatibility.rei.info.SkyblockInfoCategory;
import de.hysky.skyblocker.skyblock.itemlist.recipes.SkyblockCraftingRecipe;
import de.hysky.skyblocker.utils.NEURepoManager;
import de.hysky.skyblocker.utils.scheduler.MessageScheduler;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import io.github.moulberry.repo.data.NEUCraftingRecipe;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_476;

public class SkyblockTransferHandler
implements TransferHandler {
    private static final int MAX_FAIL_COUNT = 5;
    private String FAILED_ITEM;
    private int FAIL_COUNT;

    public TransferHandler.ApplicabilityResult checkApplicable(TransferHandler.Context context) {
        CategoryIdentifier identifier = context.getDisplay().getCategoryIdentifier();
        if (identifier != CategoryIdentifier.of((class_2960)SkyblockCraftingRecipe.IDENTIFIER) && identifier != CategoryIdentifier.of((class_2960)SkyblockInfoCategory.IDENTIFIER)) {
            return TransferHandler.ApplicabilityResult.createNotApplicable();
        }
        EntryIngredient ingredient = (EntryIngredient)context.getDisplay().getOutputEntries().getFirst();
        EntryStack entryStack = (EntryStack)ingredient.getFirst();
        Object object = entryStack.getValue();
        if (!(object instanceof class_1799)) {
            return TransferHandler.ApplicabilityResult.createNotApplicable();
        }
        class_1799 itemStack = (class_1799)object;
        String neuId = itemStack.getNeuName();
        if (!NEURepoManager.getRecipes().containsKey(neuId) || NEURepoManager.getRecipes().get(neuId).stream().noneMatch(recipe -> recipe instanceof NEUCraftingRecipe)) {
            return TransferHandler.ApplicabilityResult.createApplicableWithError((class_2561)class_2561.method_43471((String)"skyblocker.rei.transfer.noRecipe"));
        }
        return TransferHandler.ApplicabilityResult.createApplicable();
    }

    private boolean hasFailed(String skyblockId) {
        if (skyblockId.equals(this.FAILED_ITEM)) {
            if (this.FAIL_COUNT < 5) {
                ++this.FAIL_COUNT;
                return true;
            }
            this.FAILED_ITEM = "";
            this.FAIL_COUNT = 0;
        }
        return false;
    }

    private void checkScreen(String skyblockId) {
        class_437 currentScreen = class_310.method_1551().field_1755;
        if (!(currentScreen instanceof class_476)) {
            this.FAIL_COUNT = 0;
            this.FAILED_ITEM = skyblockId;
        }
    }

    public TransferHandler.Result handle(TransferHandler.Context context) {
        EntryIngredient ingredient = (EntryIngredient)context.getDisplay().getOutputEntries().getFirst();
        EntryStack entryStack = (EntryStack)ingredient.getFirst();
        Object object = entryStack.getValue();
        if (!(object instanceof class_1799)) {
            return TransferHandler.Result.createNotApplicable();
        }
        class_1799 itemStack = (class_1799)object;
        String skyblockId = itemStack.getSkyblockId();
        if (this.hasFailed(skyblockId)) {
            return TransferHandler.Result.createFailed((class_2561)class_2561.method_43471((String)"skyblocker.rei.transfer.failed"));
        }
        if (!context.isActuallyCrafting()) {
            return TransferHandler.Result.createSuccessful();
        }
        MessageScheduler.INSTANCE.sendMessageAfterCooldown("/viewrecipe " + skyblockId, false);
        Scheduler.INSTANCE.schedule(() -> this.checkScreen(skyblockId), 5);
        return TransferHandler.Result.createSuccessful();
    }
}

