/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lat/hannibal2/skyhanni/utils/StringFileHandler;", "", "Ljava/io/File;", "file", "<init>", "(Ljava/io/File;)V", "", "load", "()Ljava/lang/String;", "content", "", "attempt", "", "save", "(Ljava/lang/String;I)V", "Ljava/io/File;", "backupFile", "tempFile", "1.21.7"})
public final class StringFileHandler {
    @NotNull
    private final File file;
    @NotNull
    private final File backupFile;
    @NotNull
    private final File tempFile;

    public StringFileHandler(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.backupFile = new File(this.file.getParentFile(), this.file.getName() + ".bak");
        this.tempFile = new File(this.file.getParentFile(), this.file.getName() + ".tmp");
    }

    @NotNull
    public final String load() throws IOException {
        String string;
        try {
            string = FilesKt.readText$default((File)this.file, null, (int)1, null);
        }
        catch (Exception e) {
            if (!this.backupFile.exists()) {
                throw e;
            }
            string = FilesKt.readText$default((File)this.backupFile, null, (int)1, null);
        }
        return string;
    }

    public final void save(@NotNull String content, int attempt) throws IOException {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        try {
            FilesKt.writeText$default((File)this.tempFile, (String)content, null, (int)2, null);
            if (this.file.exists()) {
                FilesKt.copyTo$default((File)this.file, (File)this.backupFile, (boolean)true, (int)0, (int)4, null);
            }
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING};
            Files.move(this.tempFile.toPath(), this.file.toPath(), copyOptionArray);
            this.backupFile.delete();
        }
        catch (AccessDeniedException e) {
            if (attempt >= 5) {
                throw e;
            }
            Thread.sleep(50L);
            this.save(content, attempt + 1);
        }
        catch (Exception e) {
            this.tempFile.delete();
            if (this.backupFile.exists()) {
                FilesKt.copyTo$default((File)this.backupFile, (File)this.file, (boolean)true, (int)0, (int)4, null);
            }
            throw e;
        }
    }

    public static /* synthetic */ void save$default(StringFileHandler stringFileHandler, String string, int n, int n2, Object object) throws IOException {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        stringFileHandler.save(string, n);
    }
}

