/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.data.jsonobjects.repo.ParkourShortCut;
import at.hannibal2.skyhanni.deps.moulconfig.ChromaColour;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import at.hannibal2.skyhanni.utils.compat.MinecraftCompat;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_238;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b&\u0018\u00002\u00020\u0001B[\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\b\b\u0002\u0010\u000f\u001a\u00020\n\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\n\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\r\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0013\u0010\u001c\u001a\u00020\r*\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001bJ9\u0010 \u001a\u00020\r*\u00020\u00182$\u0010\u001f\u001a \u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001e0\u001d0\u0002H\u0002\u00a2\u0006\u0004\b \u0010!J\u0013\u0010\"\u001a\u00020\u0003*\u00020\u0003H\u0002\u00a2\u0006\u0004\b\"\u0010#J)\u0010$\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001e\u0018\u00010\u001dH\u0002\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010(\u001a\u00020'2\u0006\u0010&\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b(\u0010)J\u0017\u0010-\u001a\u00020,2\u0006\u0010+\u001a\u00020*H\u0002\u00a2\u0006\u0004\b-\u0010.R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010/R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010/R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u00100\u001a\u0004\b1\u00102R\u0017\u0010\t\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\t\u00100\u001a\u0004\b3\u00102R\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u00104\u001a\u0004\b5\u0010\u0013R\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u00106\u001a\u0004\b7\u00108R\u0017\u0010\u000f\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u00104\u001a\u0004\b9\u0010\u0013R\u0016\u0010:\u001a\u00020*8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b:\u0010;R\u0016\u0010<\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b<\u00104R\"\u0010=\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b=\u00104\u001a\u0004\b>\u0010\u0013\"\u0004\b?\u0010@R\"\u0010A\u001a\u00020,8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bA\u0010B\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\"\u0010G\u001a\u00020*8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bG\u0010;\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\"\u0010L\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bL\u00104\u001a\u0004\bM\u0010\u0013\"\u0004\bN\u0010@R\"\u0010O\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bO\u00104\u001a\u0004\bP\u0010\u0013\"\u0004\bQ\u0010@\u00a8\u0006R"}, d2={"Lat/hannibal2/skyhanni/utils/ParkourHelper;", "", "", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "locations", "Lat/hannibal2/skyhanni/data/jsonobjects/repo/ParkourShortCut;", "shortCuts", "", "platformSize", "detectionRange", "", "depth", "Lkotlin/Function0;", "", "onEndReach", "goInOrder", "<init>", "(Ljava/util/List;Ljava/util/List;DDZLkotlin/jvm/functions/Function0;Z)V", "inParkour", "()Z", "getStartLocation", "()Lat/hannibal2/skyhanni/utils/LorenzVec;", "reset", "()V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "event", "render", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "renderShortCuts", "Lkotlin/Pair;", "Lkotlin/collections/IndexedValue;", "inProgressVec", "renderSteps", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;Ljava/util/List;)V", "offsetCenter", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Lat/hannibal2/skyhanni/utils/LorenzVec;", "getInProgressPair", "()Lkotlin/Pair;", "loc", "Lnet/minecraft/class_238;", "axisAlignedBB", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Lnet/minecraft/class_238;", "", "index", "Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "colorForIndex", "(I)Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "Ljava/util/List;", "D", "getPlatformSize", "()D", "getDetectionRange", "Z", "getDepth", "Lkotlin/jvm/functions/Function0;", "getOnEndReach", "()Lkotlin/jvm/functions/Function0;", "getGoInOrder", "current", "I", "visible", "rainbowColor", "getRainbowColor", "setRainbowColor", "(Z)V", "monochromeColor", "Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "getMonochromeColor", "()Lio/github/notenoughupdates/moulconfig/ChromaColour;", "setMonochromeColor", "(Lio/github/notenoughupdates/moulconfig/ChromaColour;)V", "lookAhead", "getLookAhead", "()I", "setLookAhead", "(I)V", "outline", "getOutline", "setOutline", "showEverything", "getShowEverything", "setShowEverything", "1.21.7"})
@SourceDebugExtension(value={"SMAP\nParkourHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParkourHelper.kt\nat/hannibal2/skyhanni/utils/ParkourHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1563#2:173\n1634#2,3:174\n*S KotlinDebug\n*F\n+ 1 ParkourHelper.kt\nat/hannibal2/skyhanni/utils/ParkourHelper\n*L\n130#1:173\n130#1:174,3\n*E\n"})
public final class ParkourHelper {
    @NotNull
    private final List<LorenzVec> locations;
    @NotNull
    private final List<ParkourShortCut> shortCuts;
    private final double platformSize;
    private final double detectionRange;
    private final boolean depth;
    @NotNull
    private final Function0<Unit> onEndReach;
    private final boolean goInOrder;
    private int current;
    private boolean visible;
    private boolean rainbowColor;
    @NotNull
    private ChromaColour monochromeColor;
    private int lookAhead;
    private boolean outline;
    private boolean showEverything;

    public ParkourHelper(@NotNull List<LorenzVec> locations, @NotNull List<ParkourShortCut> shortCuts, double platformSize, double detectionRange, boolean depth, @NotNull Function0<Unit> onEndReach, boolean goInOrder) {
        Intrinsics.checkNotNullParameter(locations, (String)"locations");
        Intrinsics.checkNotNullParameter(shortCuts, (String)"shortCuts");
        Intrinsics.checkNotNullParameter(onEndReach, (String)"onEndReach");
        this.locations = locations;
        this.shortCuts = shortCuts;
        this.platformSize = platformSize;
        this.detectionRange = detectionRange;
        this.depth = depth;
        this.onEndReach = onEndReach;
        this.goInOrder = goInOrder;
        this.current = -1;
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"WHITE");
        this.monochromeColor = ColorUtils.toChromaColor$default(color, 0, 0, 3, null);
        this.lookAhead = 2;
    }

    public /* synthetic */ ParkourHelper(List list, List list2, double d, double d2, boolean bl, Function0 function0, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d = 1.0;
        }
        if ((n & 8) != 0) {
            d2 = 1.0;
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            function0 = ParkourHelper::_init_$lambda$0;
        }
        if ((n & 0x40) != 0) {
            bl2 = false;
        }
        this(list, list2, d, d2, bl, (Function0<Unit>)function0, bl2);
    }

    public final double getPlatformSize() {
        return this.platformSize;
    }

    public final double getDetectionRange() {
        return this.detectionRange;
    }

    public final boolean getDepth() {
        return this.depth;
    }

    @NotNull
    public final Function0<Unit> getOnEndReach() {
        return this.onEndReach;
    }

    public final boolean getGoInOrder() {
        return this.goInOrder;
    }

    public final boolean getRainbowColor() {
        return this.rainbowColor;
    }

    public final void setRainbowColor(boolean bl) {
        this.rainbowColor = bl;
    }

    @NotNull
    public final ChromaColour getMonochromeColor() {
        return this.monochromeColor;
    }

    public final void setMonochromeColor(@NotNull ChromaColour chromaColour) {
        Intrinsics.checkNotNullParameter((Object)chromaColour, (String)"<set-?>");
        this.monochromeColor = chromaColour;
    }

    public final int getLookAhead() {
        return this.lookAhead;
    }

    public final void setLookAhead(int n) {
        this.lookAhead = n;
    }

    public final boolean getOutline() {
        return this.outline;
    }

    public final void setOutline(boolean bl) {
        this.outline = bl;
    }

    public final boolean getShowEverything() {
        return this.showEverything;
    }

    public final void setShowEverything(boolean bl) {
        this.showEverything = bl;
    }

    public final boolean inParkour() {
        return this.current != -1;
    }

    @NotNull
    public final LorenzVec getStartLocation() {
        return (LorenzVec)CollectionsKt.first(this.locations);
    }

    public final void reset() {
        this.current = -1;
        this.visible = false;
    }

    public final void render(@NotNull SkyHanniRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.locations.isEmpty()) {
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, new IllegalArgumentException("locations is empty"), "Trying to render an empty parkour", new Pair[0], false, false, false, 56, null);
            return;
        }
        try {
            if (!this.showEverything) {
                double distanceToPlayer;
                if (this.current == this.locations.size() - 1) {
                    this.visible = false;
                }
                if (this.visible) {
                    Iterator iterator2 = ((Iterable)this.locations).iterator();
                    int n = 0;
                    while (iterator2.hasNext()) {
                        int index = n++;
                        LorenzVec location = (LorenzVec)iterator2.next();
                        boolean onGround = MinecraftCompat.INSTANCE.getLocalPlayer().method_24828();
                        boolean closeEnough = LocationUtils.INSTANCE.distanceToPlayer(this.offsetCenter(location)) < this.detectionRange;
                        if (!closeEnough || !onGround || this.goInOrder && (index < this.current - 1 || index > this.current + 1)) continue;
                        this.current = index;
                    }
                }
                if ((distanceToPlayer = LocationUtils.INSTANCE.distanceToPlayer(this.offsetCenter((LorenzVec)CollectionsKt.first(this.locations)))) < this.detectionRange) {
                    this.visible = true;
                } else if (distanceToPlayer > 15.0 && this.current < 1) {
                    this.visible = false;
                }
                if (!this.visible) {
                    return;
                }
                if (this.current < 0) {
                    return;
                }
            } else {
                this.current = 0;
                this.lookAhead = this.locations.size();
            }
            List<Pair<IndexedValue<LorenzVec>, IndexedValue<LorenzVec>>> inProgressVec = CollectionUtils.INSTANCE.toSingletonListOrEmpty(this.getInProgressPair());
            if (this.locations.size() == this.current + 1) {
                this.onEndReach.invoke();
            }
            for (Pair pair : SequencesKt.plus((Sequence)SequencesKt.take((Sequence)SequencesKt.drop((Sequence)SequencesKt.zipWithNext((Sequence)SequencesKt.withIndex((Sequence)CollectionsKt.asSequence((Iterable)this.locations))), (int)this.current), (int)(this.lookAhead - 1)), (Iterable)inProgressVec)) {
                IndexedValue prev = (IndexedValue)pair.component1();
                IndexedValue next = (IndexedValue)pair.component2();
                WorldRenderUtils.INSTANCE.draw3DLine(event, this.offsetCenter((LorenzVec)prev.getValue()), this.offsetCenter((LorenzVec)next.getValue()), this.colorForIndex(prev.getIndex()), 5, false);
            }
            this.renderShortCuts(event);
            this.renderSteps(event, inProgressVec);
        }
        catch (Throwable e) {
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Error while rendering a parkour", new Pair[0], false, false, false, 56, null);
        }
    }

    private final void renderShortCuts(SkyHanniRenderWorldEvent $this$renderShortCuts) {
        IntRange nextShortcuts = RangesKt.until((int)this.current, (int)(this.current + this.lookAhead));
        for (ParkourShortCut shortCut : this.shortCuts) {
            int n = nextShortcuts.getFirst();
            int n2 = nextShortcuts.getLast();
            int n3 = shortCut.getFrom();
            boolean bl = n <= n3 ? n3 <= n2 : false;
            if (!bl) continue;
            n = ((Collection)this.locations).size();
            n2 = shortCut.getTo();
            boolean bl2 = 0 <= n2 ? n2 < n : false;
            if (!bl2) continue;
            LorenzVec from = this.offsetCenter(this.locations.get(shortCut.getFrom()));
            LorenzVec to = this.offsetCenter(this.locations.get(shortCut.getTo()));
            Color color = Color.RED;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"RED");
            WorldRenderUtils.INSTANCE.draw3DLine($this$renderShortCuts, from, to, color, 3, false);
            LorenzVec textLocation = from.plus(to.minus(from).normalize());
            WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, $this$renderShortCuts, textLocation.add(-0.5, 1.0, -0.5), "\u00a7cShortcut", 1.8, 0.0f, 0.0, 0.0, false, false, null, 504, null);
            class_238 aabb = this.axisAlignedBB(this.locations.get(shortCut.getTo()));
            Color color2 = Color.RED;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"RED");
            WorldRenderUtils.drawFilledBoundingBox$default(WorldRenderUtils.INSTANCE, $this$renderShortCuts, aabb, ColorUtils.toChromaColor$default(color2, 0, 0, 3, null), 1.0f, false, false, false, 56, null);
            if (!this.outline) continue;
            Color color3 = Color.BLACK;
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"BLACK");
            WorldRenderUtils.INSTANCE.outlineTopFace($this$renderShortCuts, aabb, 2, color3, this.depth);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderSteps(SkyHanniRenderWorldEvent $this$renderSteps, List<Pair<IndexedValue<LorenzVec>, IndexedValue<LorenzVec>>> inProgressVec) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable2 = inProgressVec;
        Sequence sequence2 = SequencesKt.take((Sequence)SequencesKt.drop((Sequence)SequencesKt.withIndex((Sequence)CollectionsKt.asSequence((Iterable)this.locations)), (int)this.current), (int)this.lookAhead);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((IndexedValue)it.getSecond());
        }
        for (Iterable iterable2 : SequencesKt.plus((Sequence)sequence2, (Iterable)((List)destination$iv$iv))) {
            boolean isMovingPlatform;
            int index = iterable2.component1();
            LorenzVec location = (LorenzVec)iterable2.component2();
            boolean bl = isMovingPlatform = !this.locations.contains(location);
            if (isMovingPlatform && this.showEverything) continue;
            if (isMovingPlatform) {
                aabb = WorldRenderUtils.expandBlock$default(WorldRenderUtils.INSTANCE, this.axisAlignedBB(location), 0, 1, null);
                WorldRenderUtils.drawFilledBoundingBox$default(WorldRenderUtils.INSTANCE, $this$renderSteps, aabb, this.colorForIndex(index), 0.6f, false, false, false, 56, null);
            } else {
                aabb = this.axisAlignedBB(location);
                WorldRenderUtils.drawFilledBoundingBox$default(WorldRenderUtils.INSTANCE, $this$renderSteps, aabb, this.colorForIndex(index), 1.0f, false, false, false, 56, null);
                if (this.outline) {
                    Color color = Color.BLACK;
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"BLACK");
                    WorldRenderUtils.INSTANCE.outlineTopFace($this$renderSteps, aabb, 2, color, this.depth);
                }
            }
            if (!SkyHanniMod.feature.getDev().getWaypoint().getShowPlatformNumber() || isMovingPlatform) continue;
            WorldRenderUtils.drawString$default(WorldRenderUtils.INSTANCE, $this$renderSteps, this.offsetCenter(location).up(1), "\u00a7a\u00a7l" + index, true, null, 0.0, false, 0.0f, 0, 248, null);
        }
    }

    private final LorenzVec offsetCenter(LorenzVec $this$offsetCenter) {
        return $this$offsetCenter.add(this.platformSize / (double)2, 1.0, this.platformSize / (double)2);
    }

    private final Pair<IndexedValue<LorenzVec>, IndexedValue<LorenzVec>> getInProgressPair() {
        if (this.current < 0 || this.current + this.lookAhead >= this.locations.size()) {
            return null;
        }
        LorenzVec currentPosition = this.offsetCenter(this.locations.get(this.current));
        LorenzVec nextPosition = this.offsetCenter(this.locations.get(this.current + 1));
        LorenzVec lookAheadStart = this.locations.get(this.current + this.lookAhead - 1);
        LorenzVec lookAheadEnd = this.locations.get(this.current + this.lookAhead);
        if (LocationUtils.INSTANCE.playerLocation().distance(nextPosition) > currentPosition.distance(nextPosition)) {
            return null;
        }
        double factor = LocationUtils.INSTANCE.playerLocation().distance(currentPosition) / currentPosition.distance(nextPosition);
        LorenzVec slopeLocation = lookAheadStart.slope(lookAheadEnd, factor);
        return new Pair((Object)new IndexedValue(this.current + this.lookAhead - 1, (Object)lookAheadStart), (Object)new IndexedValue(this.current + this.lookAhead, (Object)slopeLocation));
    }

    private final class_238 axisAlignedBB(LorenzVec loc) {
        return WorldRenderUtils.expandBlock$default(WorldRenderUtils.INSTANCE, loc.boundingToOffset(this.platformSize, 1.0, this.platformSize), 0, 1, null);
    }

    private final ChromaColour colorForIndex(int index) {
        return this.rainbowColor ? ColorUtils.toChromaColor$default(RenderUtils.chromaColor-gRj5Bb8$default(RenderUtils.INSTANCE, DurationKt.toDuration((int)4, (DurationUnit)DurationUnit.SECONDS), (float)(-index) / 12.0f, 0.0f, 0.7f, 0L, 20, null), 0, 0, 3, null) : this.monochromeColor;
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }
}

