/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\u0018\u0000 .2\u00020\u0001:\u0001.B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0007H\u0086\u0002\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0086\u0002\u00a2\u0006\u0004\b\t\u0010\u000eJ \u0010\u0011\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0003H\u0086\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J(\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\rH\u0086\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0013J\r\u0010\u0014\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0015J\r\u0010\u0017\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0015J\u0018\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0018\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\rH\u0086\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001bJ\u0018\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001aJ\u0018\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001aJ\u000f\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u001a\u0010\"\u001a\u00020!2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010$\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b$\u0010%R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010&R\u0017\u0010'\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010%R\u0017\u0010*\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b*\u0010(\u001a\u0004\b+\u0010%R\u0014\u0010,\u001a\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006/"}, d2={"Lat/hannibal2/skyhanni/utils/Matrix;", "", "", "", "data", "<init>", "([[D)V", "", "index", "get", "(I)[D", "row", "col", "", "(II)D", "value", "", "set", "(I[D)V", "(IID)V", "copy", "()Lat/hannibal2/skyhanni/utils/Matrix;", "inverse", "transpose", "other", "times", "(Lat/hannibal2/skyhanni/utils/Matrix;)Lat/hannibal2/skyhanni/utils/Matrix;", "(D)Lat/hannibal2/skyhanni/utils/Matrix;", "plus", "minus", "", "toString", "()Ljava/lang/String;", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "[[D", "width", "I", "getWidth", "height", "getHeight", "isSquare", "()Z", "Companion", "1.21.7"})
@SourceDebugExtension(value={"SMAP\nMatrix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matrix.kt\nat/hannibal2/skyhanni/utils/Matrix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Matrix.kt\nat/hannibal2/skyhanni/utils/Matrix$Companion\n*L\n1#1,138:1\n1#2:139\n12434#3,2:140\n1999#4,14:142\n128#5:156\n128#5:157\n128#5:158\n128#5:159\n128#5:160\n*S KotlinDebug\n*F\n+ 1 Matrix.kt\nat/hannibal2/skyhanni/utils/Matrix\n*L\n12#1:140,2\n37#1:142,14\n63#1:156\n69#1:157\n76#1:158\n82#1:159\n91#1:160\n*E\n"})
public final class Matrix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final double[][] data;
    private final int width;
    private final int height;

    public Matrix(@NotNull double[][] data) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
            this.width = ((double[])ArraysKt.first((Object[])((Object[])this.data))).length;
            this.height = ((Object[])this.data).length;
            if (!(!(((Object[])this.data).length == 0))) {
                boolean $i$a$-require-Matrix$22 = false;
                String $i$a$-require-Matrix$22 = "Matrix can't be empty";
                throw new IllegalArgumentException($i$a$-require-Matrix$22.toString());
            }
            Object[] $this$all$iv = (Object[])this.data;
            boolean $i$f$all = false;
            for (Object element$iv : $this$all$iv) {
                double[] it = (double[])element$iv;
                boolean bl2 = false;
                if (it.length == this.width) continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "All rows must have the same length";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    private final boolean isSquare() {
        return this.width == this.height;
    }

    @NotNull
    public final double[] get(int index) {
        return this.data[index];
    }

    public final double get(int row, int col) {
        return this.data[row][col];
    }

    public final void set(int index, @NotNull double[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(value.length == this.width)) {
            boolean bl = false;
            String string = "Invalid row size";
            throw new IllegalArgumentException(string.toString());
        }
        this.data[index] = value;
    }

    public final void set(int row, int col, double value) {
        this.data[row][col] = value;
    }

    @NotNull
    public final Matrix copy() {
        return new Matrix(Matrix.Companion.deepCopy(this.data));
    }

    @NotNull
    public final Matrix inverse() {
        if (!this.isSquare()) {
            boolean $i$a$-require-Matrix$inverse$22 = false;
            String $i$a$-require-Matrix$inverse$22 = "Matrix must be square";
            throw new IllegalArgumentException($i$a$-require-Matrix$inverse$22.toString());
        }
        double[][] a = Matrix.Companion.deepCopy(this.data);
        double[][] b = Matrix.Companion.identity((int)this.width).data;
        int n = this.width;
        for (int c = 0; c < n; ++c) {
            int n2;
            Integer rBig;
            Object v0;
            Iterable $this$maxByOrNull$iv = (Iterable)RangesKt.until((int)c, (int)this.height);
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv22 = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv22.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv22.next();
                if (!iterator$iv22.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    int it = ((Number)maxElem$iv).intValue();
                    boolean bl = false;
                    double maxValue$iv = Math.abs(a[it][c]);
                    do {
                        Object e$iv = iterator$iv22.next();
                        int it2 = ((Number)e$iv).intValue();
                        $i$a$-maxByOrNull-Matrix$inverse$rBig$1 = false;
                        double v$iv = Math.abs(a[it2][c]);
                        if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv22.hasNext());
                    v0 = maxElem$iv;
                }
            }
            if ((rBig = (Integer)v0) == null) {
                boolean $i$a$-requireNotNull-Matrix$inverse$32 = false;
                String $i$a$-requireNotNull-Matrix$inverse$32 = "Cannot invert matrix";
                throw new IllegalArgumentException($i$a$-requireNotNull-Matrix$inverse$32.toString());
            }
            double aBig = Math.abs(a[rBig][c]);
            if (!(!(aBig == 0.0))) {
                boolean bl = false;
                String string = "Cannot invert matrix";
                throw new IllegalArgumentException(string.toString());
            }
            int iterator$iv22 = c;
            if (rBig != iterator$iv22) {
                Matrix.Companion.swapRows(a, c, rBig);
                Matrix.Companion.swapRows(b, c, rBig);
            }
            double pivot = a[c][c];
            int s = c;
            int n3 = this.width;
            while (s < n3) {
                double[] v$iv = a[c];
                n2 = s++;
                v$iv[n2] = v$iv[n2] / pivot;
            }
            s = 0;
            n3 = this.width;
            while (s < n3) {
                double[] v$iv = b[c];
                n2 = s++;
                v$iv[n2] = v$iv[n2] / pivot;
            }
            n3 = this.height;
            for (int r2 = 0; r2 < n3; ++r2) {
                int n4;
                double[] dArray;
                int s2;
                if (r2 == c) continue;
                double factor = -a[r2][c];
                int n5 = this.width;
                for (s2 = c; s2 < n5; ++s2) {
                    dArray = a[r2];
                    n4 = s2;
                    dArray[n4] = dArray[n4] + factor * a[c][s2];
                }
                n5 = this.width;
                for (s2 = 0; s2 < n5; ++s2) {
                    dArray = b[r2];
                    n4 = s2;
                    dArray[n4] = dArray[n4] + factor * b[c][s2];
                }
            }
        }
        return new Matrix(b);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Matrix transpose() {
        int height$iv;
        Companion companion = Companion;
        int n = this.width;
        int width$iv = this.height;
        boolean $i$f$createArray = false;
        double[][] dArrayArray = new double[height$iv][];
        for (int j = 0; j < height$iv; ++j) {
            int n2 = j;
            int n3 = 0;
            double[] dArray = new double[width$iv];
            int n4 = n2;
            double[][] dArrayArray2 = dArrayArray;
            while (n3 < width$iv) {
                void row;
                void col;
                double d;
                int n5;
                int n6 = n5 = n3++;
                int n7 = n2;
                int n8 = n5;
                double[] dArray2 = dArray;
                boolean bl = false;
                dArray2[n8] = d = this.data[col][row];
            }
            dArrayArray2[n4] = dArray;
        }
        double[][] transposed = dArrayArray;
        return new Matrix(transposed);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Matrix times(@NotNull Matrix other) {
        int height$iv;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(this.width == other.height)) {
            boolean $i$a$-require-Matrix$times$22 = false;
            String $i$a$-require-Matrix$times$22 = "Invalid Matrix sizes";
            throw new IllegalArgumentException($i$a$-require-Matrix$times$22.toString());
        }
        Companion $i$a$-require-Matrix$times$22 = Companion;
        int n = this.height;
        int width$iv = other.width;
        boolean $i$f$createArray = false;
        double[][] dArrayArray = new double[height$iv][];
        for (int j = 0; j < height$iv; ++j) {
            int n2 = j;
            double[] dArray = new double[width$iv];
            int n3 = n2;
            double[][] dArrayArray2 = dArrayArray;
            for (int k = 0; k < width$iv; ++k) {
                double d;
                int n4;
                int n5 = n4 = k;
                int n6 = n2;
                int n7 = n4;
                double[] dArray2 = dArray;
                boolean bl = false;
                Iterable iterable = (Iterable)RangesKt.until((int)0, (int)this.width);
                double d2 = 0.0;
                Iterator iterator2 = iterable.iterator();
                while (iterator2.hasNext()) {
                    void col;
                    void k2;
                    void row;
                    int n8;
                    int n9 = n8 = ((IntIterator)iterator2).nextInt();
                    double d3 = d2;
                    boolean bl2 = false;
                    double d4 = this.get((int)row)[k2] * other.get((int)k2)[col];
                    d2 = d3 + d4;
                }
                dArray2[n7] = d = d2;
            }
            dArrayArray2[n3] = dArray;
        }
        double[][] result2 = dArrayArray;
        return new Matrix(result2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Matrix times(double other) {
        int height$iv;
        Companion companion = Companion;
        int n = this.height;
        int width$iv = this.width;
        boolean $i$f$createArray = false;
        double[][] dArrayArray = new double[height$iv][];
        for (int j = 0; j < height$iv; ++j) {
            int n2 = j;
            int n3 = 0;
            double[] dArray = new double[width$iv];
            int n4 = n2;
            double[][] dArrayArray2 = dArrayArray;
            while (n3 < width$iv) {
                void col;
                void row;
                double d;
                int n5;
                int n6 = n5 = n3++;
                int n7 = n2;
                int n8 = n5;
                double[] dArray2 = dArray;
                boolean bl = false;
                dArray2[n8] = d = this.data[row][col] * other;
            }
            dArrayArray2[n4] = dArray;
        }
        double[][] result2 = dArrayArray;
        return new Matrix(result2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Matrix plus(@NotNull Matrix other) {
        int height$iv;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(this.width == other.width && this.height == other.height)) {
            boolean $i$a$-require-Matrix$plus$22 = false;
            String $i$a$-require-Matrix$plus$22 = "Invalid Dimensions";
            throw new IllegalArgumentException($i$a$-require-Matrix$plus$22.toString());
        }
        Companion $i$a$-require-Matrix$plus$22 = Companion;
        int n = this.height;
        int width$iv = this.width;
        boolean $i$f$createArray = false;
        double[][] dArrayArray = new double[height$iv][];
        for (int j = 0; j < height$iv; ++j) {
            int n2 = j;
            int n3 = 0;
            double[] dArray = new double[width$iv];
            int n4 = n2;
            double[][] dArrayArray2 = dArrayArray;
            while (n3 < width$iv) {
                void col;
                void row;
                double d;
                int n5;
                int n6 = n5 = n3++;
                int n7 = n2;
                int n8 = n5;
                double[] dArray2 = dArray;
                boolean bl = false;
                dArray2[n8] = d = this.data[row][col] + other.get((int)row)[col];
            }
            dArrayArray2[n4] = dArray;
        }
        double[][] result2 = dArrayArray;
        return new Matrix(result2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Matrix minus(@NotNull Matrix other) {
        int height$iv;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(this.width == other.width && this.height == other.height)) {
            boolean $i$a$-require-Matrix$minus$22 = false;
            String $i$a$-require-Matrix$minus$22 = "Invalid Dimensions";
            throw new IllegalArgumentException($i$a$-require-Matrix$minus$22.toString());
        }
        Companion $i$a$-require-Matrix$minus$22 = Companion;
        int n = this.height;
        int width$iv = this.width;
        boolean $i$f$createArray = false;
        double[][] dArrayArray = new double[height$iv][];
        for (int j = 0; j < height$iv; ++j) {
            int n2 = j;
            int n3 = 0;
            double[] dArray = new double[width$iv];
            int n4 = n2;
            double[][] dArrayArray2 = dArrayArray;
            while (n3 < width$iv) {
                void col;
                void row;
                double d;
                int n5;
                int n6 = n5 = n3++;
                int n7 = n2;
                int n8 = n5;
                double[] dArray2 = dArray;
                boolean bl = false;
                dArray2[n8] = d = this.data[row][col] - other.get((int)row)[col];
            }
            dArrayArray2[n4] = dArray;
        }
        double[][] result2 = dArrayArray;
        return new Matrix(result2);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u2417 = stringBuilder = new StringBuilder();
        boolean bl = false;
        double[][] dArray = this.data;
        int n = ((Object[])dArray).length;
        for (int j = 0; j < n; ++j) {
            for (double cell : dArray[j]) {
                $this$toString_u24lambda_u2417.append(" " + cell);
            }
            $this$toString_u24lambda_u2417.append('\n');
        }
        return stringBuilder.toString();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Matrix)) {
            return false;
        }
        if (this.height != ((Matrix)other).height || this.width != ((Matrix)other).width) {
            return false;
        }
        return ArraysKt.contentDeepEquals((Object[])((Object[])this.data), (Object[])((Object[])((Matrix)other).data));
    }

    public int hashCode() {
        return ArraysKt.contentDeepHashCode((Object[])((Object[])this.data));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ^\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000426\u0010\u0015\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\u000fH\u0082\b\u00a2\u0006\u0004\b\u0016\u0010\u0017J)\u0010\u001b\u001a\u00020\u001a*\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lat/hannibal2/skyhanni/utils/Matrix$Companion;", "", "<init>", "()V", "", "size", "Lat/hannibal2/skyhanni/utils/Matrix;", "identity", "(I)Lat/hannibal2/skyhanni/utils/Matrix;", "", "", "deepCopy", "([[D)[[D", "height", "width", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "row", "column", "", "function", "createArray", "(IILkotlin/jvm/functions/Function2;)[[D", "i", "j", "", "swapRows", "([[DII)V", "1.21.7"})
    @SourceDebugExtension(value={"SMAP\nMatrix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matrix.kt\nat/hannibal2/skyhanni/utils/Matrix$Companion\n*L\n1#1,138:1\n128#1:139\n128#1:140\n*S KotlinDebug\n*F\n+ 1 Matrix.kt\nat/hannibal2/skyhanni/utils/Matrix$Companion\n*L\n117#1:139\n121#1:140\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Matrix identity(int size) {
            Companion this_$iv = this;
            boolean $i$f$createArray = false;
            double[][] dArrayArray = new double[size][];
            for (int j = 0; j < size; ++j) {
                int n = j;
                double[] dArray = new double[size];
                int n2 = n;
                double[][] dArrayArray2 = dArrayArray;
                for (int k = 0; k < size; ++k) {
                    void col;
                    void row;
                    double d;
                    int n3;
                    int n4 = n3 = k;
                    int n5 = n;
                    int n6 = n3;
                    double[] dArray2 = dArray;
                    boolean bl = false;
                    dArray2[n6] = d = row == col ? 1.0 : 0.0;
                }
                dArrayArray2[n2] = dArray;
            }
            double[][] result2 = dArrayArray;
            return new Matrix(result2);
        }

        /*
         * WARNING - void declaration
         */
        private final double[][] deepCopy(double[][] $this$deepCopy) {
            int height$iv;
            Companion companion = this;
            int n = ((Object[])$this$deepCopy).length;
            int width$iv = ((double[])ArraysKt.first((Object[])((Object[])$this$deepCopy))).length;
            boolean $i$f$createArray = false;
            double[][] dArrayArray = new double[height$iv][];
            for (int j = 0; j < height$iv; ++j) {
                int n2 = j;
                int n3 = 0;
                double[] dArray = new double[width$iv];
                int n4 = n2;
                double[][] dArrayArray2 = dArrayArray;
                while (n3 < width$iv) {
                    void col;
                    void row;
                    double d;
                    int n5;
                    int n6 = n5 = n3++;
                    int n7 = n2;
                    int n8 = n5;
                    double[] dArray2 = dArray;
                    boolean bl = false;
                    dArray2[n8] = d = $this$deepCopy[row][col];
                }
                dArrayArray2[n4] = dArray;
            }
            return dArrayArray;
        }

        private final double[][] createArray(int height, int width, Function2<? super Integer, ? super Integer, Double> function) {
            boolean $i$f$createArray = false;
            double[][] dArrayArray = new double[height][];
            for (int j = 0; j < height; ++j) {
                int n = j;
                int n2 = 0;
                double[] dArray = new double[width];
                int n3 = n;
                double[][] dArrayArray2 = dArrayArray;
                while (n2 < width) {
                    int n4 = n2++;
                    dArray[n4] = ((Number)function.invoke((Object)n, (Object)n4)).doubleValue();
                }
                dArrayArray2[n3] = dArray;
            }
            return dArrayArray;
        }

        private final void swapRows(double[][] $this$swapRows, int i2, int j) {
            double[] temp = $this$swapRows[i2];
            $this$swapRows[i2] = $this$swapRows[j];
            $this$swapRows[j] = temp;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

