/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.farming;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.garden.cropmilestones.CropMilestonesConfig;
import at.hannibal2.skyhanni.config.features.garden.cropmilestones.CropMilestonesOverflowConfig;
import at.hannibal2.skyhanni.config.features.garden.cropmilestones.MushroomPetPerkConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.GardenCropMilestones;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.data.title.TitleContext;
import at.hannibal2.skyhanni.data.title.TitleManager;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.OwnInventoryItemUpdateEvent;
import at.hannibal2.skyhanni.events.ProfileJoinEvent;
import at.hannibal2.skyhanni.events.garden.farming.CropMilestoneUpdateEvent;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.FarmingFortuneDisplay;
import at.hannibal2.skyhanni.features.garden.GardenApi;
import at.hannibal2.skyhanni.features.garden.farming.FarmingWeightDisplay;
import at.hannibal2.skyhanni.features.garden.farming.GardenBestCropTime;
import at.hannibal2.skyhanni.features.garden.farming.GardenCropSpeed;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.TimeUnit;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.collection.RenderableCollectionUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.renderables.container.HorizontalContainerRenderable;
import at.hannibal2.skyhanni.utils.renderables.primitives.StringRenderable;
import at.hannibal2.skyhanni.utils.renderables.primitives.TextRenderableKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0015\u0010\u0003J\u001d\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ'\u0010\"\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b \u0010!J)\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00190#H\u0002\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010(\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b(\u0010\u0003J\u000f\u0010*\u001a\u00020)H\u0002\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010-\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020,H\u0007\u00a2\u0006\u0004\b-\u0010.R\u001c\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100R\u001c\u00101\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u00100R \u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u0002020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0014\u00108\u001a\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0014\u0010<\u001a\u0002098BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\"\u0010@\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020=\u0018\u00010#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0018\u0010B\u001a\u0004\u0018\u00010A8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u0016\u0010D\u001a\u00020=8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bD\u0010ER\u0016\u0010F\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bF\u0010GR\u0016\u0010H\u001a\u00020=8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bH\u0010ER\u0016\u0010I\u001a\u00020=8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bI\u0010ER\u0016\u0010J\u001a\u00020=8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bJ\u0010ER\u0016\u0010K\u001a\u00020=8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bK\u0010E\u00a8\u0006L"}, d2={"Lat/hannibal2/skyhanni/features/garden/farming/GardenCropMilestoneDisplay;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/ConfigLoadEvent;", "event", "", "onConfigLoad", "(Lat/hannibal2/skyhanni/events/ConfigLoadEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/events/ProfileJoinEvent;", "onProfileJoin", "(Lat/hannibal2/skyhanni/events/ProfileJoinEvent;)V", "Lat/hannibal2/skyhanni/events/garden/farming/CropMilestoneUpdateEvent;", "onCropMilestoneUpdate", "(Lat/hannibal2/skyhanni/events/garden/farming/CropMilestoneUpdateEvent;)V", "Lat/hannibal2/skyhanni/events/OwnInventoryItemUpdateEvent;", "onOwnInventoryItemUpdate", "(Lat/hannibal2/skyhanni/events/OwnInventoryItemUpdateEvent;)V", "update", "Lat/hannibal2/skyhanni/features/garden/CropType;", "crop", "", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "drawProgressDisplay", "(Lat/hannibal2/skyhanni/features/garden/CropType;)Ljava/util/List;", "Lkotlin/time/Duration;", "timeLeft", "", "title", "tryWarn-KLykuaI", "(JLjava/lang/String;Lat/hannibal2/skyhanni/features/garden/CropType;)V", "tryWarn", "", "Lat/hannibal2/skyhanni/config/features/garden/cropmilestones/CropMilestonesConfig$MilestoneTextEntry;", "lineMap", "formatDisplay", "(Ljava/util/Map;)Ljava/util/List;", "addMushroomCowData", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "progressDisplay", "Ljava/util/List;", "mushroomCowPerkDisplay", "", "cultivatingData", "Ljava/util/Map;", "Lat/hannibal2/skyhanni/config/features/garden/cropmilestones/CropMilestonesConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/cropmilestones/CropMilestonesConfig;", "config", "Lat/hannibal2/skyhanni/config/features/garden/cropmilestones/CropMilestonesOverflowConfig;", "getOverflowConfig", "()Lat/hannibal2/skyhanni/config/features/garden/cropmilestones/CropMilestonesOverflowConfig;", "overflowConfig", "", "getStorage", "()Ljava/util/Map;", "storage", "Lat/hannibal2/skyhanni/data/title/TitleContext;", "countdownTitleContext", "Lat/hannibal2/skyhanni/data/title/TitleContext;", "lastTitleWarnedLevel", "I", "needsInventory", "Z", "lastWarnedLevel", "previousNext", "lastMushWarnedLevel", "previousMushNext", "1.21.7"})
@SourceDebugExtension(value={"SMAP\nGardenCropMilestoneDisplay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GardenCropMilestoneDisplay.kt\nat/hannibal2/skyhanni/features/garden/farming/GardenCropMilestoneDisplay\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,360:1\n1#2:361\n1#2:372\n1#2:385\n1617#3,9:362\n1869#3:371\n1870#3:373\n1626#3:374\n1617#3,9:375\n1869#3:384\n1870#3:386\n1626#3:387\n*S KotlinDebug\n*F\n+ 1 GardenCropMilestoneDisplay.kt\nat/hannibal2/skyhanni/features/garden/farming/GardenCropMilestoneDisplay\n*L\n274#1:372\n338#1:385\n274#1:362,9\n274#1:371\n274#1:373\n274#1:374\n338#1:375,9\n338#1:384\n338#1:386\n338#1:387\n*E\n"})
public final class GardenCropMilestoneDisplay {
    @NotNull
    public static final GardenCropMilestoneDisplay INSTANCE = new GardenCropMilestoneDisplay();
    @NotNull
    private static List<? extends Renderable> progressDisplay = CollectionsKt.emptyList();
    @NotNull
    private static List<? extends Renderable> mushroomCowPerkDisplay = CollectionsKt.emptyList();
    @NotNull
    private static final Map<CropType, Long> cultivatingData = new LinkedHashMap();
    @Nullable
    private static TitleContext countdownTitleContext;
    private static int lastTitleWarnedLevel;
    private static boolean needsInventory;
    private static int lastWarnedLevel;
    private static int previousNext;
    private static int lastMushWarnedLevel;
    private static int previousMushNext;

    private GardenCropMilestoneDisplay() {
    }

    private final CropMilestonesConfig getConfig() {
        return GardenApi.INSTANCE.getConfig().getCropMilestones();
    }

    private final CropMilestonesOverflowConfig getOverflowConfig() {
        return this.getConfig().getOverflow();
    }

    private final Map<CropType, Integer> getStorage() {
        Object object = ProfileStorageData.INSTANCE.getProfileSpecific();
        return object != null && (object = ((ProfileSpecificStorage)object).getGarden()) != null ? ((ProfileSpecificStorage.GardenStorage)object).getCustomGoalMilestone() : null;
    }

    @HandleEvent
    public final void onConfigLoad(@NotNull ConfigLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Property[] propertyArray = new Property[]{this.getConfig().getBestShowMaxedNeeded(), this.getConfig().getHighestTimeFormat()};
        ConditionalUtils.INSTANCE.onToggle(propertyArray, GardenCropMilestoneDisplay::onConfigLoad$lambda$0);
    }

    @HandleEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (GardenApi.INSTANCE.hideExtraGuis()) {
            return;
        }
        RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, this.getConfig().getProgressDisplayPos(), progressDisplay, 0, "Crop Milestone Progress", false, 10, null);
        if (this.getConfig().getMushroomPetPerk().getEnabled()) {
            RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, this.getConfig().getMushroomPetPerk().getPos(), mushroomCowPerkDisplay, 0, "Mushroom Cow Perk", false, 10, null);
        }
        if (this.getConfig().getNext().getBestDisplay()) {
            RenderUtils.renderRenderable$default(RenderUtils.INSTANCE, this.getConfig().getNext().getDisplayPos(), GardenBestCropTime.INSTANCE.getDisplay(), "Best Crop Time", false, 4, null);
        }
    }

    @HandleEvent(priority=1)
    public final void onProfileJoin(@NotNull ProfileJoinEvent event) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Map<CropType, Long> map = GardenCropMilestones.INSTANCE.getCropCounter();
            if (map == null) break block1;
            Map<CropType, Long> it = map;
            boolean bl = false;
            if (CollectionsKt.sumOfLong((Iterable)it.values()) == 0L) {
                needsInventory = true;
            }
        }
    }

    @HandleEvent
    public final void onCropMilestoneUpdate(@NotNull CropMilestoneUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        needsInventory = false;
        GardenBestCropTime.INSTANCE.updateTimeTillNextCrop();
        this.update();
    }

    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onOwnInventoryItemUpdate(@NotNull OwnInventoryItemUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        try {
            class_1799 item2 = event.getItemStack();
            Long l = GardenApi.INSTANCE.readCounter(item2);
            if (l == null) {
                return;
            }
            long counter = l;
            CropType cropType = GardenApi.INSTANCE.getCropType(item2);
            if (cropType == null) {
                return;
            }
            CropType crop = cropType;
            if (cultivatingData.containsKey((Object)crop)) {
                Long l2 = cultivatingData.get((Object)crop);
                Intrinsics.checkNotNull((Object)l2);
                long old = ((Number)l2).longValue();
                int addedCounter = (int)(counter - old);
                FarmingWeightDisplay.INSTANCE.addCrop(crop, addedCounter);
                this.update();
                GardenCropMilestones.INSTANCE.setCounter(crop, GardenCropMilestones.INSTANCE.getCounter(crop) + (long)addedCounter);
            }
            Long l3 = counter;
            cultivatingData.put(crop, l3);
        }
        catch (Throwable e) {
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Updating crop counter by reading farming tool nbt data.", new Pair[0], false, false, false, 56, null);
        }
    }

    public final void update() {
        CropType currentCrop;
        progressDisplay = CollectionsKt.emptyList();
        mushroomCowPerkDisplay = CollectionsKt.emptyList();
        GardenBestCropTime.INSTANCE.setDisplay(null);
        CropType cropType = currentCrop = GardenApi.INSTANCE.getCurrentlyFarmedCrop();
        if (cropType != null) {
            CropType it = cropType;
            boolean bl = false;
            progressDisplay = INSTANCE.drawProgressDisplay(it);
        }
        if (this.getConfig().getNext().getBestDisplay() && ((Boolean)this.getConfig().getNext().getBestAlwaysOn().get()).booleanValue() || currentCrop != null) {
            GardenBestCropTime.INSTANCE.setDisplay(GardenBestCropTime.INSTANCE.drawBestDisplay(currentCrop));
        }
    }

    private final List<Renderable> drawProgressDisplay(CropType crop) {
        StringRenderable stringRenderable;
        Object haveFormat;
        Pair pair;
        long counter = GardenCropMilestones.INSTANCE.getCounter(crop);
        Map lineMap = new LinkedHashMap();
        lineMap.put(CropMilestonesConfig.MilestoneTextEntry.TITLE, TextRenderableKt.text$default(Renderable.Companion, "\u00a76Crop Milestones", 0.0, null, null, null, 30, null));
        Map<CropType, Integer> map = this.getStorage();
        int customTargetLevel = map != null && (map = map.get((Object)crop)) != null ? (Integer)((Object)map) : 0;
        boolean overflowDisplay = this.getOverflowConfig().getCropMilestoneDisplay();
        boolean allowOverflow = overflowDisplay || customTargetLevel != 0;
        int currentTier = GardenCropMilestones.INSTANCE.getTierForCropCount(counter, crop, allowOverflow);
        Ref.IntRef nextTier = new Ref.IntRef();
        int nextRealTier = nextTier.element = (Boolean)this.getConfig().getBestShowMaxedNeeded().get() != false && currentTier <= 46 ? 46 : currentTier + 1;
        boolean useCustomGoal = customTargetLevel != 0 && customTargetLevel > currentTier;
        nextTier.element = useCustomGoal ? customTargetLevel : nextTier.element;
        lineMap.put(CropMilestonesConfig.MilestoneTextEntry.MILESTONE_TIER, HorizontalContainerRenderable.Companion.horizontal$default(HorizontalContainerRenderable.Companion, Renderable.Companion, 0, null, null, arg_0 -> GardenCropMilestoneDisplay.drawProgressDisplay$lambda$3(crop, overflowDisplay, currentTier, nextTier, arg_0), 7, null));
        boolean allowOverflowOrCustom = overflowDisplay || useCustomGoal;
        long cropsForNextTier = GardenCropMilestones.INSTANCE.getCropsForTier(nextTier.element, crop, allowOverflowOrCustom);
        if (((Boolean)this.getConfig().getBestShowMaxedNeeded().get()).booleanValue() && !overflowDisplay) {
            pair = new Pair((Object)counter, (Object)cropsForNextTier);
        } else {
            long cropsForCurrentTier = GardenCropMilestones.INSTANCE.getCropsForTier(currentTier, crop, allowOverflowOrCustom);
            long have = useCustomGoal ? counter : counter - cropsForCurrentTier;
            long need2 = useCustomGoal ? cropsForNextTier : cropsForNextTier - cropsForCurrentTier;
            pair = new Pair((Object)have, (Object)need2);
        }
        Pair pair2 = pair;
        long have = ((Number)pair2.component1()).longValue();
        long need = ((Number)pair2.component2()).longValue();
        Map need2 = lineMap;
        CropMilestonesConfig.MilestoneTextEntry milestoneTextEntry = CropMilestonesConfig.MilestoneTextEntry.NUMBER_OUT_OF_TOTAL;
        if (GardenCropMilestones.INSTANCE.isMaxed(crop, overflowDisplay) && !overflowDisplay) {
            haveFormat = NumberUtil.INSTANCE.addSeparators(counter);
            stringRenderable = TextRenderableKt.text$default(Renderable.Companion, "\u00a77Counter: \u00a7e" + (String)haveFormat, 0.0, null, null, null, 30, null);
        } else {
            haveFormat = NumberUtil.INSTANCE.addSeparators(have);
            String needFormat = NumberUtil.INSTANCE.addSeparators(need);
            stringRenderable = TextRenderableKt.text$default(Renderable.Companion, "\u00a7e" + (String)haveFormat + "\u00a78/\u00a7e" + needFormat, 0.0, null, null, null, 30, null);
        }
        haveFormat = stringRenderable;
        need2.put(milestoneTextEntry, haveFormat);
        double farmingFortune = FarmingFortuneDisplay.INSTANCE.getCurrentFarmingFortune();
        double speed = GardenCropSpeed.INSTANCE.getAverageBlocksPerSecond();
        int farmingFortuneSpeed = (int)NumberUtil.INSTANCE.roundTo((100.0 + farmingFortune) * crop.getBaseDrops() * speed / (double)100, 1);
        if (farmingFortuneSpeed > 0) {
            GardenCropSpeed.INSTANCE.setSpeed(crop, farmingFortuneSpeed);
            if (!GardenCropMilestones.INSTANCE.isMaxed(crop, overflowDisplay) || overflowDisplay) {
                long missing = need - have;
                long missingTime = DurationKt.toDuration((long)(missing / (long)farmingFortuneSpeed), (DurationUnit)DurationUnit.SECONDS);
                long millis = Duration.getInWholeMilliseconds-impl((long)missingTime);
                Map<CropType, Duration> map2 = GardenBestCropTime.INSTANCE.getTimeTillNextCrop();
                Duration duration = Duration.box-impl((long)DurationKt.toDuration((long)millis, (DurationUnit)DurationUnit.MILLISECONDS));
                map2.put(crop, duration);
                this.tryWarn-KLykuaI(missingTime, "\u00a7b" + crop.getCropName() + " " + nextTier.element + " in %t", crop);
                TimeUnit biggestUnit = ((CropMilestonesConfig.TimeFormatEntry)((Object)this.getConfig().getHighestTimeFormat().get())).getTimeUnit();
                String duration2 = TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, missingTime, biggestUnit, false, false, 0, false, false, 62, null);
                String speedText = "\u00a77In \u00a7b" + duration2;
                lineMap.put(CropMilestonesConfig.MilestoneTextEntry.TIME, TextRenderableKt.text$default(Renderable.Companion, speedText, 0.0, null, null, null, 30, null));
                class_1799 class_17992 = GardenApi.INSTANCE.getItemInHand();
                if (class_17992 != null) {
                    class_1799 it = class_17992;
                    boolean bl = false;
                    if (GardenApi.INSTANCE.readCounter(it) == null) {
                        lineMap.put(CropMilestonesConfig.MilestoneTextEntry.TIME, TextRenderableKt.text$default(Renderable.Companion, speedText + " \u00a77Inaccurate!", 0.0, null, null, null, 30, null));
                    }
                }
            }
            String secondFormat = NumberUtil.INSTANCE.addSeparators(farmingFortuneSpeed);
            lineMap.put(CropMilestonesConfig.MilestoneTextEntry.CROPS_PER_SECOND, TextRenderableKt.text$default(Renderable.Companion, "\u00a77Crops/Second\u00a78: \u00a7e" + secondFormat, 0.0, null, null, null, 30, null));
            String minuteFormat = NumberUtil.INSTANCE.addSeparators(farmingFortuneSpeed * 60);
            lineMap.put(CropMilestonesConfig.MilestoneTextEntry.CROPS_PER_MINUTE, TextRenderableKt.text$default(Renderable.Companion, "\u00a77Crops/Minute\u00a78: \u00a7e" + minuteFormat, 0.0, null, null, null, 30, null));
            String hourFormat = NumberUtil.INSTANCE.addSeparators(farmingFortuneSpeed * 60 * 60);
            lineMap.put(CropMilestonesConfig.MilestoneTextEntry.CROPS_PER_HOUR, TextRenderableKt.text$default(Renderable.Companion, "\u00a77Crops/Hour\u00a78: \u00a7e" + hourFormat, 0.0, null, null, null, 30, null));
            String formatBps = NumberUtil.INSTANCE.addSeparators(NumberUtil.INSTANCE.roundTo(speed, this.getConfig().getBlocksBrokenPrecision()));
            lineMap.put(CropMilestonesConfig.MilestoneTextEntry.BLOCKS_PER_SECOND, TextRenderableKt.text$default(Renderable.Companion, "\u00a77Blocks/Second\u00a78: \u00a7e" + formatBps, 0.0, null, null, null, 30, null));
        }
        String percentageFormat = NumberUtil.INSTANCE.formatPercentage((double)have / (double)need);
        lineMap.put(CropMilestonesConfig.MilestoneTextEntry.PERCENTAGE, GardenCropMilestones.INSTANCE.isMaxed(crop, overflowDisplay) && !overflowDisplay ? TextRenderableKt.text$default(Renderable.Companion, "\u00a77Percentage: \u00a7e100%", 0.0, null, null, null, 30, null) : TextRenderableKt.text$default(Renderable.Companion, "\u00a77Percentage: \u00a7e" + percentageFormat, 0.0, null, null, null, 30, null));
        if (this.getOverflowConfig().getChat() && currentTier > 46 && currentTier == previousNext && nextRealTier == currentTier + 1 && lastWarnedLevel != currentTier) {
            GardenCropMilestones.INSTANCE.onOverflowLevelUp(crop, currentTier - 1, nextRealTier - 1);
            lastWarnedLevel = currentTier;
        }
        if (GardenApi.INSTANCE.getMushroomCowPet() && crop != CropType.MUSHROOM) {
            this.addMushroomCowData();
        }
        previousNext = nextRealTier;
        return this.formatDisplay(lineMap);
    }

    private final void tryWarn-KLykuaI(long timeLeft, String title, CropType crop) {
        boolean isTimeLeftValid;
        boolean isConfigEnabled = this.getConfig().getWarnClose();
        boolean isCropBreakEnabled = Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(GardenCropSpeed.INSTANCE.getLastBrokenTime-uFjCsEo()), (long)DurationKt.toDuration((int)500, (DurationUnit)DurationUnit.MILLISECONDS)) < 0;
        boolean bl = isTimeLeftValid = Duration.compareTo-LRDsOJo((long)timeLeft, (long)DurationKt.toDuration((int)6, (DurationUnit)DurationUnit.SECONDS)) <= 0;
        if (!(isConfigEnabled && isCropBreakEnabled && isTimeLeftValid)) {
            TitleContext titleContext = countdownTitleContext;
            if (titleContext != null) {
                titleContext.stop();
            }
            countdownTitleContext = null;
            return;
        }
        Integer n = GardenCropMilestones.getTier$default(GardenCropMilestones.INSTANCE, crop, false, 1, null);
        int it = ((Number)n).intValue();
        boolean bl2 = false;
        Integer n2 = it != lastTitleWarnedLevel ? n : null;
        if (n2 == null) {
            return;
        }
        lastTitleWarnedLevel = n2;
        if (needsInventory || countdownTitleContext != null) {
            return;
        }
        countdownTitleContext = TitleManager.sendTitle-pX6VMpQ$default(TitleManager.INSTANCE, title, null, timeLeft, null, null, TitleManager.TitleAddType.FORCE_FIRST, 0.0, false, false, TitleManager.CountdownTitleDisplayType.WHOLE_SECONDS, 0L, (Function0)new Function0<Unit>((Object)SoundUtils.INSTANCE){

            public final void invoke() {
                SoundUtils.playBeepSound$default((SoundUtils)this.receiver, 0.0f, 1, null);
            }
        }, null, 0L, 13786, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Renderable> formatDisplay(Map<CropMilestonesConfig.MilestoneTextEntry, Renderable> lineMap) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        List newList = new ArrayList();
        Iterable iterable = this.getConfig().getText();
        List list = newList;
        boolean $i$f$mapNotNull = false;
        void var5_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Renderable it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            CropMilestonesConfig.MilestoneTextEntry it = (CropMilestonesConfig.MilestoneTextEntry)((Object)element$iv$iv);
            boolean bl2 = false;
            if (lineMap.get((Object)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        list.addAll((List)destination$iv$iv);
        if (needsInventory) {
            RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, newList, "\u00a7cOpen \u00a7e/cropmilestones \u00a7cto update!", 0.0, null, null, 14, null);
        }
        return newList;
    }

    /*
     * WARNING - void declaration
     */
    private final void addMushroomCowData() {
        void $this$mapNotNullTo$iv$iv;
        CropType mushroom = CropType.MUSHROOM;
        boolean allowOverflow = this.getOverflowConfig().getCropMilestoneDisplay();
        if (GardenCropMilestones.INSTANCE.isMaxed(mushroom, allowOverflow)) {
            Object[] objectArray = new StringRenderable[]{TextRenderableKt.text$default(Renderable.Companion, "\u00a76Mooshroom Cow Perk", 0.0, null, null, null, 30, null), TextRenderableKt.text$default(Renderable.Companion, "\u00a7eMushroom crop is maxed!", 0.0, null, null, null, 30, null)};
            mushroomCowPerkDisplay = CollectionsKt.listOf((Object[])objectArray);
            return;
        }
        HashMap lineMap = new HashMap();
        long counter = GardenCropMilestones.INSTANCE.getCounter(mushroom);
        int currentTier = GardenCropMilestones.INSTANCE.getTierForCropCount(counter, mushroom, allowOverflow);
        int nextTier = currentTier + 1;
        long cropsForCurrentTier = GardenCropMilestones.INSTANCE.getCropsForTier(currentTier, mushroom, allowOverflow);
        long cropsForNextTier = GardenCropMilestones.INSTANCE.getCropsForTier(nextTier, mushroom, allowOverflow);
        long have = counter - cropsForCurrentTier;
        long need = cropsForNextTier - cropsForCurrentTier;
        String haveFormat = NumberUtil.INSTANCE.addSeparators(have);
        String needFormat = NumberUtil.INSTANCE.addSeparators(need);
        long missing = need - have;
        ((Map)lineMap).put(MushroomPetPerkConfig.MushroomTextEntry.TITLE, TextRenderableKt.text$default(Renderable.Companion, "\u00a76Mooshroom Cow Perk", 0.0, null, null, null, 30, null));
        ((Map)lineMap).put(MushroomPetPerkConfig.MushroomTextEntry.MUSHROOM_TIER, HorizontalContainerRenderable.Companion.horizontal$default(HorizontalContainerRenderable.Companion, Renderable.Companion, 0, null, null, arg_0 -> GardenCropMilestoneDisplay.addMushroomCowData$lambda$7(mushroom, nextTier, arg_0), 7, null));
        ((Map)lineMap).put(MushroomPetPerkConfig.MushroomTextEntry.NUMBER_OUT_OF_TOTAL, TextRenderableKt.text$default(Renderable.Companion, "\u00a7e" + haveFormat + "\u00a78/\u00a7e" + needFormat, 0.0, null, null, null, 30, null));
        double speed = GardenCropSpeed.INSTANCE.getAverageBlocksPerSecond();
        if (!(speed == 0.0)) {
            CropType cropType = GardenApi.INSTANCE.getCurrentlyFarmedCrop();
            double blocksPerSecond = speed * (double)(cropType != null ? cropType.getMultiplier() : 1);
            long missingTime = DurationKt.toDuration((double)((double)missing / blocksPerSecond), (DurationUnit)DurationUnit.SECONDS);
            TimeUnit biggestUnit = ((CropMilestonesConfig.TimeFormatEntry)((Object)this.getConfig().getHighestTimeFormat().get())).getTimeUnit();
            String duration = TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, missingTime, biggestUnit, false, false, 0, false, false, 62, null);
            ((Map)lineMap).put(MushroomPetPerkConfig.MushroomTextEntry.TIME, TextRenderableKt.text$default(Renderable.Companion, "\u00a77In \u00a7b" + duration, 0.0, null, null, null, 30, null));
        }
        String percentageFormat = NumberUtil.INSTANCE.formatPercentage((double)have / (double)need);
        ((Map)lineMap).put(MushroomPetPerkConfig.MushroomTextEntry.PERCENTAGE, TextRenderableKt.text$default(Renderable.Companion, "\u00a77Percentage: \u00a7e" + percentageFormat, 0.0, null, null, null, 30, null));
        if (currentTier > 46 && currentTier == previousMushNext && nextTier == currentTier + 1 && lastMushWarnedLevel != currentTier) {
            GardenCropMilestones.INSTANCE.onOverflowLevelUp(mushroom, currentTier - 1, nextTier - 1);
            lastMushWarnedLevel = currentTier;
        }
        previousMushNext = nextTier;
        Iterable $this$mapNotNull$iv = this.getConfig().getMushroomPetPerk().getText();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Renderable it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            MushroomPetPerkConfig.MushroomTextEntry it = (MushroomPetPerkConfig.MushroomTextEntry)((Object)element$iv$iv);
            boolean bl2 = false;
            if ((Renderable)lineMap.get((Object)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        mushroomCowPerkDisplay = (List)destination$iv$iv;
    }

    private final boolean isEnabled() {
        return GardenApi.INSTANCE.inGarden() && this.getConfig().getProgress();
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneProgress", "garden.cropMilestones.progress", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneWarnClose", "garden.cropMilestones.warnClose", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneHighestTimeFormat", "garden.cropMilestones.highestTimeFormat", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneBestShowMaxedNeeded", "garden.cropMilestones.bestShowMaxedNeeded", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneText", "garden.cropMilestones.text", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.blocksBrokenPrecision", "garden.cropMilestones.blocksBrokenPrecision", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneProgressDisplayPos", "garden.cropMilestones.progressDisplayPos", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneBestDisplay", "garden.cropMilestones.next.bestDisplay", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneBestAlwaysOn", "garden.cropMilestones.next.bestAlwaysOn", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneNextDisplayPos", "garden.cropMilestones.next.displayPos", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneMushroomPetPerkEnabled", "garden.cropMilestones.mushroomPetPerk.enabled", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneMushroomPetPerkText", "garden.cropMilestones.mushroomPetPerk.text", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneMushroomPetPerkPos", "garden.cropMilestones.mushroomPetPerk.pos", null, 8, null);
    }

    private static final void onConfigLoad$lambda$0() {
        GardenBestCropTime.INSTANCE.updateTimeTillNextCrop();
        INSTANCE.update();
    }

    private static final Unit drawProgressDisplay$lambda$3(CropType $crop, boolean $overflowDisplay, int $currentTier, Ref.IntRef $nextTier, List $this$horizontal) {
        Intrinsics.checkNotNullParameter((Object)((Object)$crop), (String)"$crop");
        Intrinsics.checkNotNullParameter((Object)$nextTier, (String)"$nextTier");
        Intrinsics.checkNotNullParameter((Object)$this$horizontal, (String)"$this$horizontal");
        RenderableCollectionUtils.addItemStack$default(RenderableCollectionUtils.INSTANCE, $this$horizontal, $crop.getIcon(), false, 0.0, 6, null);
        if (GardenCropMilestones.INSTANCE.isMaxed($crop, $overflowDisplay) && !$overflowDisplay) {
            RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$horizontal, "\u00a77" + $crop.getCropName() + " \u00a7eMAXED", 0.0, null, null, 14, null);
        } else {
            RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$horizontal, "\u00a77" + $crop.getCropName() + " \u00a78" + $currentTier + "\u279c\u00a73" + $nextTier.element, 0.0, null, null, 14, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit addMushroomCowData$lambda$7(CropType $mushroom, int $nextTier, List $this$horizontal) {
        Intrinsics.checkNotNullParameter((Object)((Object)$mushroom), (String)"$mushroom");
        Intrinsics.checkNotNullParameter((Object)$this$horizontal, (String)"$this$horizontal");
        RenderableCollectionUtils.addItemStack$default(RenderableCollectionUtils.INSTANCE, $this$horizontal, $mushroom.getIcon(), false, 0.0, 6, null);
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$horizontal, "\u00a77Mushroom Milestone " + $nextTier, 0.0, null, null, 14, null);
        return Unit.INSTANCE;
    }

    static {
        lastTitleWarnedLevel = -1;
        lastWarnedLevel = -1;
        lastMushWarnedLevel = -1;
    }
}

