/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.events;

import at.hannibal2.skyhanni.api.event.SkyHanniEvent;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\nJ,\u0010\u000e\u001a\u00020\t2\u001d\u0010\r\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000e\u0010\nJ\u001b\u0010\u000e\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u00a2\u0006\u0004\b\u000e\u0010\u0012J,\u0010\u0013\u001a\u00020\t2\u001d\u0010\r\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0004\b\u0013\u0010\u000fJ\u0015\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0013\u0010\nJ\u001b\u0010\u0013\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u001d\u0010\u0014\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0012R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0015R\u0014\u0010\u0005\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0016R\"\u0010\u0018\u001a\u00020\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u0016R\u0016\u0010\u001f\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u0019\u00a8\u0006 "}, d2={"Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "Lat/hannibal2/skyhanni/api/event/SkyHanniEvent;", "", "", "list", "search", "<init>", "(Ljava/util/List;Ljava/lang/String;)V", "title", "", "(Ljava/lang/String;)V", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "builder", "addIrrelevant", "(Lkotlin/jvm/functions/Function1;)V", "text", "", "(Ljava/util/List;)V", "addData", "writeData", "Ljava/util/List;", "Ljava/lang/String;", "", "empty", "Z", "getEmpty", "()Z", "setEmpty", "(Z)V", "currentTitle", "irrelevant", "1.21.7"})
public final class DebugDataCollectEvent
extends SkyHanniEvent {
    @NotNull
    private final List<String> list;
    @NotNull
    private final String search;
    private boolean empty;
    @NotNull
    private String currentTitle;
    private boolean irrelevant;

    public DebugDataCollectEvent(@NotNull List<String> list, @NotNull String search) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)search, (String)"search");
        this.list = list;
        this.search = search;
        this.empty = true;
        this.currentTitle = "";
    }

    public final boolean getEmpty() {
        return this.empty;
    }

    public final void setEmpty(boolean bl) {
        this.empty = bl;
    }

    public final void title(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        if (!Intrinsics.areEqual((Object)this.currentTitle, (Object)"")) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"current title", (Object)this.currentTitle), TuplesKt.to((Object)"new title", (Object)title)};
            ErrorManager.INSTANCE.skyHanniError("DebugDataCollectEvent duplicate titles and no data in between", pairArray);
            throw new KotlinNothingValueException();
        }
        this.currentTitle = title;
    }

    public final void addIrrelevant(@NotNull Function1<? super List<String>, Unit> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        List list = CollectionsKt.createListBuilder();
        builder.invoke((Object)list);
        this.addIrrelevant(CollectionsKt.build((List)list));
    }

    public final void addIrrelevant(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.addIrrelevant(CollectionsKt.listOf((Object)text));
    }

    public final void addIrrelevant(@NotNull List<String> text) {
        Intrinsics.checkNotNullParameter(text, (String)"text");
        this.irrelevant = true;
        this.addData(text);
    }

    public final void addData(@NotNull Function1<? super List<String>, Unit> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        List list = CollectionsKt.createListBuilder();
        builder.invoke((Object)list);
        this.addData(CollectionsKt.build((List)list));
    }

    public final void addData(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.addData(CollectionsKt.listOf((Object)text));
    }

    public final void addData(@NotNull List<String> text) {
        Intrinsics.checkNotNullParameter(text, (String)"text");
        if (Intrinsics.areEqual((Object)this.currentTitle, (Object)"")) {
            throw new IllegalStateException("Title not set".toString());
        }
        this.writeData(text);
        this.currentTitle = "";
        this.irrelevant = false;
    }

    private final void writeData(List<String> text) {
        if (this.irrelevant && ((CharSequence)this.search).length() == 0) {
            return;
        }
        if (((CharSequence)this.search).length() > 0 && !Intrinsics.areEqual((Object)this.search, (Object)"all") && !StringsKt.contains((CharSequence)this.currentTitle, (CharSequence)this.search, (boolean)true)) {
            return;
        }
        this.empty = false;
        this.list.add("");
        this.list.add("== " + this.currentTitle + " ==");
        for (String line : text) {
            this.list.add(" " + line);
        }
    }
}

