/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.platform;

import at.hannibal2.skyhanni.deps.moulconfig.common.ClickType;
import at.hannibal2.skyhanni.deps.moulconfig.common.DynamicTextureReference;
import at.hannibal2.skyhanni.deps.moulconfig.common.IFontRenderer;
import at.hannibal2.skyhanni.deps.moulconfig.common.IItemStack;
import at.hannibal2.skyhanni.deps.moulconfig.common.IKeyboardConstants;
import at.hannibal2.skyhanni.deps.moulconfig.common.IMinecraft;
import at.hannibal2.skyhanni.deps.moulconfig.common.MyResourceLocation;
import at.hannibal2.skyhanni.deps.moulconfig.common.RenderContext;
import at.hannibal2.skyhanni.deps.moulconfig.common.text.StructuredText;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiContext;
import at.hannibal2.skyhanni.deps.moulconfig.internal.FilterAssertionCache;
import at.hannibal2.skyhanni.deps.moulconfig.internal.MCLogger;
import at.hannibal2.skyhanni.deps.moulconfig.internal.Warnings;
import at.hannibal2.skyhanni.deps.moulconfig.platform.ModernKeybindHelper;
import at.hannibal2.skyhanni.deps.moulconfig.platform.ModernKeyboardConstants;
import at.hannibal2.skyhanni.deps.moulconfig.platform.MoulConfigFontRenderer;
import at.hannibal2.skyhanni.deps.moulconfig.platform.MoulConfigItemStack;
import at.hannibal2.skyhanni.deps.moulconfig.platform.MoulConfigRenderContext;
import at.hannibal2.skyhanni.deps.moulconfig.platform.MoulConfigScreenComponent;
import at.hannibal2.skyhanni.deps.moulconfig.platform.MoulConfigText;
import at.hannibal2.skyhanni.deps.moulconfig.processor.MoulConfigProcessor;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;
import kotlin.Pair;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1041;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1799;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public class MoulConfigPlatform
implements IMinecraft {
    private static final Logger log = LoggerFactory.getLogger(MoulConfigPlatform.class);
    public static @Nullable MoulConfigPlatform instance;
    class_310 mc = class_310.method_1551();

    public MoulConfigPlatform() {
        if (instance != null) {
            Warnings.warn("Constructed duplicate MoulConfig instance");
        }
        instance = this;
    }

    public static class_2960 unwrap(MyResourceLocation resourceLocation) {
        return class_2960.method_60655((String)resourceLocation.getRoot(), (String)resourceLocation.getPath());
    }

    public static MyResourceLocation wrap(class_2960 identifier) {
        return new MyResourceLocation(identifier.method_12836(), identifier.method_12832());
    }

    public static class_1799 unwrap(IItemStack itemStack) {
        return ((MoulConfigItemStack)itemStack).getItemStack();
    }

    public static IItemStack wrap(class_1799 itemStack) {
        return new MoulConfigItemStack(itemStack);
    }

    public static class_2561 unwrap(StructuredText structuredText) {
        return MoulConfigText.unwrap(structuredText);
    }

    public static StructuredText wrap(class_2561 text) {
        return MoulConfigText.wrap(text);
    }

    public static StructuredText.Mutable wrap(class_5250 text) {
        return MoulConfigText.wrap(text);
    }

    public static class_327 unwrap(IFontRenderer fontRenderer) {
        return ((MoulConfigFontRenderer)fontRenderer).getFont();
    }

    public static IFontRenderer wrap(class_327 font) {
        return new MoulConfigFontRenderer(font);
    }

    @Override
    public InputStream loadResourceLocation(MyResourceLocation resourceLocation) {
        return this.mc.method_1478().getResourceOrThrow(MoulConfigPlatform.unwrap(resourceLocation)).method_14482();
    }

    @Override
    public MCLogger getLogger(String label) {
        final org.apache.logging.log4j.Logger logger = LogManager.getLogger((String)label);
        return new MCLogger(){

            @Override
            public void warn(@NotNull String text) {
                logger.warn(text);
            }

            @Override
            public void info(@NotNull String text) {
                logger.info(text);
            }

            @Override
            public void error(@NotNull String text, @NotNull Throwable throwable) {
                logger.error(text, throwable);
            }
        };
    }

    @Override
    public boolean isGeneratedSentinel(MyResourceLocation resourceLocation) {
        return Objects.equals("moulconfig", resourceLocation.getRoot()) && resourceLocation.getPath().startsWith("dynamic/");
    }

    private static void setTextureData(class_1043 texture, BufferedImage image) {
        class_1011 destinationImage = texture.method_4525();
        assert (destinationImage != null);
        for (int i2 = 0; i2 < image.getWidth(); ++i2) {
            for (int j = 0; j < image.getHeight(); ++j) {
                int argb = image.getRGB(i2, j);
                destinationImage.method_61941(i2, j, argb);
            }
        }
    }

    @Override
    public DynamicTextureReference generateDynamicTexture(BufferedImage img) {
        final class_2960 identifier = class_2960.method_60655((String)"moulconfig", (String)("dynamic/" + ThreadLocalRandom.current().nextLong()));
        final class_1043 texture = new class_1043(identifier.method_12832(), img.getWidth(), img.getHeight(), true);
        MoulConfigPlatform.setTextureData(texture, img);
        texture.method_4524();
        this.mc.method_1531().method_4616(identifier, (class_1044)texture);
        return new DynamicTextureReference(){

            @Override
            @NotNull
            public MyResourceLocation getIdentifier() {
                return MoulConfigPlatform.wrap(identifier);
            }

            @Override
            public void update(@NotNull BufferedImage bufferedImage) {
                MoulConfigPlatform.setTextureData(texture, bufferedImage);
                texture.method_4524();
            }

            @Override
            protected void doDestroy() {
                FilterAssertionCache.destroyGlobalFilter(MoulConfigPlatform.wrap(identifier));
                MoulConfigPlatform.this.mc.method_1531().method_4615(identifier);
            }
        };
    }

    @Override
    public Pair<Double, Double> getMousePositionHF() {
        class_312 mouse = this.mc.field_1729;
        class_1041 window = this.mc.method_22683();
        double y = mouse.method_1604() * (double)window.method_4502() / (double)window.method_4507();
        double x = mouse.method_1603() * (double)window.method_4486() / (double)window.method_4480();
        return new Pair((Object)x, (Object)y);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public IFontRenderer getDefaultFontRenderer() {
        return new MoulConfigFontRenderer(this.mc.field_1772);
    }

    @Override
    public IKeyboardConstants getKeyboardConstants() {
        return ModernKeyboardConstants.INSTANCE;
    }

    @Override
    public int getScaledWidth() {
        return this.mc.method_22683().method_4486();
    }

    @Override
    public int getScaledHeight() {
        return this.mc.method_22683().method_4502();
    }

    @Override
    public int getScaleFactor() {
        return this.mc.method_22683().method_4495();
    }

    @Override
    public boolean isOnMacOs() {
        return class_310.field_1703;
    }

    @Override
    public boolean isMouseButtonDown(int mouseButton) {
        return GLFW.glfwGetMouseButton((long)this.mc.method_22683().method_4490(), (int)mouseButton) == 1;
    }

    @Override
    public boolean isKeyboardKeyDown(int keyboardKey) {
        return class_3675.method_15987((long)this.mc.method_22683().method_4490(), (int)keyboardKey);
    }

    @Override
    public void addExtraBuiltinConfigProcessors(MoulConfigProcessor<?> processor) {
    }

    @Override
    public void sendClickableChatMessage(StructuredText message, String action, @Nullable ClickType type2) {
        class_2561 text = MoulConfigText.unwrap(message);
        if (type2 != null) {
            text = text.method_27661().method_27694(it -> it.method_10958((class_2558)(switch (type2) {
                default -> throw new MatchException(null, null);
                case ClickType.OPEN_LINK -> new class_2558.class_10608(URI.create(action));
                case ClickType.RUN_COMMAND -> new class_2558.class_10609(action);
            })));
        }
        class_310.method_1551().field_1705.method_1743().method_1812(text);
    }

    @Override
    public StructuredText getKeyName(int keyCode) {
        return ModernKeybindHelper.INSTANCE.getKeyName(keyCode);
    }

    @Override
    public StructuredText.Mutable createLiteral(String text) {
        return MoulConfigPlatform.wrap(class_2561.method_43470((String)text));
    }

    @Override
    public StructuredText.Mutable createTranslatable(String key, StructuredText ... args) {
        return MoulConfigPlatform.wrap(class_2561.method_43469((String)key, (Object[])Stream.of(args).map(MoulConfigPlatform::unwrap).toArray()));
    }

    @Override
    public @Nullable StructuredText createStructuredTextInternal(Object obj) {
        if (obj instanceof class_2561) {
            class_2561 text = (class_2561)obj;
            return MoulConfigPlatform.wrap(text);
        }
        return null;
    }

    @ApiStatus.Internal
    public static class_332 makeDrawContext() {
        return new class_332(class_310.method_1551(), class_310.method_1551().field_1773.field_59966);
    }

    @Override
    public RenderContext provideTopLevelRenderContext() {
        return new MoulConfigRenderContext(MoulConfigPlatform.makeDrawContext());
    }

    public void openWrappedScreen(class_437 screen) {
        this.mc.method_1507(screen);
    }

    @Override
    public void openWrappedScreen(GuiContext gui) {
        this.openWrappedScreen(new MoulConfigScreenComponent((class_2561)class_2561.method_43473(), gui, null));
    }

    @Override
    public void copyToClipboard(String string) {
        this.mc.field_1774.method_1455(string);
    }

    @Override
    public String copyFromClipboard() {
        return this.mc.field_1774.method_1460();
    }
}

