/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.commons.net.nntp;

import at.hannibal2.skyhanni.deps.commons.net.MalformedServerReplyException;
import at.hannibal2.skyhanni.deps.commons.net.io.DotTerminatedMessageReader;
import at.hannibal2.skyhanni.deps.commons.net.io.DotTerminatedMessageWriter;
import at.hannibal2.skyhanni.deps.commons.net.io.Util;
import at.hannibal2.skyhanni.deps.commons.net.nntp.Article;
import at.hannibal2.skyhanni.deps.commons.net.nntp.ArticleInfo;
import at.hannibal2.skyhanni.deps.commons.net.nntp.ArticleIterator;
import at.hannibal2.skyhanni.deps.commons.net.nntp.ArticlePointer;
import at.hannibal2.skyhanni.deps.commons.net.nntp.NNTP;
import at.hannibal2.skyhanni.deps.commons.net.nntp.NNTPReply;
import at.hannibal2.skyhanni.deps.commons.net.nntp.NewGroupsOrNewsQuery;
import at.hannibal2.skyhanni.deps.commons.net.nntp.NewsgroupInfo;
import at.hannibal2.skyhanni.deps.commons.net.nntp.NewsgroupIterator;
import at.hannibal2.skyhanni.deps.commons.net.nntp.ReplyIterator;
import at.hannibal2.skyhanni.deps.commons.net.util.NetConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Vector;

public class NNTPClient
extends NNTP {
    private static final NewsgroupInfo[] EMPTY_NEWSGROUP_INFO_ARRAY = new NewsgroupInfo[0];

    static Article parseArticleEntry(String line) {
        Article article = new Article();
        article.setSubject(line);
        String[] parts = line.split("\t");
        if (parts.length > 6) {
            int i2 = 0;
            try {
                article.setArticleNumber(Long.parseLong(parts[i2++]));
                article.setSubject(parts[i2++]);
                article.setFrom(parts[i2++]);
                article.setDate(parts[i2++]);
                article.setArticleId(parts[i2++]);
                article.addReference(parts[i2++]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return article;
    }

    private static void parseGroupReply(String reply, NewsgroupInfo info) throws MalformedServerReplyException {
        String[] tokens = reply.split(" ");
        if (tokens.length >= 5) {
            int i2 = 1;
            try {
                info.setArticleCount(Long.parseLong(tokens[i2++]));
                info.setFirstArticle(Long.parseLong(tokens[i2++]));
                info.setLastArticle(Long.parseLong(tokens[i2++]));
                info.setNewsgroup(tokens[i2++]);
                info.setPostingPermission(0);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new MalformedServerReplyException("Could not parse newsgroup info.\nServer reply: " + reply);
    }

    static NewsgroupInfo parseNewsgroupListEntry(String entry) {
        String[] tokens = entry.split(" ");
        if (tokens.length < 4) {
            return null;
        }
        NewsgroupInfo result2 = new NewsgroupInfo();
        int i2 = 0;
        result2.setNewsgroup(tokens[i2++]);
        try {
            long lastNum = Long.parseLong(tokens[i2++]);
            long firstNum = Long.parseLong(tokens[i2++]);
            result2.setFirstArticle(firstNum);
            result2.setLastArticle(lastNum);
            if (firstNum == 0L && lastNum == 0L) {
                result2.setArticleCount(0L);
            } else {
                result2.setArticleCount(lastNum - firstNum + 1L);
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        switch (tokens[i2++].charAt(0)) {
            case 'Y': 
            case 'y': {
                result2.setPostingPermission(2);
                break;
            }
            case 'N': 
            case 'n': {
                result2.setPostingPermission(3);
                break;
            }
            case 'M': 
            case 'm': {
                result2.setPostingPermission(1);
                break;
            }
            default: {
                result2.setPostingPermission(0);
            }
        }
        return result2;
    }

    private void ai2ap(ArticleInfo ai, ArticlePointer ap) {
        if (ap != null) {
            ap.articleId = ai.articleId;
            ap.articleNumber = (int)ai.articleNumber;
        }
    }

    private ArticleInfo ap2ai(ArticlePointer ap) {
        if (ap == null) {
            return null;
        }
        return new ArticleInfo();
    }

    public boolean authenticate(String user, String password) throws IOException {
        int replyCode = this.authinfoUser(user);
        if (replyCode == 381 && (replyCode = this.authinfoPass(password)) == 281) {
            this._isAllowedToPost = true;
            return true;
        }
        return false;
    }

    public boolean completePendingCommand() throws IOException {
        return NNTPReply.isPositiveCompletion(this.getReply());
    }

    public Writer forwardArticle(String articleId) throws IOException {
        if (!NNTPReply.isPositiveIntermediate(this.ihave(articleId))) {
            return null;
        }
        return new DotTerminatedMessageWriter(this._writer_);
    }

    public Iterable<Article> iterateArticleInfo(long lowArticleNumber, long highArticleNumber) throws IOException {
        BufferedReader info = this.retrieveArticleInfo(lowArticleNumber, highArticleNumber);
        if (info == null) {
            throw new IOException("XOVER command failed: " + this.getReplyString());
        }
        return new ArticleIterator(new ReplyIterator(info, false));
    }

    public Iterable<String> iterateNewNews(NewGroupsOrNewsQuery query) throws IOException {
        if (NNTPReply.isPositiveCompletion(this.newnews(query.getNewsgroups(), query.getDate(), query.getTime(), query.isGMT(), query.getDistributions()))) {
            return new ReplyIterator(this._reader_);
        }
        throw new IOException("NEWNEWS command failed: " + this.getReplyString());
    }

    public Iterable<String> iterateNewNewsgroupListing(NewGroupsOrNewsQuery query) throws IOException {
        if (NNTPReply.isPositiveCompletion(this.newgroups(query.getDate(), query.getTime(), query.isGMT(), query.getDistributions()))) {
            return new ReplyIterator(this._reader_);
        }
        throw new IOException("NEWGROUPS command failed: " + this.getReplyString());
    }

    public Iterable<NewsgroupInfo> iterateNewNewsgroups(NewGroupsOrNewsQuery query) throws IOException {
        return new NewsgroupIterator(this.iterateNewNewsgroupListing(query));
    }

    public Iterable<String> iterateNewsgroupListing() throws IOException {
        if (NNTPReply.isPositiveCompletion(this.list())) {
            return new ReplyIterator(this._reader_);
        }
        throw new IOException("LIST command failed: " + this.getReplyString());
    }

    public Iterable<String> iterateNewsgroupListing(String wildmat) throws IOException {
        if (NNTPReply.isPositiveCompletion(this.listActive(wildmat))) {
            return new ReplyIterator(this._reader_);
        }
        throw new IOException("LIST ACTIVE " + wildmat + " command failed: " + this.getReplyString());
    }

    public Iterable<NewsgroupInfo> iterateNewsgroups() throws IOException {
        return new NewsgroupIterator(this.iterateNewsgroupListing());
    }

    public Iterable<NewsgroupInfo> iterateNewsgroups(String wildmat) throws IOException {
        return new NewsgroupIterator(this.iterateNewsgroupListing(wildmat));
    }

    public String listHelp() throws IOException {
        if (!NNTPReply.isInformational(this.help())) {
            return null;
        }
        try (StringWriter help = new StringWriter();){
            String string;
            try (DotTerminatedMessageReader reader = new DotTerminatedMessageReader(this._reader_);){
                Util.copyReader(reader, help);
                string = help.toString();
            }
            return string;
        }
    }

    public String[] listNewNews(NewGroupsOrNewsQuery query) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.newnews(query.getNewsgroups(), query.getDate(), query.getTime(), query.isGMT(), query.getDistributions()))) {
            return null;
        }
        Vector<String> list = new Vector<String>();
        try (DotTerminatedMessageReader reader = new DotTerminatedMessageReader(this._reader_);){
            String line;
            while ((line = ((BufferedReader)reader).readLine()) != null) {
                list.addElement(line);
            }
        }
        int size = list.size();
        if (size < 1) {
            return NetConstants.EMPTY_STRING_ARRAY;
        }
        Object[] result2 = new String[size];
        list.copyInto(result2);
        return result2;
    }

    public NewsgroupInfo[] listNewNewsgroups(NewGroupsOrNewsQuery query) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.newgroups(query.getDate(), query.getTime(), query.isGMT(), query.getDistributions()))) {
            return null;
        }
        return this.readNewsgroupListing();
    }

    public NewsgroupInfo[] listNewsgroups() throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.list())) {
            return null;
        }
        return this.readNewsgroupListing();
    }

    public NewsgroupInfo[] listNewsgroups(String wildmat) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.listActive(wildmat))) {
            return null;
        }
        return this.readNewsgroupListing();
    }

    public String[] listOverviewFmt() throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.sendCommand("LIST", "OVERVIEW.FMT"))) {
            return null;
        }
        try (DotTerminatedMessageReader reader = new DotTerminatedMessageReader(this._reader_);){
            String line;
            ArrayList<String> list = new ArrayList<String>();
            while ((line = ((BufferedReader)reader).readLine()) != null) {
                list.add(line);
            }
            String[] stringArray = list.toArray(NetConstants.EMPTY_STRING_ARRAY);
            return stringArray;
        }
    }

    public boolean logout() throws IOException {
        return NNTPReply.isPositiveCompletion(this.quit());
    }

    private void parseArticlePointer(String reply, ArticleInfo pointer) throws MalformedServerReplyException {
        String[] tokens = reply.split(" ");
        if (tokens.length >= 3) {
            int i2 = 1;
            try {
                pointer.articleNumber = Long.parseLong(tokens[i2++]);
                pointer.articleId = tokens[i2++];
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new MalformedServerReplyException("Could not parse article pointer.\nServer reply: " + reply);
    }

    public Writer postArticle() throws IOException {
        if (!NNTPReply.isPositiveIntermediate(this.post())) {
            return null;
        }
        return new DotTerminatedMessageWriter(this._writer_);
    }

    private NewsgroupInfo[] readNewsgroupListing() throws IOException {
        Vector<NewsgroupInfo> list = new Vector<NewsgroupInfo>(2048);
        try (DotTerminatedMessageReader reader = new DotTerminatedMessageReader(this._reader_);){
            String line;
            while ((line = ((BufferedReader)reader).readLine()) != null) {
                NewsgroupInfo tmp = NNTPClient.parseNewsgroupListEntry(line);
                if (tmp == null) {
                    throw new MalformedServerReplyException(line);
                }
                list.addElement(tmp);
            }
        }
        int size = list.size();
        if (size < 1) {
            return EMPTY_NEWSGROUP_INFO_ARRAY;
        }
        Object[] info = new NewsgroupInfo[size];
        list.copyInto(info);
        return info;
    }

    private BufferedReader retrieve(int command2, long articleNumber, ArticleInfo pointer) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.sendCommand(command2, Long.toString(articleNumber)))) {
            return null;
        }
        if (pointer != null) {
            this.parseArticlePointer(this.getReplyString(), pointer);
        }
        return new DotTerminatedMessageReader(this._reader_);
    }

    private BufferedReader retrieve(int command2, String articleId, ArticleInfo pointer) throws IOException {
        if (articleId != null ? !NNTPReply.isPositiveCompletion(this.sendCommand(command2, articleId)) : !NNTPReply.isPositiveCompletion(this.sendCommand(command2))) {
            return null;
        }
        if (pointer != null) {
            this.parseArticlePointer(this.getReplyString(), pointer);
        }
        return new DotTerminatedMessageReader(this._reader_);
    }

    public Reader retrieveArticle() throws IOException {
        return this.retrieveArticle(null);
    }

    @Deprecated
    public Reader retrieveArticle(int articleNumber) throws IOException {
        return this.retrieveArticle((long)articleNumber);
    }

    @Deprecated
    public Reader retrieveArticle(int articleNumber, ArticlePointer pointer) throws IOException {
        ArticleInfo ai = this.ap2ai(pointer);
        BufferedReader rdr = this.retrieveArticle((long)articleNumber, ai);
        this.ai2ap(ai, pointer);
        return rdr;
    }

    public BufferedReader retrieveArticle(long articleNumber) throws IOException {
        return this.retrieveArticle(articleNumber, null);
    }

    public BufferedReader retrieveArticle(long articleNumber, ArticleInfo pointer) throws IOException {
        return this.retrieve(0, articleNumber, pointer);
    }

    public Reader retrieveArticle(String articleId) throws IOException {
        return this.retrieveArticle(articleId, (ArticleInfo)null);
    }

    public BufferedReader retrieveArticle(String articleId, ArticleInfo pointer) throws IOException {
        return this.retrieve(0, articleId, pointer);
    }

    @Deprecated
    public Reader retrieveArticle(String articleId, ArticlePointer pointer) throws IOException {
        ArticleInfo ai = this.ap2ai(pointer);
        BufferedReader rdr = this.retrieveArticle(articleId, ai);
        this.ai2ap(ai, pointer);
        return rdr;
    }

    public Reader retrieveArticleBody() throws IOException {
        return this.retrieveArticleBody(null);
    }

    @Deprecated
    public Reader retrieveArticleBody(int a) throws IOException {
        return this.retrieveArticleBody((long)a);
    }

    @Deprecated
    public Reader retrieveArticleBody(int a, ArticlePointer ap) throws IOException {
        ArticleInfo ai = this.ap2ai(ap);
        BufferedReader rdr = this.retrieveArticleBody((long)a, ai);
        this.ai2ap(ai, ap);
        return rdr;
    }

    public BufferedReader retrieveArticleBody(long articleNumber) throws IOException {
        return this.retrieveArticleBody(articleNumber, null);
    }

    public BufferedReader retrieveArticleBody(long articleNumber, ArticleInfo pointer) throws IOException {
        return this.retrieve(1, articleNumber, pointer);
    }

    public Reader retrieveArticleBody(String articleId) throws IOException {
        return this.retrieveArticleBody(articleId, (ArticleInfo)null);
    }

    public BufferedReader retrieveArticleBody(String articleId, ArticleInfo pointer) throws IOException {
        return this.retrieve(1, articleId, pointer);
    }

    @Deprecated
    public Reader retrieveArticleBody(String articleId, ArticlePointer pointer) throws IOException {
        ArticleInfo ai = this.ap2ai(pointer);
        BufferedReader rdr = this.retrieveArticleBody(articleId, ai);
        this.ai2ap(ai, pointer);
        return rdr;
    }

    public Reader retrieveArticleHeader() throws IOException {
        return this.retrieveArticleHeader(null);
    }

    @Deprecated
    public Reader retrieveArticleHeader(int a) throws IOException {
        return this.retrieveArticleHeader((long)a);
    }

    @Deprecated
    public Reader retrieveArticleHeader(int a, ArticlePointer ap) throws IOException {
        ArticleInfo ai = this.ap2ai(ap);
        BufferedReader rdr = this.retrieveArticleHeader((long)a, ai);
        this.ai2ap(ai, ap);
        return rdr;
    }

    public BufferedReader retrieveArticleHeader(long articleNumber) throws IOException {
        return this.retrieveArticleHeader(articleNumber, null);
    }

    public BufferedReader retrieveArticleHeader(long articleNumber, ArticleInfo pointer) throws IOException {
        return this.retrieve(3, articleNumber, pointer);
    }

    public Reader retrieveArticleHeader(String articleId) throws IOException {
        return this.retrieveArticleHeader(articleId, (ArticleInfo)null);
    }

    public BufferedReader retrieveArticleHeader(String articleId, ArticleInfo pointer) throws IOException {
        return this.retrieve(3, articleId, pointer);
    }

    @Deprecated
    public Reader retrieveArticleHeader(String articleId, ArticlePointer pointer) throws IOException {
        ArticleInfo ai = this.ap2ai(pointer);
        BufferedReader rdr = this.retrieveArticleHeader(articleId, ai);
        this.ai2ap(ai, pointer);
        return rdr;
    }

    @Deprecated
    public Reader retrieveArticleInfo(int lowArticleNumber) throws IOException {
        return this.retrieveArticleInfo((long)lowArticleNumber);
    }

    @Deprecated
    public Reader retrieveArticleInfo(int lowArticleNumber, int highArticleNumber) throws IOException {
        return this.retrieveArticleInfo((long)lowArticleNumber, (long)highArticleNumber);
    }

    public BufferedReader retrieveArticleInfo(long articleNumber) throws IOException {
        return this.retrieveArticleInfo(Long.toString(articleNumber));
    }

    public BufferedReader retrieveArticleInfo(long lowArticleNumber, long highArticleNumber) throws IOException {
        return this.retrieveArticleInfo(lowArticleNumber + "-" + highArticleNumber);
    }

    private BufferedReader retrieveArticleInfo(String articleRange) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.xover(articleRange))) {
            return null;
        }
        return new DotTerminatedMessageReader(this._reader_);
    }

    @Deprecated
    public Reader retrieveHeader(String a, int b) throws IOException {
        return this.retrieveHeader(a, (long)b);
    }

    @Deprecated
    public Reader retrieveHeader(String header, int lowArticleNumber, int highArticleNumber) throws IOException {
        return this.retrieveHeader(header, (long)lowArticleNumber, (long)highArticleNumber);
    }

    public BufferedReader retrieveHeader(String header, long articleNumber) throws IOException {
        return this.retrieveHeader(header, Long.toString(articleNumber));
    }

    public BufferedReader retrieveHeader(String header, long lowArticleNumber, long highArticleNumber) throws IOException {
        return this.retrieveHeader(header, lowArticleNumber + "-" + highArticleNumber);
    }

    private BufferedReader retrieveHeader(String header, String articleRange) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.xhdr(header, articleRange))) {
            return null;
        }
        return new DotTerminatedMessageReader(this._reader_);
    }

    public boolean selectArticle(ArticleInfo pointer) throws IOException {
        return this.selectArticle(null, pointer);
    }

    @Deprecated
    public boolean selectArticle(ArticlePointer pointer) throws IOException {
        ArticleInfo ai = this.ap2ai(pointer);
        boolean b = this.selectArticle(ai);
        this.ai2ap(ai, pointer);
        return b;
    }

    @Deprecated
    public boolean selectArticle(int a) throws IOException {
        return this.selectArticle((long)a);
    }

    @Deprecated
    public boolean selectArticle(int a, ArticlePointer ap) throws IOException {
        ArticleInfo ai = this.ap2ai(ap);
        boolean b = this.selectArticle((long)a, ai);
        this.ai2ap(ai, ap);
        return b;
    }

    public boolean selectArticle(long articleNumber) throws IOException {
        return this.selectArticle(articleNumber, null);
    }

    public boolean selectArticle(long articleNumber, ArticleInfo pointer) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.stat(articleNumber))) {
            return false;
        }
        if (pointer != null) {
            this.parseArticlePointer(this.getReplyString(), pointer);
        }
        return true;
    }

    public boolean selectArticle(String articleId) throws IOException {
        return this.selectArticle(articleId, (ArticleInfo)null);
    }

    public boolean selectArticle(String articleId, ArticleInfo pointer) throws IOException {
        if (articleId != null ? !NNTPReply.isPositiveCompletion(this.stat(articleId)) : !NNTPReply.isPositiveCompletion(this.stat())) {
            return false;
        }
        if (pointer != null) {
            this.parseArticlePointer(this.getReplyString(), pointer);
        }
        return true;
    }

    @Deprecated
    public boolean selectArticle(String articleId, ArticlePointer pointer) throws IOException {
        ArticleInfo ai = this.ap2ai(pointer);
        boolean b = this.selectArticle(articleId, ai);
        this.ai2ap(ai, pointer);
        return b;
    }

    public boolean selectNewsgroup(String newsgroup) throws IOException {
        return this.selectNewsgroup(newsgroup, null);
    }

    public boolean selectNewsgroup(String newsgroup, NewsgroupInfo info) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.group(newsgroup))) {
            return false;
        }
        if (info != null) {
            NNTPClient.parseGroupReply(this.getReplyString(), info);
        }
        return true;
    }

    public boolean selectNextArticle() throws IOException {
        return this.selectNextArticle((ArticleInfo)null);
    }

    public boolean selectNextArticle(ArticleInfo pointer) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.next())) {
            return false;
        }
        if (pointer != null) {
            this.parseArticlePointer(this.getReplyString(), pointer);
        }
        return true;
    }

    @Deprecated
    public boolean selectNextArticle(ArticlePointer pointer) throws IOException {
        ArticleInfo ai = this.ap2ai(pointer);
        boolean b = this.selectNextArticle(ai);
        this.ai2ap(ai, pointer);
        return b;
    }

    public boolean selectPreviousArticle() throws IOException {
        return this.selectPreviousArticle((ArticleInfo)null);
    }

    public boolean selectPreviousArticle(ArticleInfo pointer) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.last())) {
            return false;
        }
        if (pointer != null) {
            this.parseArticlePointer(this.getReplyString(), pointer);
        }
        return true;
    }

    @Deprecated
    public boolean selectPreviousArticle(ArticlePointer pointer) throws IOException {
        ArticleInfo ai = this.ap2ai(pointer);
        boolean b = this.selectPreviousArticle(ai);
        this.ai2ap(ai, pointer);
        return b;
    }
}

