/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data.repo;

import at.hannibal2.skyhanni.config.ConfigManager;
import at.hannibal2.skyhanni.data.repo.ChatProgressUpdates;
import at.hannibal2.skyhanni.data.repo.DiskRepoFileSystem;
import at.hannibal2.skyhanni.data.repo.MemoryRepoFileSystem;
import at.hannibal2.skyhanni.data.repo.RepoLogger;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 $2\u00020\u0001:\u0001$J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0007H&\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J!\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ'\u0010\"\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b\"\u0010#\u0082\u0001\u0002%&\u00a8\u0006'"}, d2={"Lat/hannibal2/skyhanni/data/repo/RepoFileSystem;", "", "", "path", "", "exists", "(Ljava/lang/String;)Z", "", "readAllBytes", "(Ljava/lang/String;)[B", "data", "", "write", "(Ljava/lang/String;[B)V", "", "list", "(Ljava/lang/String;)Ljava/util/List;", "Lat/hannibal2/skyhanni/data/repo/ChatProgressUpdates;", "progress", "transitionAfterReload", "(Lat/hannibal2/skyhanni/data/repo/ChatProgressUpdates;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteRecursively", "(Ljava/lang/String;)V", "deleteAll", "()V", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/JsonElement;", "readAllBytesAsJsonElement", "(Ljava/lang/String;Lcom/google/gson/Gson;)Lcom/google/gson/JsonElement;", "Ljava/io/File;", "zipFile", "Lat/hannibal2/skyhanni/data/repo/RepoLogger;", "logger", "loadFromZip", "(Lat/hannibal2/skyhanni/data/repo/ChatProgressUpdates;Ljava/io/File;Lat/hannibal2/skyhanni/data/repo/RepoLogger;)Z", "Companion", "Lat/hannibal2/skyhanni/data/repo/DiskRepoFileSystem;", "Lat/hannibal2/skyhanni/data/repo/MemoryRepoFileSystem;", "1.21.7"})
public sealed interface RepoFileSystem
permits DiskRepoFileSystem, MemoryRepoFileSystem {
    @NotNull
    public static final Companion Companion = at.hannibal2.skyhanni.data.repo.RepoFileSystem$Companion.$$INSTANCE;

    public boolean exists(@NotNull String var1);

    @NotNull
    public byte[] readAllBytes(@NotNull String var1);

    public void write(@NotNull String var1, @NotNull byte[] var2);

    @NotNull
    public List<String> list(@NotNull String var1);

    @Nullable
    public Object transitionAfterReload(@NotNull ChatProgressUpdates var1, @NotNull Continuation<? super RepoFileSystem> var2);

    public void deleteRecursively(@NotNull String var1);

    public void deleteAll();

    @NotNull
    public JsonElement readAllBytesAsJsonElement(@NotNull String var1, @NotNull Gson var2);

    public boolean loadFromZip(@NotNull ChatProgressUpdates var1, @NotNull File var2, @NotNull RepoLogger var3);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lat/hannibal2/skyhanni/data/repo/RepoFileSystem$Companion;", "", "<init>", "()V", "Ljava/io/File;", "root", "", "useMemory", "Lat/hannibal2/skyhanni/data/repo/RepoFileSystem;", "createAndClean", "(Ljava/io/File;Z)Lat/hannibal2/skyhanni/data/repo/RepoFileSystem;", "1.21.7"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final RepoFileSystem createAndClean(@NotNull File root, boolean useMemory) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            RepoFileSystem fs = useMemory ? (RepoFileSystem)new MemoryRepoFileSystem(root) : (RepoFileSystem)new DiskRepoFileSystem(root);
            fs.deleteAll();
            return fs;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nRepoFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepoFileSystem.kt\nat/hannibal2/skyhanni/data/repo/RepoFileSystem$DefaultImpls\n+ 2 JsonUtils.kt\nat/hannibal2/skyhanni/utils/json/JsonUtilsKt\n*L\n1#1,176:1\n21#2:177\n*S KotlinDebug\n*F\n+ 1 RepoFileSystem.kt\nat/hannibal2/skyhanni/data/repo/RepoFileSystem$DefaultImpls\n*L\n37#1:177\n*E\n"})
    public static final class DefaultImpls {
        @Nullable
        public static Object transitionAfterReload(@NotNull RepoFileSystem $this, @NotNull ChatProgressUpdates progress, @NotNull Continuation<? super RepoFileSystem> $completion) {
            return $this;
        }

        public static void deleteAll(@NotNull RepoFileSystem $this) {
            $this.deleteRecursively("");
        }

        @NotNull
        public static JsonElement readAllBytesAsJsonElement(@NotNull RepoFileSystem $this, @NotNull String path, @NotNull Gson gson) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
            byte[] bytes = $this.readAllBytes(path);
            String jsonText = new String(bytes, Charsets.UTF_8);
            Gson $this$fromJson$iv = gson;
            boolean $i$f$fromJson = false;
            Object object = $this$fromJson$iv.fromJson(jsonText, ReflectJvmMapping.getJavaType((KType)Reflection.typeOf(JsonElement.class)));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
            return (JsonElement)object;
        }

        public static /* synthetic */ JsonElement readAllBytesAsJsonElement$default(RepoFileSystem repoFileSystem, String string, Gson gson, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readAllBytesAsJsonElement");
            }
            if ((n & 2) != 0) {
                gson = ConfigManager.Companion.getGson();
            }
            return repoFileSystem.readAllBytesAsJsonElement(string, gson);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean loadFromZip(@NotNull RepoFileSystem $this, @NotNull ChatProgressUpdates progress, @NotNull File zipFile, @NotNull RepoLogger logger) {
            Object object;
            Object $this$loadFromZip_u24lambda_u243;
            Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
            Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Object object2 = $this;
            try {
                $this$loadFromZip_u24lambda_u243 = object2;
                boolean bl = false;
                progress.update("loadFromZip");
                Closeable closeable = new ZipFile(zipFile.getAbsolutePath());
                Throwable throwable = null;
                try {
                    ZipFile zip = (ZipFile)closeable;
                    boolean bl2 = false;
                    progress.update("zipFile entries collect");
                    Enumeration<? extends ZipEntry> enumeration = zip.entries();
                    Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
                    List entries = SequencesKt.toList((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), DefaultImpls::loadFromZip$lambda$3$lambda$2$lambda$0));
                    progress.innerProgressStart(entries.size());
                    for (ZipEntry entry : entries) {
                        Path outPath;
                        progress.innerProgressStep();
                        String string = entry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        String string2 = entry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                        String relative = StringsKt.substringAfter((String)string, (char)'/', (String)string2);
                        if (StringsKt.isBlank((CharSequence)relative)) continue;
                        if ($this instanceof DiskRepoFileSystem && !(outPath = ((DiskRepoFileSystem)$this).getRoot().toPath().resolve(relative).normalize()).startsWith(((DiskRepoFileSystem)$this).getRoot().toPath())) {
                            throw new RuntimeException("SkyHanni detected an invalid zip file. This is a potential security risk, please report this on the SkyHanni discord.");
                        }
                        Closeable closeable2 = zip.getInputStream(entry);
                        Throwable throwable2 = null;
                        try {
                            InputStream input2 = (InputStream)closeable2;
                            boolean bl3 = false;
                            Intrinsics.checkNotNull((Object)input2);
                            byte[] data = ByteStreamsKt.readBytes((InputStream)input2);
                            $this$loadFromZip_u24lambda_u243.write(relative, data);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                    }
                    progress.update("done with forEach");
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                $this$loadFromZip_u24lambda_u243 = Result.constructor-impl((Object)true);
            }
            catch (Throwable bl) {
                $this$loadFromZip_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = $this$loadFromZip_u24lambda_u243;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) {
                object = object2;
            } else {
                Throwable it = throwable;
                boolean bl = false;
                progress.update("Failed to load repo from zip file: " + zipFile.getAbsolutePath());
                logger.logNonDestructiveError("Failed to load repo from zip file: " + zipFile.getAbsolutePath());
                object = false;
            }
            return (Boolean)object;
        }

        private static boolean loadFromZip$lambda$3$lambda$2$lambda$0(ZipEntry it) {
            return it.isDirectory();
        }
    }
}

