/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.api;

import at.hannibal2.skyhanni.data.jsonobjects.other.HypixelApiProfile;
import at.hannibal2.skyhanni.data.jsonobjects.other.HypixelApiTrophyFish;
import at.hannibal2.skyhanni.data.jsonobjects.other.HypixelPlayerApiJson;
import at.hannibal2.skyhanni.events.NeuProfileDataLoadedEvent;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.json.BaseGsonBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bR#\u0010\u000f\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lat/hannibal2/skyhanni/api/SkyBlockAPIEventWrappers;", "", "<init>", "()V", "Lcom/google/gson/JsonObject;", "data", "", "onPvLoad", "(Lcom/google/gson/JsonObject;)V", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "hypixelApiGson$delegate", "Lkotlin/Lazy;", "getHypixelApiGson", "()Lcom/google/gson/Gson;", "hypixelApiGson", "1.21.7"})
@SourceDebugExtension(value={"SMAP\nSkyBlockAPIEventWrappers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkyBlockAPIEventWrappers.kt\nat/hannibal2/skyhanni/api/SkyBlockAPIEventWrappers\n+ 2 JsonUtils.kt\nat/hannibal2/skyhanni/utils/json/JsonUtilsKt\n*L\n1#1,75:1\n24#2:76\n*S KotlinDebug\n*F\n+ 1 SkyBlockAPIEventWrappers.kt\nat/hannibal2/skyhanni/api/SkyBlockAPIEventWrappers\n*L\n62#1:76\n*E\n"})
public final class SkyBlockAPIEventWrappers {
    @NotNull
    public static final SkyBlockAPIEventWrappers INSTANCE = new SkyBlockAPIEventWrappers();
    @NotNull
    private static final Lazy hypixelApiGson$delegate = LazyKt.lazy(SkyBlockAPIEventWrappers::hypixelApiGson_delegate$lambda$0);

    private SkyBlockAPIEventWrappers() {
    }

    private final Gson getHypixelApiGson() {
        Lazy lazy = hypixelApiGson$delegate;
        return (Gson)lazy.getValue();
    }

    @JvmStatic
    public static final void onPvLoad(@NotNull JsonObject data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            Gson gson = INSTANCE.getHypixelApiGson();
            Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"<get-hypixelApiGson>(...)");
            Gson $this$fromJson$iv = gson;
            boolean $i$f$fromJson = false;
            Object object = $this$fromJson$iv.fromJson((JsonElement)data, ReflectJvmMapping.getJavaType((KType)Reflection.typeOf(HypixelApiProfile.class)));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
            HypixelApiProfile profileData = (HypixelApiProfile)object;
            HypixelPlayerApiJson playerData = new HypixelPlayerApiJson(CollectionsKt.listOf((Object)profileData));
            new NeuProfileDataLoadedEvent(playerData).post();
        }
        catch (Exception e) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"data", (Object)data)};
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Error reading hypixel player api data", pairArray, false, false, false, 56, null);
        }
    }

    private static final Gson hypixelApiGson_delegate$lambda$0() {
        return BaseGsonBuilder.INSTANCE.gson().registerTypeAdapter((Type)((Object)HypixelApiTrophyFish.class), (Object)new TypeAdapter<HypixelApiTrophyFish>(){

            public void write(JsonWriter out, HypixelApiTrophyFish value) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            }

            public HypixelApiTrophyFish read(JsonReader reader) {
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                Map trophyFish = new LinkedHashMap<K, V>();
                int totalCaught = 0;
                reader.beginObject();
                while (reader.hasNext()) {
                    String key = reader.nextName();
                    if (Intrinsics.areEqual((Object)key, (Object)"total_caught")) {
                        totalCaught = reader.nextInt();
                        continue;
                    }
                    if (reader.peek() == JsonToken.NUMBER) {
                        String valueAsString = reader.nextString();
                        Intrinsics.checkNotNull((Object)valueAsString);
                        if (NumberUtil.INSTANCE.isInt(valueAsString)) {
                            trophyFish.put(key, Integer.parseInt(valueAsString));
                            continue;
                        }
                    }
                    reader.skipValue();
                }
                reader.endObject();
                return new HypixelApiTrophyFish(totalCaught, trophyFish);
            }
        }.nullSafe()).create();
    }
}

