/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.lisp;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import moe.nea.lisp.LispAst;
import moe.nea.lisp.LispParser;
import moe.nea.lisp.StringRacer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0006\u0010\u0019\u001a\u00020\u0007J\u0006\u0010\u001a\u001a\u00020\u0003J\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lmoe/nea/lisp/LispParser;", "", "filename", "", "string", "(Ljava/lang/String;Ljava/lang/String;)V", "program", "Lmoe/nea/lisp/LispAst$Program;", "getProgram", "()Lmoe/nea/lisp/LispAst$Program;", "racer", "Lmoe/nea/lisp/StringRacer;", "getRacer", "()Lmoe/nea/lisp/StringRacer;", "parseAtom", "Lmoe/nea/lisp/LispAst$Atom;", "parseIdentifier", "parseNode", "Lmoe/nea/lisp/LispAst$LispNode;", "parseNumber", "Lmoe/nea/lisp/LispAst$NumberLiteral;", "parseParenthesis", "", "opening", "closing", "parseProgram", "parseQuotedString", "parseString", "Lmoe/nea/lisp/LispAst$StringLiteral;", "Companion", "nealisp"})
public final class LispParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StringRacer racer;
    @NotNull
    private final LispAst.Program program;
    @NotNull
    private static final String digits = "1234567890";
    @NotNull
    private static final String hexDigits = digits + "abcdefABCDEF";
    @NotNull
    private static final String alphabet = "abcdefghijklmnopqrstuvwxyz";
    @NotNull
    private static final String validStartingIdentifiers;
    @NotNull
    private static final String validIdentifiers;
    @NotNull
    private static final Map<String, String> parenthesisMatches;

    private LispParser(String filename, String string) {
        this.racer = new StringRacer(filename, string);
        this.program = this.parseProgram();
    }

    @NotNull
    public final StringRacer getRacer() {
        return this.racer;
    }

    @NotNull
    public final LispAst.Program getProgram() {
        return this.program;
    }

    @NotNull
    public final LispAst.Program parseProgram() {
        int start = this.racer.getIdx();
        List nodes = new ArrayList();
        while (true) {
            this.racer.skipWhitespace();
            if (this.racer.finished()) break;
            nodes.add(this.parseNode());
        }
        return new LispAst.Program(this.racer.span(start), nodes);
    }

    private final LispAst.LispNode parseNode() {
        int start = this.racer.getIdx();
        String string = this.racer.peekReq(1);
        if (string == null) {
            this.racer.error("Expected start of expression");
            throw new KotlinNothingValueException();
        }
        String paren = string;
        String matchingParen = parenthesisMatches.get(paren);
        if (matchingParen != null) {
            List<LispAst.LispNode> paren2 = this.parseParenthesis(paren, matchingParen);
            return new LispAst.Parenthesis(this.racer.span(start), paren2);
        }
        if (Intrinsics.areEqual((Object)paren, (Object)"\"")) {
            return this.parseString();
        }
        if (StringsKt.contains$default((CharSequence)digits, (CharSequence)paren, (boolean)false, (int)2, null)) {
            return this.parseNumber();
        }
        if (Intrinsics.areEqual((Object)paren, (Object)":")) {
            return this.parseAtom();
        }
        String ident = this.parseIdentifier();
        return new LispAst.Reference(this.racer.span(start), ident);
    }

    @NotNull
    public final LispAst.NumberLiteral parseNumber() {
        int start = this.racer.getIdx();
        this.racer.pushState();
        String number2 = this.racer.consumeWhile((Function1<? super String, Boolean>)((Function1)parseNumber.number.1.INSTANCE));
        Double d = StringsKt.toDoubleOrNull((String)number2);
        if (StringsKt.startsWith$default((String)number2, (String)"0x", (boolean)false, (int)2, null)) {
            String string = number2.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            d = Long.parseLong(string, CharsKt.checkRadix((int)16));
        }
        if (d == null) {
            this.racer.popState();
            this.racer.error("Could not parse number " + number2);
            throw new KotlinNothingValueException();
        }
        this.racer.discardState();
        return new LispAst.NumberLiteral(this.racer.span(start), d);
    }

    @NotNull
    public final LispAst.Atom parseAtom() {
        int start = this.racer.getIdx();
        this.racer.expect(":", "Expected : at start of atom");
        String ident = this.parseIdentifier();
        return new LispAst.Atom(this.racer.span(start), ident);
    }

    @NotNull
    public final String parseIdentifier() {
        String string;
        String it = string = this.racer.consumeWhile((Function1<? super String, Boolean>)((Function1)parseIdentifier.1.INSTANCE));
        boolean bl = false;
        if (((CharSequence)it).length() == 0) {
            this.racer.error("Expected identifier");
            throw new KotlinNothingValueException();
        }
        return string;
    }

    @NotNull
    public final LispAst.StringLiteral parseString() {
        int start = this.racer.getIdx();
        String quoted = this.parseQuotedString();
        return new LispAst.StringLiteral(this.racer.span(start), quoted);
    }

    @NotNull
    public final String parseQuotedString() {
        String peek;
        this.racer.expect("\"", "Expected '\"' at string start");
        StringBuilder sb = new StringBuilder();
        while (!Intrinsics.areEqual((Object)(peek = this.racer.consumeCountReq(1)), (Object)"\"")) {
            if (Intrinsics.areEqual((Object)peek, (Object)"\\")) {
                String escaped;
                if (this.racer.consumeCountReq(1) == null) {
                    this.racer.error("Unfinished backslash escape");
                    throw new KotlinNothingValueException();
                }
                if (!Intrinsics.areEqual((Object)escaped, (Object)"\"") && !Intrinsics.areEqual((Object)escaped, (Object)"\\")) {
                    StringRacer stringRacer = this.racer;
                    int n = stringRacer.getIdx();
                    stringRacer.setIdx(n + -1);
                    this.racer.error("Invalid backslash escape '" + escaped + '\'');
                    throw new KotlinNothingValueException();
                }
                sb.append(escaped);
                continue;
            }
            if (peek == null) {
                this.racer.error("Unfinished string");
                throw new KotlinNothingValueException();
            }
            sb.append(peek);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private final List<LispAst.LispNode> parseParenthesis(String opening, String closing) {
        List l = new ArrayList();
        this.racer.expect(opening, "Expected " + opening);
        while (true) {
            this.racer.skipWhitespace();
            if (this.racer.tryConsume(closing)) {
                return l;
            }
            l.add(this.parseNode());
        }
    }

    public /* synthetic */ LispParser(String filename, String string, DefaultConstructorMarker $constructor_marker) {
        this(filename, string);
    }

    static {
        StringBuilder stringBuilder = new StringBuilder().append("-.#+*'!$%&/=?_~|^").append(alphabet);
        String string = alphabet.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        validStartingIdentifiers = stringBuilder.append(string).toString();
        validIdentifiers = validStartingIdentifiers + digits;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"(", (Object)")"), TuplesKt.to((Object)"[", (Object)"]"), TuplesKt.to((Object)"{", (Object)"}"), TuplesKt.to((Object)"<", (Object)">")};
        parenthesisMatches = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lmoe/nea/lisp/LispParser$Companion;", "", "()V", "alphabet", "", "getAlphabet", "()Ljava/lang/String;", "digits", "getDigits", "hexDigits", "getHexDigits", "parenthesisMatches", "", "getParenthesisMatches", "()Ljava/util/Map;", "validIdentifiers", "getValidIdentifiers", "validStartingIdentifiers", "getValidStartingIdentifiers", "isValidIdentifier", "", "name", "parse", "Lmoe/nea/lisp/LispAst$Program;", "file", "Ljava/io/File;", "filename", "string", "nealisp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LispAst.Program parse(@NotNull String filename, @NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            return new LispParser(filename, string, null).getProgram();
        }

        @NotNull
        public final LispAst.Program parse(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String string = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
            return this.parse(string, FilesKt.readText$default((File)file, null, (int)1, null));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isValidIdentifier(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (((CharSequence)name).length() <= 0) return false;
            boolean bl = true;
            if (!bl) return false;
            if (!StringsKt.contains$default((CharSequence)this.getValidStartingIdentifiers(), (char)StringsKt.first((CharSequence)name), (boolean)false, (int)2, null)) return false;
            CharSequence $this$all$iv = name;
            boolean $i$f$all = false;
            int n = 0;
            while (n < $this$all$iv.length()) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(n);
                boolean bl2 = false;
                if (!StringsKt.contains$default((CharSequence)Companion.getValidIdentifiers(), (char)it, (boolean)false, (int)2, null)) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        @NotNull
        public final String getDigits() {
            return digits;
        }

        @NotNull
        public final String getHexDigits() {
            return hexDigits;
        }

        @NotNull
        public final String getAlphabet() {
            return alphabet;
        }

        @NotNull
        public final String getValidStartingIdentifiers() {
            return validStartingIdentifiers;
        }

        @NotNull
        public final String getValidIdentifiers() {
            return validIdentifiers;
        }

        @NotNull
        public final Map<String, String> getParenthesisMatches() {
            return parenthesisMatches;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

