/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.util;

import java.util.Stack;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2514;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 #2\u00020\u0001:\u0004$%#&B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0013R\u0017\u0010\u001c\u001a\u00020\u001b8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010\u000b\u00a8\u0006'"}, d2={"Lmoe/nea/firmament/util/LegacyTagParser;", "", "", "string", "<init>", "(Ljava/lang/String;)V", "", "skipWhitespace", "()V", "Lnet/minecraft/class_2487;", "parseTag", "()Lnet/minecraft/class_2487;", "Lnet/minecraft/class_2520;", "parseAny", "()Lnet/minecraft/class_2520;", "Lnet/minecraft/class_2499;", "parseList", "()Lnet/minecraft/class_2499;", "parseQuotedString", "()Ljava/lang/String;", "Lnet/minecraft/class_2519;", "parseStringTag", "()Lnet/minecraft/class_2519;", "Lnet/minecraft/class_2514;", "parseNumericTag", "()Lnet/minecraft/class_2514;", "parseIdentifier", "Lmoe/nea/firmament/util/LegacyTagParser$StringRacer;", "racer", "Lmoe/nea/firmament/util/LegacyTagParser$StringRacer;", "getRacer", "()Lmoe/nea/firmament/util/LegacyTagParser$StringRacer;", "baseTag", "Lnet/minecraft/class_2487;", "getBaseTag", "Companion", "TagParsingException", "StringRacer", "Patterns", "Firmament"})
@SourceDebugExtension(value={"SMAP\nLegacyTagParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyTagParser.kt\nmoe/nea/firmament/util/LegacyTagParser\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,246:1\n1069#2,2:247\n*S KotlinDebug\n*F\n+ 1 LegacyTagParser.kt\nmoe/nea/firmament/util/LegacyTagParser\n*L\n144#1:247,2\n*E\n"})
public final class LegacyTagParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StringRacer racer;
    @NotNull
    private final class_2487 baseTag;
    @NotNull
    private static final String digitRange = "0123456789-";

    private LegacyTagParser(String string) {
        this.racer = new StringRacer(string);
        this.baseTag = this.parseTag();
    }

    @NotNull
    public final StringRacer getRacer() {
        return this.racer;
    }

    @NotNull
    public final class_2487 getBaseTag() {
        return this.baseTag;
    }

    public final void skipWhitespace() {
        this.racer.consumeWhile((Function1<? super String, Boolean>)((Function1)LegacyTagParser::skipWhitespace$lambda$0));
    }

    @NotNull
    public final class_2487 parseTag() {
        this.skipWhitespace();
        this.racer.expect("{", "Expected '{\u2019 at start of tag");
        this.skipWhitespace();
        class_2487 tag = new class_2487();
        while (!this.racer.tryConsume("}")) {
            this.skipWhitespace();
            String lhs = this.parseIdentifier();
            this.skipWhitespace();
            this.racer.expect(":", "Expected ':' after identifier in tag");
            this.skipWhitespace();
            class_2520 rhs = this.parseAny();
            tag.method_10566(lhs, rhs);
            this.racer.tryConsume(",");
            this.skipWhitespace();
        }
        return tag;
    }

    private final class_2520 parseAny() {
        class_2520 class_25202;
        this.skipWhitespace();
        String string = this.racer.peekReq(1);
        if (string == null) {
            this.racer.error("Expected new object, found EOF");
            throw new KotlinNothingValueException();
        }
        String nextChar = string;
        if (Intrinsics.areEqual((Object)nextChar, (Object)"{")) {
            class_25202 = (class_2520)this.parseTag();
        } else if (Intrinsics.areEqual((Object)nextChar, (Object)"[")) {
            class_25202 = (class_2520)this.parseList();
        } else if (Intrinsics.areEqual((Object)nextChar, (Object)"\"")) {
            class_25202 = (class_2520)this.parseStringTag();
        } else if (StringsKt.contains$default((CharSequence)digitRange, (char)StringsKt.first((CharSequence)nextChar), (boolean)false, (int)2, null)) {
            class_25202 = (class_2520)this.parseNumericTag();
        } else {
            this.racer.error("Unexpected token found. Expected start of new element");
            throw new KotlinNothingValueException();
        }
        return class_25202;
    }

    @NotNull
    public final class_2499 parseList() {
        this.skipWhitespace();
        this.racer.expect("[", "Expected '[' at start of tag");
        this.skipWhitespace();
        class_2499 list = new class_2499();
        while (!this.racer.tryConsume("]")) {
            this.skipWhitespace();
            this.racer.pushState();
            String lhs = this.racer.consumeWhile((Function1<? super String, Boolean>)((Function1)LegacyTagParser::parseList$lambda$2));
            this.skipWhitespace();
            if (!this.racer.tryConsume(":") || ((CharSequence)lhs).length() == 0) {
                this.racer.popState();
                v0 = list.add((Object)this.parseAny());
            } else {
                this.racer.discardState();
                this.skipWhitespace();
                v0 = list.add((Object)this.parseAny());
            }
            this.skipWhitespace();
            this.racer.tryConsume(",");
        }
        return list;
    }

    @NotNull
    public final String parseQuotedString() {
        String peek;
        this.skipWhitespace();
        this.racer.expect("\"", "Expected '\"' at string start");
        StringBuilder sb = new StringBuilder();
        while (!Intrinsics.areEqual((Object)(peek = this.racer.consumeCountReq(1)), (Object)"\"")) {
            StringBuilder stringBuilder;
            if (Intrinsics.areEqual((Object)peek, (Object)"\\")) {
                String escaped;
                if (this.racer.consumeCountReq(1) == null) {
                    this.racer.error("Unfinished backslash escape");
                    throw new KotlinNothingValueException();
                }
                if (!Intrinsics.areEqual((Object)escaped, (Object)"\"") && !Intrinsics.areEqual((Object)escaped, (Object)"\\")) {
                    StringRacer stringRacer = this.racer;
                    int n = stringRacer.getIdx();
                    stringRacer.setIdx(n + -1);
                    this.racer.error("Invalid backslash escape '" + escaped + "'");
                    throw new KotlinNothingValueException();
                }
                stringBuilder = sb.append(escaped);
                continue;
            }
            if (peek == null) {
                this.racer.error("Unfinished string");
                throw new KotlinNothingValueException();
            }
            stringBuilder = sb.append(peek);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final class_2519 parseStringTag() {
        class_2519 class_25192 = class_2519.method_23256((String)this.parseQuotedString());
        Intrinsics.checkNotNullExpressionValue((Object)class_25192, (String)"of(...)");
        return class_25192;
    }

    @NotNull
    public final class_2514 parseNumericTag() {
        MatchResult doubleMatch;
        this.skipWhitespace();
        String textForm = this.racer.consumeWhile((Function1<? super String, Boolean>)((Function1)LegacyTagParser::parseNumericTag$lambda$3));
        if (((CharSequence)textForm).length() == 0) {
            this.racer.error("Expected numeric tag (starting with either -, +, . or a digit");
            throw new KotlinNothingValueException();
        }
        MatchResult floatMatch = Patterns.INSTANCE.getFLOAT().matchEntire((CharSequence)textForm);
        if (floatMatch != null) {
            MatchGroup matchGroup = floatMatch.getGroups().get(1);
            Intrinsics.checkNotNull((Object)matchGroup);
            class_2494 class_24942 = class_2494.method_23244((float)Float.parseFloat(matchGroup.getValue()));
            Intrinsics.checkNotNullExpressionValue((Object)class_24942, (String)"of(...)");
            return (class_2514)class_24942;
        }
        MatchResult byteMatch = Patterns.INSTANCE.getBYTE().matchEntire((CharSequence)textForm);
        if (byteMatch != null) {
            MatchGroup matchGroup = byteMatch.getGroups().get(1);
            Intrinsics.checkNotNull((Object)matchGroup);
            class_2481 class_24812 = class_2481.method_23233((byte)Byte.parseByte(matchGroup.getValue()));
            Intrinsics.checkNotNullExpressionValue((Object)class_24812, (String)"of(...)");
            return (class_2514)class_24812;
        }
        MatchResult longMatch = Patterns.INSTANCE.getLONG().matchEntire((CharSequence)textForm);
        if (longMatch != null) {
            MatchGroup matchGroup = longMatch.getGroups().get(1);
            Intrinsics.checkNotNull((Object)matchGroup);
            class_2503 class_25032 = class_2503.method_23251((long)Long.parseLong(matchGroup.getValue()));
            Intrinsics.checkNotNullExpressionValue((Object)class_25032, (String)"of(...)");
            return (class_2514)class_25032;
        }
        MatchResult shortMatch = Patterns.INSTANCE.getSHORT().matchEntire((CharSequence)textForm);
        if (shortMatch != null) {
            MatchGroup matchGroup = shortMatch.getGroups().get(1);
            Intrinsics.checkNotNull((Object)matchGroup);
            class_2516 class_25162 = class_2516.method_23254((short)Short.parseShort(matchGroup.getValue()));
            Intrinsics.checkNotNullExpressionValue((Object)class_25162, (String)"of(...)");
            return (class_2514)class_25162;
        }
        MatchResult integerMatch = Patterns.INSTANCE.getINTEGER().matchEntire((CharSequence)textForm);
        if (integerMatch != null) {
            MatchGroup matchGroup = integerMatch.getGroups().get(1);
            Intrinsics.checkNotNull((Object)matchGroup);
            class_2497 class_24972 = class_2497.method_23247((int)Integer.parseInt(matchGroup.getValue()));
            Intrinsics.checkNotNullExpressionValue((Object)class_24972, (String)"of(...)");
            return (class_2514)class_24972;
        }
        MatchResult matchResult = Patterns.INSTANCE.getDOUBLE().matchEntire((CharSequence)textForm);
        if (matchResult == null) {
            matchResult = Patterns.INSTANCE.getDOUBLE_UNTYPED().matchEntire((CharSequence)textForm);
        }
        if ((doubleMatch = matchResult) != null) {
            MatchGroup matchGroup = doubleMatch.getGroups().get(1);
            Intrinsics.checkNotNull((Object)matchGroup);
            class_2489 class_24892 = class_2489.method_23241((double)Double.parseDouble(matchGroup.getValue()));
            Intrinsics.checkNotNullExpressionValue((Object)class_24892, (String)"of(...)");
            return (class_2514)class_24892;
        }
        throw new IllegalStateException("Could not properly parse numeric tag '" + textForm + "', despite passing rough verification. This is a bug in the LegacyTagParser");
    }

    private final String parseIdentifier() {
        this.skipWhitespace();
        if (Intrinsics.areEqual((Object)this.racer.peek(1), (Object)"\"")) {
            return this.parseQuotedString();
        }
        return this.racer.consumeWhile((Function1<? super String, Boolean>)((Function1)LegacyTagParser::parseIdentifier$lambda$4));
    }

    private static final boolean skipWhitespace$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Character.isWhitespace(StringsKt.last((CharSequence)it));
    }

    private static final boolean parseList$lambda$2(String it) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            CharSequence $this$all$iv = it;
            boolean $i$f$all = false;
            for (int j = 0; j < $this$all$iv.length(); ++j) {
                char element$iv;
                char it2 = element$iv = $this$all$iv.charAt(j);
                boolean bl2 = false;
                if (StringsKt.contains$default((CharSequence)digitRange, (char)it2, (boolean)false, (int)2, null)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private static final boolean parseNumericTag$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Patterns.INSTANCE.getROUGH_PATTERN().matchEntire((CharSequence)it) != null;
    }

    private static final boolean parseIdentifier$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        char x = StringsKt.last((CharSequence)it);
        return x != ':' && !Character.isWhitespace(x);
    }

    public /* synthetic */ LegacyTagParser(String string, DefaultConstructorMarker $constructor_marker) {
        this(string);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u00048\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lmoe/nea/firmament/util/LegacyTagParser$Companion;", "", "<init>", "()V", "", "string", "Lnet/minecraft/class_2487;", "parse", "(Ljava/lang/String;)Lnet/minecraft/class_2487;", "digitRange", "Ljava/lang/String;", "getDigitRange", "()Ljava/lang/String;", "Firmament"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDigitRange() {
            return digitRange;
        }

        @NotNull
        public final class_2487 parse(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            return new LegacyTagParser(string, null).getBaseTag();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0006\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0006\u001a\u0004\b\f\u0010\bR\u0017\u0010\r\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u0006\u001a\u0004\b\u000e\u0010\bR\u0017\u0010\u000f\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0006\u001a\u0004\b\u0010\u0010\bR\u0017\u0010\u0011\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0006\u001a\u0004\b\u0012\u0010\bR\u0017\u0010\u0013\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0006\u001a\u0004\b\u0014\u0010\bR\u0017\u0010\u0015\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0006\u001a\u0004\b\u0016\u0010\b\u00a8\u0006\u0017"}, d2={"Lmoe/nea/firmament/util/LegacyTagParser$Patterns;", "", "<init>", "()V", "Lkotlin/text/Regex;", "DOUBLE", "Lkotlin/text/Regex;", "getDOUBLE", "()Lkotlin/text/Regex;", "FLOAT", "getFLOAT", "BYTE", "getBYTE", "LONG", "getLONG", "SHORT", "getSHORT", "INTEGER", "getINTEGER", "DOUBLE_UNTYPED", "getDOUBLE_UNTYPED", "ROUGH_PATTERN", "getROUGH_PATTERN", "Firmament"})
    public static final class Patterns {
        @NotNull
        public static final Patterns INSTANCE = new Patterns();
        @NotNull
        private static final Regex DOUBLE = new Regex("([-+]?[0-9]*\\.?[0-9]+)[d|D]");
        @NotNull
        private static final Regex FLOAT = new Regex("([-+]?[0-9]*\\.?[0-9]+)[f|F]");
        @NotNull
        private static final Regex BYTE = new Regex("([-+]?[0-9]+)[b|B]");
        @NotNull
        private static final Regex LONG = new Regex("([-+]?[0-9]+)[l|L]");
        @NotNull
        private static final Regex SHORT = new Regex("([-+]?[0-9]+)[s|S]");
        @NotNull
        private static final Regex INTEGER = new Regex("([-+]?[0-9]+)");
        @NotNull
        private static final Regex DOUBLE_UNTYPED = new Regex("([-+]?[0-9]*\\.?[0-9]+)");
        @NotNull
        private static final Regex ROUGH_PATTERN = new Regex("[-+]?[0-9]*\\.?[0-9]*[dDbBfFlLsS]?");

        private Patterns() {
        }

        @NotNull
        public final Regex getDOUBLE() {
            return DOUBLE;
        }

        @NotNull
        public final Regex getFLOAT() {
            return FLOAT;
        }

        @NotNull
        public final Regex getBYTE() {
            return BYTE;
        }

        @NotNull
        public final Regex getLONG() {
            return LONG;
        }

        @NotNull
        public final Regex getSHORT() {
            return SHORT;
        }

        @NotNull
        public final Regex getINTEGER() {
            return INTEGER;
        }

        @NotNull
        public final Regex getDOUBLE_UNTYPED() {
            return DOUBLE_UNTYPED;
        }

        @NotNull
        public final Regex getROUGH_PATTERN() {
            return ROUGH_PATTERN;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0001\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\bJ\r\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\bJ\u0015\u0010\r\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0012\u0010\u000eJ\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0013\u0010\u000eJ\u0015\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J!\u0010\u0019\u001a\u00020\u00022\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000f0\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010 \u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u0002\u00a2\u0006\u0004\b \u0010!R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\"\u001a\u0004\b#\u0010$R\"\u0010%\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001d\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000b0+8\u0006\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\u00a8\u00060"}, d2={"Lmoe/nea/firmament/util/LegacyTagParser$StringRacer;", "", "", "backing", "<init>", "(Ljava/lang/String;)V", "", "pushState", "()V", "popState", "discardState", "", "count", "peek", "(I)Ljava/lang/String;", "", "finished", "()Z", "peekReq", "consumeCountReq", "string", "tryConsume", "(Ljava/lang/String;)Z", "Lkotlin/Function1;", "shouldConsumeThisString", "consumeWhile", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/String;", "search", "errorMessage", "expect", "(Ljava/lang/String;Ljava/lang/String;)V", "", "error", "(Ljava/lang/String;)Ljava/lang/Void;", "Ljava/lang/String;", "getBacking", "()Ljava/lang/String;", "idx", "I", "getIdx", "()I", "setIdx", "(I)V", "Ljava/util/Stack;", "stack", "Ljava/util/Stack;", "getStack", "()Ljava/util/Stack;", "Firmament"})
    public static final class StringRacer {
        @NotNull
        private final String backing;
        private int idx;
        @NotNull
        private final Stack<Integer> stack;

        public StringRacer(@NotNull String backing) {
            Intrinsics.checkNotNullParameter((Object)backing, (String)"backing");
            this.backing = backing;
            this.stack = new Stack();
        }

        @NotNull
        public final String getBacking() {
            return this.backing;
        }

        public final int getIdx() {
            return this.idx;
        }

        public final void setIdx(int n) {
            this.idx = n;
        }

        @NotNull
        public final Stack<Integer> getStack() {
            return this.stack;
        }

        public final void pushState() {
            this.stack.push(this.idx);
        }

        public final void popState() {
            Integer n = this.stack.pop();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"pop(...)");
            this.idx = ((Number)n).intValue();
        }

        public final void discardState() {
            this.stack.pop();
        }

        @NotNull
        public final String peek(int count) {
            String string = this.backing.substring(Math.min(this.idx, this.backing.length()), Math.min(this.idx + count, this.backing.length()));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }

        public final boolean finished() {
            return ((CharSequence)this.peek(1)).length() == 0;
        }

        @Nullable
        public final String peekReq(int count) {
            String p = this.peek(count);
            if (p.length() != count) {
                return null;
            }
            return p;
        }

        @Nullable
        public final String consumeCountReq(int count) {
            String p = this.peekReq(count);
            if (p != null) {
                this.idx += count;
            }
            return p;
        }

        public final boolean tryConsume(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            String p = this.peek(string.length());
            if (!Intrinsics.areEqual((Object)p, (Object)string)) {
                return false;
            }
            this.idx += p.length();
            return true;
        }

        @NotNull
        public final String consumeWhile(@NotNull Function1<? super String, Boolean> shouldConsumeThisString) {
            Intrinsics.checkNotNullParameter(shouldConsumeThisString, (String)"shouldConsumeThisString");
            Object lastString = "";
            String nextString;
            while (((Boolean)shouldConsumeThisString.invoke((Object)(nextString = (String)lastString + this.peek(1)))).booleanValue()) {
                int n = this.idx;
                this.idx = n + 1;
                lastString = nextString;
            }
            return lastString;
        }

        public final void expect(@NotNull String search, @NotNull String errorMessage) {
            Intrinsics.checkNotNullParameter((Object)search, (String)"search");
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
            if (!this.tryConsume(search)) {
                this.error(errorMessage);
                throw new KotlinNothingValueException();
            }
        }

        @NotNull
        public final Void error(@NotNull String errorMessage) {
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
            throw new TagParsingException(this.backing, this.idx, errorMessage);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\b\u0018\u00002\u00060\u0001j\u0002`\u0002B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000bJ.\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\rJ\u0010\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u000bR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0018\u001a\u0004\b\u0019\u0010\u000bR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001a\u001a\u0004\b\u001b\u0010\rR\u0017\u0010\u0007\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0018\u001a\u0004\b\u001c\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lmoe/nea/firmament/util/LegacyTagParser$TagParsingException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "", "baseString", "", "offset", "mes0", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "component1", "()Ljava/lang/String;", "component2", "()I", "component3", "copy", "(Ljava/lang/String;ILjava/lang/String;)Lmoe/nea/firmament/util/LegacyTagParser$TagParsingException;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "Ljava/lang/String;", "getBaseString", "I", "getOffset", "getMes0", "Firmament"})
    public static final class TagParsingException
    extends Exception {
        @NotNull
        private final String baseString;
        private final int offset;
        @NotNull
        private final String mes0;

        public TagParsingException(@NotNull String baseString, int offset, @NotNull String mes0) {
            Intrinsics.checkNotNullParameter((Object)baseString, (String)"baseString");
            Intrinsics.checkNotNullParameter((Object)mes0, (String)"mes0");
            super(mes0 + " at " + offset + " in `" + baseString + "`.");
            this.baseString = baseString;
            this.offset = offset;
            this.mes0 = mes0;
        }

        @NotNull
        public final String getBaseString() {
            return this.baseString;
        }

        public final int getOffset() {
            return this.offset;
        }

        @NotNull
        public final String getMes0() {
            return this.mes0;
        }

        @NotNull
        public final String component1() {
            return this.baseString;
        }

        public final int component2() {
            return this.offset;
        }

        @NotNull
        public final String component3() {
            return this.mes0;
        }

        @NotNull
        public final TagParsingException copy(@NotNull String baseString, int offset, @NotNull String mes0) {
            Intrinsics.checkNotNullParameter((Object)baseString, (String)"baseString");
            Intrinsics.checkNotNullParameter((Object)mes0, (String)"mes0");
            return new TagParsingException(baseString, offset, mes0);
        }

        public static /* synthetic */ TagParsingException copy$default(TagParsingException tagParsingException, String string, int n, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = tagParsingException.baseString;
            }
            if ((n2 & 2) != 0) {
                n = tagParsingException.offset;
            }
            if ((n2 & 4) != 0) {
                string2 = tagParsingException.mes0;
            }
            return tagParsingException.copy(string, n, string2);
        }

        @Override
        @NotNull
        public String toString() {
            return "TagParsingException(baseString=" + this.baseString + ", offset=" + this.offset + ", mes0=" + this.mes0 + ")";
        }

        public int hashCode() {
            int result = this.baseString.hashCode();
            result = result * 31 + Integer.hashCode(this.offset);
            result = result * 31 + this.mes0.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TagParsingException)) {
                return false;
            }
            TagParsingException tagParsingException = (TagParsingException)other;
            if (!Intrinsics.areEqual((Object)this.baseString, (Object)tagParsingException.baseString)) {
                return false;
            }
            if (this.offset != tagParsingException.offset) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.mes0, (Object)tagParsingException.mes0);
        }
    }
}

