/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.gui.config.storage;

import java.io.Closeable;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.path.OnErrorResult;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import moe.nea.firmament.Firmament;
import org.apache.commons.io.output.StringBuilderWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\b\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\u0006J\u0015\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\f\u0010\u0006J\u001d\u0010\u000f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u000f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0006J\u0015\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J!\u0010\u0017\u001a\u00020\u00072\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00070\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0019\u0010\tJ\u001d\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001a\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0004\b \u0010!J\u001a\u0010%\u001a\u00020$2\b\u0010#\u001a\u0004\u0018\u00010\"H\u00d6\u0003\u00a2\u0006\u0004\b%\u0010&J\u0010\u0010(\u001a\u00020'H\u00d6\u0001\u00a2\u0006\u0004\b(\u0010)J\u0010\u0010*\u001a\u00020\u0003H\u00d6\u0001\u00a2\u0006\u0004\b*\u0010\u001fR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010+\u001a\u0004\b,\u0010\u001fR\u001f\u0010.\u001a\n -*\u0004\u0018\u00010\u00110\u00118\u0006\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u00101R\u001f\u00102\u001a\n -*\u0004\u0018\u00010\u00110\u00118\u0006\u00a2\u0006\f\n\u0004\b2\u0010/\u001a\u0004\b3\u00101R\u001b\u00106\u001a\u000604j\u0002`58\u0006\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b8\u00109R\"\u0010:\u001a\u00020$8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?\u00a8\u0006@"}, d2={"Lmoe/nea/firmament/gui/config/storage/ConfigLoadContext;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "", "loadId", "<init>", "(Ljava/lang/String;)V", "", "markShouldSaveLogBuffer", "()V", "message", "logDebug", "logInfo", "", "exception", "logError", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "Ljava/nio/file/Path;", "path", "ensureWritable", "(Ljava/nio/file/Path;)V", "Lkotlin/Function1;", "block", "use", "(Lkotlin/jvm/functions/Function1;)V", "close", "folder", "string", "createBackup", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "component1", "()Ljava/lang/String;", "copy", "(Ljava/lang/String;)Lmoe/nea/firmament/gui/config/storage/ConfigLoadContext;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getLoadId", "kotlin.jvm.PlatformType", "backupPath", "Ljava/nio/file/Path;", "getBackupPath", "()Ljava/nio/file/Path;", "logFile", "getLogFile", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "logBuffer", "Ljava/lang/StringBuilder;", "getLogBuffer", "()Ljava/lang/StringBuilder;", "shouldSaveLogBuffer", "Z", "getShouldSaveLogBuffer", "()Z", "setShouldSaveLogBuffer", "(Z)V", "Firmament"})
public final class ConfigLoadContext
implements AutoCloseable {
    @NotNull
    private final String loadId;
    private final Path backupPath;
    private final Path logFile;
    @NotNull
    private final StringBuilder logBuffer;
    private boolean shouldSaveLogBuffer;

    public ConfigLoadContext(@NotNull String loadId) {
        Intrinsics.checkNotNullParameter((Object)loadId, (String)"loadId");
        this.loadId = loadId;
        Path path = Paths.get("backups", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        this.backupPath = path.resolve("firmament").resolve("config-" + this.loadId).toAbsolutePath();
        Path path2 = Paths.get("logs", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        this.logFile = path2.resolve("firmament").resolve("config-" + this.loadId + ".log").toAbsolutePath();
        this.logBuffer = new StringBuilder();
    }

    @NotNull
    public final String getLoadId() {
        return this.loadId;
    }

    public final Path getBackupPath() {
        return this.backupPath;
    }

    public final Path getLogFile() {
        return this.logFile;
    }

    @NotNull
    public final StringBuilder getLogBuffer() {
        return this.logBuffer;
    }

    public final boolean getShouldSaveLogBuffer() {
        return this.shouldSaveLogBuffer;
    }

    public final void setShouldSaveLogBuffer(boolean bl) {
        this.shouldSaveLogBuffer = bl;
    }

    public final void markShouldSaveLogBuffer() {
        this.shouldSaveLogBuffer = true;
    }

    public final void logDebug(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        StringBuilder stringBuilder = this.logBuffer.append("[DEBUG] ").append(message);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        stringBuilder.append('\n');
    }

    public final void logInfo(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (Firmament.INSTANCE.getDEBUG()) {
            Firmament.INSTANCE.getLogger().info("[ConfigUpgrade] " + message);
        }
        StringBuilder stringBuilder = this.logBuffer.append("[INFO] ").append(message);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        stringBuilder.append('\n');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void logError(@NotNull String message, @NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.markShouldSaveLogBuffer();
        if (Firmament.INSTANCE.getDEBUG()) {
            Firmament.INSTANCE.getLogger().error("[ConfigUpgrade] " + message, exception);
        }
        StringBuilder stringBuilder = this.logBuffer.append("[ERROR] ").append(message);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        stringBuilder.append('\n');
        Closeable closeable = new PrintWriter((Writer)new StringBuilderWriter(this.logBuffer));
        Throwable throwable = null;
        try {
            PrintWriter it = (PrintWriter)closeable;
            boolean bl = false;
            exception.printStackTrace(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.logBuffer.append('\n');
    }

    public final void logError(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.markShouldSaveLogBuffer();
        Firmament.INSTANCE.getLogger().error("[ConfigUpgrade] " + message);
        StringBuilder stringBuilder = this.logBuffer.append("[ERROR] ").append(message);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        stringBuilder.append('\n');
    }

    public final void ensureWritable(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        PathsKt.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void use(@NotNull Function1<? super ConfigLoadContext, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        try {
            block.invoke((Object)this);
        }
        catch (Exception ex) {
            this.logError("Caught exception on CLC", ex);
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        this.logInfo("Closing out config load.");
        if (this.shouldSaveLogBuffer) {
            try {
                Path path = this.logFile;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"logFile");
                this.ensureWritable(path);
                Path path2 = this.logFile;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"logFile");
                String string = this.logBuffer.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                PathsKt.writeText$default((Path)path2, (CharSequence)string, null, (OpenOption[])new OpenOption[0], (int)2, null);
            }
            catch (Exception ex) {
                this.logError("Could not save config load log", ex);
            }
        }
    }

    public final void createBackup(@NotNull Path folder, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Path backupDestination = this.backupPath.resolve(string + "-" + System.currentTimeMillis());
        this.logError("Creating backup of " + folder + " in " + backupDestination);
        Intrinsics.checkNotNull((Object)backupDestination);
        PathsKt.copyToRecursively((Path)folder, (Path)PathsKt.createParentDirectories((Path)backupDestination, (FileAttribute[])new FileAttribute[0]), (arg_0, arg_1, arg_2) -> ConfigLoadContext.createBackup$lambda$1(this, arg_0, arg_1, arg_2), (boolean)false, (boolean)false);
    }

    @NotNull
    public final String component1() {
        return this.loadId;
    }

    @NotNull
    public final ConfigLoadContext copy(@NotNull String loadId) {
        Intrinsics.checkNotNullParameter((Object)loadId, (String)"loadId");
        return new ConfigLoadContext(loadId);
    }

    public static /* synthetic */ ConfigLoadContext copy$default(ConfigLoadContext configLoadContext, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = configLoadContext.loadId;
        }
        return configLoadContext.copy(string);
    }

    @NotNull
    public String toString() {
        return "ConfigLoadContext(loadId=" + this.loadId + ")";
    }

    public int hashCode() {
        return this.loadId.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConfigLoadContext)) {
            return false;
        }
        ConfigLoadContext configLoadContext = (ConfigLoadContext)other;
        return Intrinsics.areEqual((Object)this.loadId, (Object)configLoadContext.loadId);
    }

    private static final OnErrorResult createBackup$lambda$1(ConfigLoadContext this$0, Path source, Path target, Exception exception) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this$0.logError("Failed to copy subtree " + source + " to " + target, exception);
        return OnErrorResult.SKIP_SUBTREE;
    }
}

