/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.features.world;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import moe.nea.firmament.deps.repo.constants.Islands;
import moe.nea.firmament.events.SkyblockServerUpdateEvent;
import moe.nea.firmament.events.TickEvent;
import moe.nea.firmament.events.WorldRenderLastEvent;
import moe.nea.firmament.features.world.NavigableWaypoint;
import moe.nea.firmament.features.world.NavigationHelperKt;
import moe.nea.firmament.repo.RepoManager;
import moe.nea.firmament.util.MC;
import moe.nea.firmament.util.SBData;
import moe.nea.firmament.util.SkyBlockIsland;
import moe.nea.firmament.util.TestUtil;
import moe.nea.firmament.util.WarpUtil;
import moe.nea.firmament.util.render.RenderInWorldContext;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u0003J5\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\rH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0019\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0019\u0010\u0003R.\u0010\u001c\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001a8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R(\u0010\"\u001a\u0004\u0018\u00010\u00102\b\u0010\u001b\u001a\u0004\u0018\u00010\u00108\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R\u0015\u0010(\u001a\u00020\n*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0015\u0010\u000b\u001a\u00020\n*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b)\u0010'R\u0015\u0010-\u001a\u00020**\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006."}, d2={"Lmoe/nea/firmament/features/world/NavigationHelper;", "", "<init>", "()V", "Lmoe/nea/firmament/events/SkyblockServerUpdateEvent;", "event", "", "onWorldSwitch", "(Lmoe/nea/firmament/events/SkyblockServerUpdateEvent;)V", "recalculateRoute", "Lmoe/nea/firmament/util/SkyBlockIsland;", "fromIsland", "targetIsland", "", "visitedIslands", "", "Lmoe/nea/firmament/deps/repo/constants/Islands$Teleporter;", "findRoute", "(Lmoe/nea/firmament/util/SkyBlockIsland;Lmoe/nea/firmament/util/SkyBlockIsland;Ljava/util/Set;)Ljava/util/List;", "Lmoe/nea/firmament/events/TickEvent;", "onMovement", "(Lmoe/nea/firmament/events/TickEvent;)V", "Lmoe/nea/firmament/events/WorldRenderLastEvent;", "drawWaypoint", "(Lmoe/nea/firmament/events/WorldRenderLastEvent;)V", "tryWarpNear", "Lmoe/nea/firmament/features/world/NavigableWaypoint;", "value", "targetWaypoint", "Lmoe/nea/firmament/features/world/NavigableWaypoint;", "getTargetWaypoint", "()Lmoe/nea/firmament/features/world/NavigableWaypoint;", "setTargetWaypoint", "(Lmoe/nea/firmament/features/world/NavigableWaypoint;)V", "nextTeleporter", "Lmoe/nea/firmament/deps/repo/constants/Islands$Teleporter;", "getNextTeleporter", "()Lio/github/moulberry/repo/constants/Islands$Teleporter;", "getToIsland", "(Lio/github/moulberry/repo/constants/Islands$Teleporter;)Lmoe/nea/firmament/util/SkyBlockIsland;", "toIsland", "getFromIsland", "Lnet/minecraft/class_2338;", "getBlockPos", "(Lio/github/moulberry/repo/constants/Islands$Teleporter;)Lnet/minecraft/class_2338;", "blockPos", "Firmament"})
@SourceDebugExtension(value={"SMAP\nNavigationHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavigationHelper.kt\nmoe/nea/firmament/features/world/NavigationHelper\n+ 2 MC.kt\nmoe/nea/firmament/util/MC\n+ 3 TestUtil.kt\nmoe/nea/firmament/util/TestUtil\n*L\n1#1,122:1\n114#2:123\n106#2:125\n4#3:124\n*S KotlinDebug\n*F\n+ 1 NavigationHelper.kt\nmoe/nea/firmament/features/world/NavigationHelper\n*L\n74#1:123\n74#1:125\n74#1:124\n*E\n"})
public final class NavigationHelper {
    @NotNull
    public static final NavigationHelper INSTANCE = new NavigationHelper();
    @Nullable
    private static NavigableWaypoint targetWaypoint;
    @Nullable
    private static Islands.Teleporter nextTeleporter;

    private NavigationHelper() {
    }

    @Nullable
    public final NavigableWaypoint getTargetWaypoint() {
        return targetWaypoint;
    }

    public final void setTargetWaypoint(@Nullable NavigableWaypoint value) {
        targetWaypoint = value;
        this.recalculateRoute();
    }

    @Nullable
    public final Islands.Teleporter getNextTeleporter() {
        return nextTeleporter;
    }

    @NotNull
    public final SkyBlockIsland getToIsland(@NotNull Islands.Teleporter $this$toIsland) {
        Intrinsics.checkNotNullParameter((Object)$this$toIsland, (String)"<this>");
        String string = $this$toIsland.getTo();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTo(...)");
        return SkyBlockIsland.Companion.forMode(string);
    }

    @NotNull
    public final SkyBlockIsland getFromIsland(@NotNull Islands.Teleporter $this$fromIsland) {
        Intrinsics.checkNotNullParameter((Object)$this$fromIsland, (String)"<this>");
        String string = $this$fromIsland.getFrom();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFrom(...)");
        return SkyBlockIsland.Companion.forMode(string);
    }

    @NotNull
    public final class_2338 getBlockPos(@NotNull Islands.Teleporter $this$blockPos) {
        Intrinsics.checkNotNullParameter((Object)$this$blockPos, (String)"<this>");
        return new class_2338((int)$this$blockPos.getX(), (int)$this$blockPos.getY(), (int)$this$blockPos.getZ());
    }

    public final void onWorldSwitch(@NotNull SkyblockServerUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.recalculateRoute();
    }

    public final void recalculateRoute() {
        List<Islands.Teleporter> route;
        NavigableWaypoint tp = targetWaypoint;
        SkyBlockIsland currentIsland = SBData.INSTANCE.getSkyblockLocation();
        if (tp == null || currentIsland == null) {
            nextTeleporter = null;
            return;
        }
        List<Islands.Teleporter> list = route = this.findRoute(currentIsland, tp.getIsland(), new LinkedHashSet());
        nextTeleporter = list != null ? list.get(0) : null;
    }

    private final List<Islands.Teleporter> findRoute(SkyBlockIsland fromIsland, SkyBlockIsland targetIsland, Set<SkyBlockIsland> visitedIslands) {
        List<Islands.Teleporter> shortestChain = null;
        for (Islands.Teleporter it : RepoManager.INSTANCE.getNeuRepo().getConstants().getIslands().getTeleporters()) {
            List<Islands.Teleporter> nextRoute;
            if (visitedIslands.contains(this.getToIsland(it)) || !Intrinsics.areEqual((Object)this.getFromIsland(it), (Object)fromIsland)) continue;
            if (Intrinsics.areEqual((Object)this.getToIsland(it), (Object)targetIsland)) {
                Object[] objectArray = new Islands.Teleporter[]{it};
                return CollectionsKt.mutableListOf((Object[])objectArray);
            }
            visitedIslands.add(fromIsland);
            if (this.findRoute(this.getToIsland(it), targetIsland, visitedIslands) == null) continue;
            nextRoute.add(0, it);
            if (shortestChain == null || shortestChain.size() > nextRoute.size()) {
                shortestChain = nextRoute;
            }
            visitedIslands.remove(fromIsland);
        }
        return shortestChain;
    }

    public final void onMovement(@NotNull TickEvent event) {
        class_746 class_7462;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        NavigableWaypoint navigableWaypoint = targetWaypoint;
        if (navigableWaypoint == null) {
            return;
        }
        NavigableWaypoint tp = navigableWaypoint;
        MC this_$iv = MC.INSTANCE;
        boolean $i$f$getPlayer = false;
        TestUtil this_$iv$iv = TestUtil.INSTANCE;
        boolean $i$f$unlessTesting = false;
        if (TestUtil.isInTest) {
            class_7462 = null;
        } else {
            boolean bl = false;
            MC this_$iv$iv2 = MC.INSTANCE;
            boolean $i$f$getInstance = false;
            class_7462 = class_310.method_1551().field_1724;
        }
        if (class_7462 == null) {
            return;
        }
        class_746 p = class_7462;
        if (p.method_5707(tp.getPosition().method_46558()) < 25.0) {
            this.setTargetWaypoint(null);
        }
    }

    public final void drawWaypoint(@NotNull WorldRenderLastEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        NavigableWaypoint navigableWaypoint = targetWaypoint;
        if (navigableWaypoint == null) {
            return;
        }
        NavigableWaypoint tp = navigableWaypoint;
        Islands.Teleporter nt = nextTeleporter;
        RenderInWorldContext.Companion.renderInWorld(event, (Function1<? super RenderInWorldContext, Unit>)((Function1)arg_0 -> NavigationHelper.drawWaypoint$lambda$0(nt, tp, arg_0)));
    }

    public final void tryWarpNear() {
        NavigableWaypoint tp = targetWaypoint;
        if (tp == null) {
            class_5250 class_52502 = class_2561.method_43470((String)"Could not find a waypoint to warp you to. Select one first.");
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
            MC.INSTANCE.sendChat((class_2561)class_52502);
            return;
        }
        WarpUtil.INSTANCE.teleportToNearestWarp(tp.getIsland(), NavigationHelperKt.asPositionView((class_2382)tp.getPosition()));
    }

    private static final Unit drawWaypoint$lambda$0(Islands.Teleporter $nt, NavigableWaypoint $tp, RenderInWorldContext $this$renderInWorld) {
        Intrinsics.checkNotNullParameter((Object)$this$renderInWorld, (String)"$this$renderInWorld");
        if ($nt != null) {
            class_2561[] class_2561Array = new class_2561[]{class_2561.method_43470((String)("Teleporter to " + INSTANCE.getToIsland($nt).getUserFriendlyName())), class_2561.method_43470((String)("(towards " + $tp.getName() + "\u00a7f)"))};
            $this$renderInWorld.waypoint(INSTANCE.getBlockPos($nt), class_2561Array);
        } else if (Intrinsics.areEqual((Object)$tp.getIsland(), (Object)SBData.INSTANCE.getSkyblockLocation())) {
            class_2561[] class_2561Array = new class_2561[]{class_2561.method_43470((String)$tp.getName())};
            $this$renderInWorld.waypoint($tp.getPosition(), class_2561Array);
        }
        return Unit.INSTANCE;
    }
}

