/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.deps.repo;

import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import moe.nea.firmament.deps.repo.NEURepository;
import moe.nea.firmament.deps.repo.NEURepositoryException;

public class NEURepoFile {
    private NEURepository repository;
    private Path fsPath;

    public String getPath() {
        return this.repository.baseFolder.relativize(this.fsPath).toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T json(TypeToken<T> type) throws NEURepositoryException {
        try (BufferedReader reader = Files.newBufferedReader(this.fsPath, StandardCharsets.UTF_8);){
            Object object = this.repository.gson.fromJson((Reader)reader, type.getType());
            return (T)object;
        }
        catch (IOException | SecurityException e2) {
            throw new NEURepositoryException(this.getPath(), "Could not read file", e2);
        }
        catch (JsonSyntaxException e3) {
            throw new NEURepositoryException(this.getPath(), "Invalid Json Syntax", e3);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T json(Class<T> $class) throws NEURepositoryException {
        try (BufferedReader reader = Files.newBufferedReader(this.fsPath, StandardCharsets.UTF_8);){
            Object object = this.repository.gson.fromJson((Reader)reader, $class);
            return (T)object;
        }
        catch (IOException | SecurityException e2) {
            throw new NEURepositoryException(this.getPath(), "Could not read file", e2);
        }
        catch (JsonSyntaxException e3) {
            throw new NEURepositoryException(this.getPath(), "Invalid Json Syntax", e3);
        }
    }

    public InputStream stream() throws NEURepositoryException {
        try {
            return Files.newInputStream(this.fsPath, new OpenOption[0]);
        }
        catch (IOException | SecurityException e2) {
            throw new NEURepositoryException(this.getPath(), "Could not read file", e2);
        }
    }

    public boolean isFile() {
        return Files.isRegularFile(this.fsPath, new LinkOption[0]);
    }

    NEURepoFile(NEURepository repository, Path fsPath) {
        this.repository = repository;
        this.fsPath = fsPath;
    }

    public NEURepository getRepository() {
        return this.repository;
    }

    public Path getFsPath() {
        return this.fsPath;
    }
}

