/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.deps.moulconfig.internal;

import moe.nea.firmament.deps.moulconfig.gui.GuiImmediateContext;
import org.jetbrains.annotations.NotNull;

public final class Rect {
    private final int left;
    private final int top;
    private final int right;
    private final int bottom;

    public static Rect ofDot(int x, int y) {
        return Rect.ofXYWH(x, y, 0, 0);
    }

    public static Rect ofLTRB(int left, int top, int right, int bottom) {
        return new Rect(left, top, right, bottom);
    }

    public static Rect ofXYWH(int x, int y, int w, int h) {
        return new Rect(x, y, x + w, y + h);
    }

    public static Rect ofGuiImmediateContext(@NotNull GuiImmediateContext context) {
        return Rect.ofXYWH(context.getRenderOffsetX(), context.getRenderOffsetY(), context.getWidth(), context.getHeight());
    }

    public int getX() {
        return this.left;
    }

    public int getY() {
        return this.top;
    }

    public int getW() {
        return this.right - this.left;
    }

    public int getH() {
        return this.bottom - this.top;
    }

    public Rect roughMerge(Rect other) {
        return new Rect(Math.min(this.left, other.left), Math.min(this.top, other.top), Math.max(this.right, other.right), Math.max(this.bottom, other.bottom));
    }

    public boolean includesPoint(int x, int y) {
        return this.left <= x && x <= this.right && this.top <= y && y <= this.bottom;
    }

    public Rect includePoint(int x, int y) {
        return new Rect(Math.min(this.left, x), Math.min(this.top, y), Math.max(this.right, x), Math.max(this.bottom, y));
    }

    public Rect boundedBy(Rect other) {
        int l = Math.max(this.left, other.left);
        int t = Math.max(this.top, other.top);
        return new Rect(l, t, Math.max(l, Math.min(this.right, other.right)), Math.max(t, Math.min(this.bottom, other.bottom)));
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public int getRight() {
        return this.right;
    }

    public int getBottom() {
        return this.bottom;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rect)) {
            return false;
        }
        Rect other = (Rect)o;
        if (this.getLeft() != other.getLeft()) {
            return false;
        }
        if (this.getTop() != other.getTop()) {
            return false;
        }
        if (this.getRight() != other.getRight()) {
            return false;
        }
        return this.getBottom() == other.getBottom();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLeft();
        result = result * 59 + this.getTop();
        result = result * 59 + this.getRight();
        result = result * 59 + this.getBottom();
        return result;
    }

    public String toString() {
        return "Rect(left=" + this.getLeft() + ", top=" + this.getTop() + ", right=" + this.getRight() + ", bottom=" + this.getBottom() + ")";
    }

    private Rect(int left, int top, int right, int bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }
}

