/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.result;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.shedaniel.rei.impl.client.search.IntRange;
import me.shedaniel.rei.impl.client.search.argument.type.MatchType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ArgumentApplicableResult {
    private static final ArgumentApplicableResult UNMATCHED = new ArgumentApplicableResult(MatchType.UNMATCHED, null, false);
    private MatchType type;
    @Nullable
    private final String text;
    private final boolean preserveCasing;
    private boolean usingGrammar = true;
    private final List<IntRange> grammarRanges = new ArrayList<IntRange>();

    private ArgumentApplicableResult(MatchType type, @Nullable String text, boolean preserveCasing) {
        this.type = type;
        this.text = text;
        this.preserveCasing = preserveCasing;
    }

    public static ArgumentApplicableResult notApplicable() {
        return UNMATCHED;
    }

    public static ArgumentApplicableResult applyInverted(String text) {
        return ArgumentApplicableResult.apply(text, false).invert();
    }

    public static ArgumentApplicableResult applyInverted(String text, boolean preserveCasing) {
        return ArgumentApplicableResult.apply(text, preserveCasing).invert();
    }

    public static ArgumentApplicableResult apply(String text) {
        return ArgumentApplicableResult.apply(text, false);
    }

    public static ArgumentApplicableResult apply(String text, boolean preserveCasing) {
        return new ArgumentApplicableResult(MatchType.MATCHED, Objects.requireNonNull(text), preserveCasing);
    }

    public static ArgumentApplicableResult result(String text, boolean preserveCasing, boolean inverted) {
        return new ArgumentApplicableResult(!inverted ? MatchType.MATCHED : MatchType.INVERT_MATCHED, Objects.requireNonNull(text), preserveCasing);
    }

    public List<IntRange> grammarRanges() {
        return this.grammarRanges;
    }

    public ArgumentApplicableResult grammar(int start, int end) {
        if (end - 1 >= start) {
            this.grammarRanges.add(IntRange.of(start, end - 1));
        }
        return this;
    }

    public ArgumentApplicableResult invert() {
        if (this.isApplicable()) {
            this.type = this.isInverted() ? MatchType.MATCHED : MatchType.INVERT_MATCHED;
        }
        return this;
    }

    public boolean isApplicable() {
        return this.type != MatchType.UNMATCHED;
    }

    public boolean isInverted() {
        return this.type == MatchType.INVERT_MATCHED;
    }

    public ArgumentApplicableResult notUsingGrammar() {
        this.usingGrammar = false;
        return this;
    }

    public boolean isUsingGrammar() {
        return this.usingGrammar;
    }

    public boolean shouldPreserveCasing() {
        return this.preserveCasing;
    }

    @Nullable
    public String getText() {
        return this.text;
    }

    public MatchType getType() {
        return this.type;
    }
}

